#include "Mix/Class/Graphics/DX11/Device.h"

#include "Mix/File/IManager.h"
#include "Mix/File/ILoader.h"
#include "Mix/File/IReader.h"
#include "Mix/File/IWriter.h"

#include "Mix/Class/UserFile.h"
#include "Mix/Class/Memory/Buffer.h"
#include "Mix/Class/Graphics/DX11/VertexLayout.h"
#include "Mix/Class/Graphics/DX11/HullShader.h"
#include "Mix/Class/Graphics/DX11/DomainShader.h"
#include "Mix/Class/Graphics/DX11/GeometryShader.h"
#include "Mix/Class/Graphics/DX11/VertexShader.h"
#include "Mix/Class/Graphics/DX11/PixelShader.h"
#include "Mix/Class/Graphics/DX11/ShaderConstant.h"
#include "Mix/Class/Graphics/DX11/VertexBuffer.h"
#include "Mix/Class/Graphics/DX11/IndexBuffer.h"
#include "Mix/Class/Graphics/DX11/Texture2D.h"
#include "Mix/Class/Graphics/DX11/TextureCube.h"
#include "Mix/Class/Graphics/DX11/TextureTarget.h"
#include "Mix/Class/Graphics/DX11/TextureDepth.h"
#include "Mix/Class/Graphics/DX11/Query.h"

namespace Mix{ namespace Graphics{ namespace DX11{

const wchar_t* Device::FAILED_INITIALIZE            = L"OtBbNXfoCX( DirectX11 )̏Ɏs";
const wchar_t* Device::FAILED_COMPILEVERTEXSHADER   = L"o[ebNXVF[_[̃RpCɎs";
const wchar_t* Device::FAILED_COMPILEPIXELSHADER    = L"sNZVF[_[̃RpCɎs";
const wchar_t* Device::FAILED_CREATEVERTEXLAYOUT    = L"o[ebNXCAEg̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEHULLSHADER      = L"nVF[_[̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEDOMAINSHADER    = L"hCVF[_[̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEGEOMETRYSHADER	= L"WIgVF[_[̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEVERTEXSHADER    = L"o[ebNXVF[_[̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEPIXELSHADER     = L"sNZVF[_[̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATESHADERCONST     = L"VF[_[萔̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEVERTEXBUFFER    = L"o[ebNXobt@̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEINDEXBUFFER     = L"CfbNXobt@̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATETEXTURE         = L"eNX`̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATECUBETEXTURE     = L"L[ueNX`̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEDYNAMICTEXTURE  = L"_Ci~bNeNX`̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATETARGETTEXTURE   = L"^[QbgeNX`̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEDEPTHTEXTURE    = L"fvXeNX`̍쐬Ɏs";
const wchar_t* Device::FAILED_CREATEQUERY           = L"NG̍쐬Ɏs";
const wchar_t* Device::FAILED_RESIZEBACKBUFFER      = L"obNobt@̃TCYɎs";
const wchar_t* Device::FAILED_DRAW                  = L"`( Draw )Ɏs";
const wchar_t* Device::FAILED_DRAWINDEXED           = L"`( DrawIndexed )Ɏs";
const wchar_t* Device::FAILED_SAVESCREENSHOT        = L"XN[Vbg̕ۑɎs";
const wchar_t* Device::FAILED_SAVETEXTURE           = L"eNX`̕ۑɎs";

//D3DUgeLXg
const wchar_t* Device::D3DResultTextArray[12] =
{
	L"t@C܂ł",
	L"Xe[gIuWFNg̈ӂ̃CX^X܂",
	L"r[IuWFNg̈ӂ̃CX^X܂",
	L"\[XƂ ID3D11Device::CreateDeferredContext ̌Ăяo܂ ID3D11DeviceContext::FinishCommandList ̌ĂяǒōŏɌĂяo ID3D11DeviceContext::Map  D3D11_MAP_WRITE_DISCARD ł͂܂ł",
	L"\bȟĂяoł(\bh̃p[^[Lȃ|C^[łȂ\܂)",
	L"̃T[tFXƂ̊Ԃŏ]ĂȑÕrbgZsSł",
	L"fobO C[LɂăfoCX쐬悤Ƃ܂AY郌C[CXg[Ă܂",
	L"ȃp[^[n܂",
	L"VXesĂ܂",
	L"ɏꂽ̂́AW̊֐lłB(s)",
	L"G[͔Ă܂",
	L"sȃG[܂",
};

//D3Do[ebNXCAEgtH[}bge[u
const DXGI_FORMAT Device::D3DVLFormatTable[Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX] =
{
	DXGI_FORMAT_R32_FLOAT,
	DXGI_FORMAT_R32G32_FLOAT,
	DXGI_FORMAT_R32G32B32_FLOAT,
	DXGI_FORMAT_R32G32B32A32_FLOAT,
	DXGI_FORMAT_R8G8B8A8_UINT,
	DXGI_FORMAT_R16G16_SINT,
	DXGI_FORMAT_R16G16B16A16_SINT,
	DXGI_FORMAT_R8G8B8A8_UNORM,
	DXGI_FORMAT_R16G16_SNORM,
	DXGI_FORMAT_R16G16B16A16_SNORM,
	DXGI_FORMAT_R16G16_UNORM,
	DXGI_FORMAT_R16G16B16A16_UNORM,
	DXGI_FORMAT_R16G16_FLOAT,
	DXGI_FORMAT_R16G16B16A16_FLOAT,
};

 //D3Do[ebNXCAEgZ}eBbNe[u
const char* Device::D3DVLSemanticTable[Mix::Graphics::VERTEX_ELEMENT_SEMANTIC_MAX] =
{
	"POSITION",
	"BLENDWEIGHT",
	"BLENDINDICES",
	"NORMAL",
	"PSIZE",
	"TEXCOORD",
	"TANGENT",
	"BINORMAL",
	"COLOR",
};

//D3Dv~eBug|We[u
const D3D11_PRIMITIVE_TOPOLOGY Device::D3DPrimitiveTopologyTable[Mix::Graphics::PT_MAX] =
{
	D3D11_PRIMITIVE_TOPOLOGY_POINTLIST,
	D3D11_PRIMITIVE_TOPOLOGY_LINELIST,
	D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP,
	D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST,
	D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP,
};

//D3DNGfXNvVe[u
const D3D11_QUERY_DESC Device::D3DQueryDescTable[Mix::Graphics::QT_MAX] =
{
	{ D3D11_QUERY_EVENT, 0 },
	{ D3D11_QUERY_OCCLUSION, 0 },
};

//D3DNGe[u
const wchar_t* Device::D3DQueryTextTable[Mix::Graphics::QT_MAX] =
{
	L"EVENT",
	L"OCCLUSION",
};

//D3DCfbNXtH[}bgeLXge[u
const wchar_t* Device::D3DIndexFormatTextTable[Mix::Graphics::IT_MAX] =
{
	L"DXGI_FORMAT_R16_UINT",
	L"DXGI_FORMAT_R32_UINT",
};

//D3DCfbNXtH[}bge[u
const DXGI_FORMAT Device::D3DIndexFormatTable[Mix::Graphics::IT_MAX] =
{
	DXGI_FORMAT_R16_UINT,
	DXGI_FORMAT_R32_UINT,
};

//CfbNXXgChe[u
const UInt32 Device::D3DIndexStrideTable[Mix::Graphics::IT_MAX] =
{
	2,
	4,
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Device
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Device* Device::CreateInstance( Boolean bWaitVSync )
{
	return new Device( bWaitVSync );
}

Device::Device( Boolean bWaitVSync ) : Common::Device( bWaitVSync ),
m_pDXGIFactory( NULL ),
m_pDXGIAdapter( NULL ),
m_pDXGIOutput( NULL ),
m_pDXGISwapChain( NULL ),
m_pBackBuffer( NULL ),
m_pBackBufferView( NULL ),
m_pD3DDevice( NULL ),
m_pD3DDeviceContext( NULL ),
m_bWindowed( True ),
m_DrawPrimitiveCount( 0 )
{
	UInt32 i;
	UInt32 j;
	UInt32 k;

	for( i = 0; i < Mix::Graphics::FILL_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::CULL_MAX; j++ )
		{
			for( k = 0; k < 2; k++ )
			{
				m_pRasterizerStateArray[i][j][k] = NULL;
			}
		}
	}

	for( i = 0; i < 2; i++ )
	{
		for( j = 0; j < 2; j++ )
		{
			for( k = 0; k < Mix::Graphics::ZFUNC_MAX; k++ )
			{
				m_pDepthStateArray[i][j][k] = NULL;
			}
		}
	}

	for( i = 0; i < Mix::Graphics::BLEND_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::COLOR_WRITE_MASK_MAX; j++ )
		{
			m_pBlendStateArray[i][j] = NULL;
		}
	}

	for( i = 0; i < Mix::Graphics::TEXTUREFILTER_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::TEXTUREADDRESS_MAX; j++ )
		{
			m_pSamplerArray[i][j] = NULL;
		}
	}

	m_Viewport.TopLeftX = 0.0f;
	m_Viewport.TopLeftY = 0.0f;
	m_Viewport.Width = 0.0f;
	m_Viewport.Height = 0.0f;
	m_Viewport.MinDepth = 0.0f;
	m_Viewport.MaxDepth = 1.0f;

	m_RasterizeDesc.fillMode = Mix::Graphics::FILL_SOLID;
	m_RasterizeDesc.cullMode = Mix::Graphics::CULL_BACK;
	m_RasterizeDesc.bScissoring = False;
	m_RasterizeDesc.bMultisample = False;

	m_DepthDesc.bTest = True;
	m_DepthDesc.bWrite = True;
	m_DepthDesc.func = Mix::Graphics::ZFUNC_LESSEQUAL;

	m_BlendDesc.type = Mix::Graphics::BLEND_COPY;
	m_BlendDesc.colorWriteMask = Mix::Graphics::COLOR_WRITE_RGBA;

	m_TargetState.rect = Mix::Rectangle( 0, 0, 0, 0 );
	m_TargetState.pT0 = NULL;
	m_TargetState.pT1 = NULL;
	m_TargetState.pT2 = NULL;
	m_TargetState.pT3 = NULL;
	m_TargetState.pDS = NULL;

	ResetDrawState();
}

Device::~Device( void )
{
}

Boolean Device::Initialize( Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Mix::UserFile* pSysReport )
{
	MIX_ASSERT( shaderModel != Mix::Graphics::SHADER_MODEL_3 );

	const D3D_FEATURE_LEVEL featureLevelTable[] =
	{
		D3D_FEATURE_LEVEL_11_0,
		D3D_FEATURE_LEVEL_10_1,
		D3D_FEATURE_LEVEL_10_0,
	};

	const UInt32 featureLevelMax = sizeof( featureLevelTable ) / sizeof( D3D_FEATURE_LEVEL );

	const D3D11_FILL_MODE fillTable[Mix::Graphics::FILL_MAX] =
	{
		D3D11_FILL_WIREFRAME,
		D3D11_FILL_SOLID,
	};

	const D3D11_CULL_MODE cullTable[Mix::Graphics::CULL_MAX] =
	{
		D3D11_CULL_NONE,
		D3D11_CULL_FRONT,
		D3D11_CULL_BACK,
	};

	const D3D11_FILTER texFilterTable[Mix::Graphics::TEXTUREFILTER_MAX] =
	{
		D3D11_FILTER_MIN_MAG_MIP_POINT,
		D3D11_FILTER_MIN_MAG_MIP_LINEAR,
		D3D11_FILTER_ANISOTROPIC,
	};

	const UInt32 texAnisotropyTable[Mix::Graphics::TEXTUREFILTER_MAX] =
	{
		0,
		0,
		8,
	};

	const D3D11_TEXTURE_ADDRESS_MODE texAddressTable[Mix::Graphics::TEXTUREADDRESS_MAX] =
	{
		D3D11_TEXTURE_ADDRESS_WRAP,
		D3D11_TEXTURE_ADDRESS_CLAMP,
	};

	const D3D11_COMPARISON_FUNC zFuncTable[Mix::Graphics::ZFUNC_MAX] =
	{
		D3D11_COMPARISON_ALWAYS,
		D3D11_COMPARISON_NEVER,
		D3D11_COMPARISON_LESS,
		D3D11_COMPARISON_EQUAL,
		D3D11_COMPARISON_LESS_EQUAL,
		D3D11_COMPARISON_GREATER,
		D3D11_COMPARISON_NOT_EQUAL,
		D3D11_COMPARISON_GREATER_EQUAL,
	};

	const UInt8 colorWriteMaskTable[Mix::Graphics::COLOR_WRITE_MASK_MAX] =
	{
		D3D11_COLOR_WRITE_ENABLE_ALL,
		D3D11_COLOR_WRITE_ENABLE_RED | D3D11_COLOR_WRITE_ENABLE_GREEN | D3D11_COLOR_WRITE_ENABLE_BLUE,
		D3D11_COLOR_WRITE_ENABLE_ALPHA,
	};

	const Mix::Point& backBuffSize = m_pWindow->GetBaseSize();

	HRESULT ret;
	UInt32 i;
	UInt32 j;
	UInt32 k;
	UInt32 createFlags;
	UInt32 featureLevelStart;
	UInt32 featureLevelNum;
	UInt32 numMode;
	UInt32 supportFlags;
	DXGI_MODE_DESC displayMode;
	DXGI_MODE_DESC bestDisplayMode;
	Mix::Rectangle rect;
	Mix::String d3dx11ModuleName;
	D3D11CreateDeviceFunc D3D11CreateDevice;
	CreateDXGIFactoryFunc CreateDXGIFactory;

	//W[̓ǂݍ
	d3dx11ModuleName.Sprintf( L"d3dx11_%d.dll", D3DX11_SDK_VERSION );
	if( ( m_D3D11Module.Load( L"d3d11.dll" ) == True ) &&
		( m_D3D11Module.RegisterFunction( L"D3D11CreateDevice" ) == True ) &&
		( m_D3DX11Module.Load( d3dx11ModuleName.GetConstPtr() ) == True ) &&
		( m_D3DX11Module.RegisterFunction( L"D3DX11CompileFromMemory" ) == True ) &&
		( m_D3DX11Module.RegisterFunction( L"D3DX11GetImageInfoFromMemory" ) == True ) &&
		( m_D3DX11Module.RegisterFunction( L"D3DX11CreateTextureFromMemory" ) == True ) &&
		( m_D3DX11Module.RegisterFunction( L"D3DX11SaveTextureToFileW" ) == True ) &&
		( m_DXGIModule.Load( L"dxgi.dll" ) == True ) &&
		( m_DXGIModule.RegisterFunction( L"CreateDXGIFactory" ) == True ) )
	{
		D3D11CreateDevice = static_cast<D3D11CreateDeviceFunc>( m_D3D11Module.GetFunction( L"D3D11CreateDevice" ) );
		CreateDXGIFactory = static_cast<CreateDXGIFactoryFunc>( m_DXGIModule.GetFunction( L"CreateDXGIFactory" ) );
	}
	else
	{
		::MessageBoxW( m_pWindow->GetHandle(), L"DirectX11CXg[Ă܂", L"G[", MB_OK | MB_ICONSTOP );
		return False;
	}

	//t@Ng쐬
	ret = CreateDXGIFactory( __uuidof( IDXGIFactory ), reinterpret_cast<void**>( &m_pDXGIFactory ) );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateDXGIFactory %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//VXe|[g̋L^Jn
	if( pSysReport->Open() == True )
	{
		pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		pSysReport->WriteLine( L"// OtBbNX( DirectX11 )                                                                    //" );
		pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	//A_v^
	ret = m_pDXGIFactory->EnumAdapters( 0, &m_pDXGIAdapter );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIFactory::EnumAdapters %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//A_v^|[g
	if( pSysReport->Open() == True )
	{
		DXGI_ADAPTER_DESC adapterDesc;

		pSysReport->WriteLine( L"[fBXvCA_v^]" );

		if( m_pDXGIAdapter->GetDesc( &adapterDesc ) == S_OK )
		{
			pSysReport->WriteLine( L" \"%s\"", adapterDesc.Description );
			pSysReport->WriteLine( L"x_[ID 0x%08x", adapterDesc.VendorId );
			pSysReport->WriteLine( L"foCXID 0x%08x", adapterDesc.DeviceId );
			pSysReport->WriteLine( L"TuVXeID 0x%08x", adapterDesc.SubSysId );
			pSysReport->WriteLine( L"rW 0x%08x", adapterDesc.Revision );
			pSysReport->WriteLine( L"rfI %fMB", static_cast<Float32>( adapterDesc.DedicatedVideoMemory ) / 1048576.0f );
			pSysReport->WriteLine( L"VXe %fMB", static_cast<Float32>( adapterDesc.DedicatedSystemMemory ) / 1048576.0f );
			pSysReport->WriteLine( L"LVXe %fMB", static_cast<Float32>( adapterDesc.SharedSystemMemory ) / 1048576.0f );
		}
		else
		{
			pSysReport->WriteLine( L"擾ł܂ł" );
		}

		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	//foCXƃfoCXReLXg쐬
#ifdef _DEBUG
	createFlags = ( D3D11_CREATE_DEVICE_DEBUG/* | D3D11_CREATE_DEVICE_SWITCH_TO_REF*/ );
#else //_DEBUG
	createFlags = 0;
#endif //_DEBUG

	switch( shaderModel )
	{
	case Mix::Graphics::SHADER_MODEL_4:
		featureLevelStart = 1;
		break;
	case Mix::Graphics::SHADER_MODEL_5:
		featureLevelStart = 0;
		break;
	}

	featureLevelNum = featureLevelMax - featureLevelStart;
	MIX_ASSERT( featureLevelNum > 0 );

	ret = D3D11CreateDevice(	m_pDXGIAdapter,
								D3D_DRIVER_TYPE_UNKNOWN,
								NULL,
								createFlags,
								&( featureLevelTable[featureLevelStart] ),
								featureLevelNum,
								D3D11_SDK_VERSION,
								&m_pD3DDevice,
								&m_FeatureLevel,
								&m_pD3DDeviceContext );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : D3D11CreateDevice %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//VF[_[f
	if( shaderModel == Mix::Graphics::SHADER_MODEL_4 )
	{
		MIX_ASSERT( m_FeatureLevel != D3D_FEATURE_LEVEL_11_0 );

		switch( m_FeatureLevel )
		{
		case D3D_FEATURE_LEVEL_10_0:
		case D3D_FEATURE_LEVEL_10_1:
			m_ShaderModel = Mix::Graphics::SHADER_MODEL_4;
			break;

		default:
			MessageBoxW( m_pWindow->GetHandle(), L"g̊ł́AVF[_[fS͎gpł܂", L"G[", MB_OK | MB_ICONSTOP );
			MIX_LOG_ERROR( L"%s : g̊ł́AVF[_[fS͎gpł܂", FAILED_INITIALIZE );
			return False;
		}
	}
	else if( shaderModel == Mix::Graphics::SHADER_MODEL_5 )
	{
		switch( m_FeatureLevel )
		{
		case D3D_FEATURE_LEVEL_10_0:
		case D3D_FEATURE_LEVEL_10_1:
			m_ShaderModel = Mix::Graphics::SHADER_MODEL_4;
			MIX_LOG_WARNING( L"%s : g̊ł́AVF[_[fT͎gpłȂ߁AVF[_[fSgp܂B", FAILED_INITIALIZE );
			break;

		case D3D_FEATURE_LEVEL_11_0:
			m_ShaderModel = Mix::Graphics::SHADER_MODEL_5;
			break;

		default:
			MessageBoxW( m_pWindow->GetHandle(), L"g̊ł́AVF[_[fT͎gpł܂", L"G[", MB_OK | MB_ICONSTOP );
			MIX_LOG_ERROR( L"%s : g̊ł́AVF[_[fT͎gpł܂", FAILED_INITIALIZE );
			return False;
		}
	}

	if( m_FeatureLevel == D3D_FEATURE_LEVEL_10_0 )
	{
		D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS hopt;

		m_Caps.flags =	GEOMETRY_SHADER |
						OUTPUTSTREAM |
						TEXTURE_ARRAY |
						TEXTURE_BC4_BC5 |
						ALPHA_TO_COVERAGE |
						OCCLUSIONQUERY |
						SEPARATEALPHABLEND |
						MIRRORONE |
						OVERLAP_VERTEXELEMENT |
						INDEPENDENTWRITEMASKS |
						INSTANCING;

		if( ( m_pD3DDevice->CheckFeatureSupport( D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS, &hopt, sizeof( hopt ) ) == S_OK ) &&
			( hopt.ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x == TRUE ) )
        {
			m_Caps.flags |= COMPUTE_SHADER;
			::wcscpy_s( m_Caps.shaderModel, L"4_x" );
		}
		else
		{
			::wcscpy_s( m_Caps.shaderModel, L"4_0" );
		}

		m_Caps.maxTextureSize = 8192;
		m_Caps.maxCubeTextureSize = 8192;
		m_Caps.maxVolumeTextureRange = 2048;
		m_Caps.maxTextureRepeat = 8192;
		m_Caps.maxAnisotropy = 16;
		m_Caps.maxPrimitive = ( 2 ^ 32 );
		m_Caps.maxTarget = 8;
	}
	else if( m_FeatureLevel == D3D_FEATURE_LEVEL_10_1 )
	{
		D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS hopt;

		m_Caps.flags =	GEOMETRY_SHADER |
						OUTPUTSTREAM |
						TEXTURE_ARRAY |
						CUBETEXTURE_ARRAY |
						TEXTURE_BC4_BC5 |
						ALPHA_TO_COVERAGE |
						OCCLUSIONQUERY |
						SEPARATEALPHABLEND |
						MIRRORONE |
						OVERLAP_VERTEXELEMENT |
						INDEPENDENTWRITEMASKS |
						INSTANCING;

		if( ( m_pD3DDevice->CheckFeatureSupport( D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS, &hopt, sizeof( hopt ) ) == S_OK ) &&
			( hopt.ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x == TRUE ) )
        {
			m_Caps.flags |= COMPUTE_SHADER;
			::wcscpy_s( m_Caps.shaderModel, L"4_x" );
		}
		else
		{
			::wcscpy_s( m_Caps.shaderModel, L"4_0" );
		}

		m_Caps.maxTextureSize = 8192;
		m_Caps.maxCubeTextureSize = 8192;
		m_Caps.maxVolumeTextureRange = 2048;
		m_Caps.maxTextureRepeat = 8192;
		m_Caps.maxAnisotropy = 16;
		m_Caps.maxPrimitive = 0xFFFFFFFF;
		m_Caps.maxTarget = 8;
	}
	else if( m_FeatureLevel == D3D_FEATURE_LEVEL_11_0 )
	{
		m_Caps.flags =	GEOMETRY_SHADER |
						COMPUTE_SHADER |
						HAL_DOMAIN_SHADER |
						OUTPUTSTREAM |
						TEXTURE_ARRAY |
						CUBETEXTURE_ARRAY |
						TEXTURE_BC4_BC5 |
						TEXTURE_BC6H_BC7 |
						ALPHA_TO_COVERAGE |
						EXTEND_FORMAT |
						HIGHCOLOR_FORMAT_10XR |
						OCCLUSIONQUERY |
						SEPARATEALPHABLEND |
						MIRRORONE |
						OVERLAP_VERTEXELEMENT |
						INDEPENDENTWRITEMASKS |
						INSTANCING;

		::wcscpy_s( m_Caps.shaderModel, L"5_0" );

		m_Caps.maxTextureSize = 16384;
		m_Caps.maxCubeTextureSize = 16384;
		m_Caps.maxVolumeTextureRange = 2048;
		m_Caps.maxTextureRepeat = 16384;
		m_Caps.maxAnisotropy = 16;
		m_Caps.maxPrimitive = 0xFFFFFFFF;
		m_Caps.maxTarget = 8;
	}

	//foCX̌ŗL\͂|[g
	if( pSysReport->Open() == True )
	{
		pSysReport->WriteLine( L"[foCX̌ŗL\]" );
		pSysReport->WriteLine( L"WIgVF[_[[%s]" , ( ( m_Caps.flags & GEOMETRY_SHADER ) == GEOMETRY_SHADER )? L"" : L"~" );
		pSysReport->WriteLine( L"Rs[gVF[_[[%s]" , ( ( m_Caps.flags & COMPUTE_SHADER ) == COMPUTE_SHADER )? L"" : L"~" );
		pSysReport->WriteLine( L"nAhCVF[_[[%s]" , ( ( m_Caps.flags & HAL_DOMAIN_SHADER ) == HAL_DOMAIN_SHADER )? L"" : L"~" );
		pSysReport->WriteLine( L"Xg[o[%s]" , ( ( m_Caps.flags & OUTPUTSTREAM ) == OUTPUTSTREAM )? L"" : L"~" );
		pSysReport->WriteLine( L"eNX`[z[%s]" , ( ( m_Caps.flags & TEXTURE_ARRAY ) == TEXTURE_ARRAY )? L"" : L"~" );
		pSysReport->WriteLine( L"L[ueNX`z[%s]" , ( ( m_Caps.flags & CUBETEXTURE_ARRAY ) == CUBETEXTURE_ARRAY )? L"" : L"~" );
		pSysReport->WriteLine( L"BC4/BC5k[%s]" , ( ( m_Caps.flags & TEXTURE_BC4_BC5 ) == TEXTURE_BC4_BC5 )? L"" : L"~" );
		pSysReport->WriteLine( L"BC6H/BC7k[%s]" , ( ( m_Caps.flags & TEXTURE_BC6H_BC7 ) == TEXTURE_BC6H_BC7 )? L"" : L"~" );
		pSysReport->WriteLine( L"At@gDJobW(}`TvO)[%s]" , ( ( m_Caps.flags & ALPHA_TO_COVERAGE ) == ALPHA_TO_COVERAGE )? L"" : L"~" );
		pSysReport->WriteLine( L"gtH[}bg(BGRAȂ)[%s]" , ( ( m_Caps.flags & EXTEND_FORMAT ) == EXTEND_FORMAT )? L"" : L"~" );
		pSysReport->WriteLine( L"10rbgXRnCJ[tH[}bg[%s]" , ( ( m_Caps.flags & HIGHCOLOR_FORMAT_10XR ) == HIGHCOLOR_FORMAT_10XR )? L"" : L"~" );
		pSysReport->WriteLine( L"IN[WNG[%s]" , ( ( m_Caps.flags & OCCLUSIONQUERY ) == OCCLUSIONQUERY )? L"" : L"~" );
		pSysReport->WriteLine( L"ʂ̃At@ufBO[%s]" , ( ( m_Caps.flags & SEPARATEALPHABLEND ) == SEPARATEALPHABLEND )? L"" : L"~" );
		pSysReport->WriteLine( L"~[X(eNX`AhbVO[h)[%s]" , ( ( m_Caps.flags & MIRRORONE ) == MIRRORONE )? L"" : L"~" );
		pSysReport->WriteLine( L"_vf̃I[o[bv[%s]" , ( ( m_Caps.flags & OVERLAP_VERTEXELEMENT ) == OVERLAP_VERTEXELEMENT )? L"" : L"~" );
		pSysReport->WriteLine( L"Ɨ݃}XN(_O^[Qbg)[%s]" , ( ( m_Caps.flags & INDEPENDENTWRITEMASKS ) == INDEPENDENTWRITEMASKS )? L"" : L"~" );
		pSysReport->WriteLine( L"_obt@̓eJԂ`[%s]" , ( ( m_Caps.flags & INSTANCING ) == INSTANCING )? L"" : L"~" );
		pSysReport->WriteLine( L"VF[_[f[%s]", m_Caps.shaderModel );
		pSysReport->WriteLine( L"őeNX`TCY[%d]", m_Caps.maxTextureSize );
		pSysReport->WriteLine( L"őL[ueNX`TCY[%d]", m_Caps.maxCubeTextureSize );
		pSysReport->WriteLine( L"ő{[eNX`͈[%d]", m_Caps.maxVolumeTextureRange );
		pSysReport->WriteLine( L"őٕ[%d]", m_Caps.maxAnisotropy );
		pSysReport->WriteLine( L"őv~eBu[%u]", m_Caps.maxPrimitive );
		pSysReport->WriteLine( L"_O^[Qbg[%d]", m_Caps.maxTarget );
		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	//o[ebNXCAEg̃tH[}bg|[g
	if( pSysReport->Open() == True )
	{
		const wchar_t* vlFormatNameTable[Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX] =
		{
			L"R32_FLOAT",
			L"R32G32_FLOAT",
			L"R32G32B32_FLOAT",
			L"R32G32B32A32_FLOAT",
			L"R8G8B8A8_UINT",
			L"R16G16_SINT",
			L"R16G16B16A16_SINT",
			L"R8G8B8A8_UNORM",
			L"R16G16_SNORM",
			L"R16G16B16A16_SNORM",
			L"R16G16_UNORM",
			L"R16G16B16A16_UNORM",
			L"R16G16_FLOAT",
			L"R16G16B16A16_FLOAT",
		};

		pSysReport->WriteLine( L"[o[ebNXCAEg]" );

		for( i = 0; i < Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX; i++ )
		{
			supportFlags = 0;
			m_pD3DDevice->CheckFormatSupport( Device::D3DVLFormatTable[i], &supportFlags );

			pSysReport->WriteLine( L"%s[%s]", vlFormatNameTable[i], ( ( supportFlags & D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER ) == D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER )? L"" : L"~" );
		}

		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	//CfbNX^CṽT|[gXg쐬
	for( i = 0; i < Mix::Graphics::IT_MAX; i++ )
	{
		supportFlags = 0;
		m_pD3DDevice->CheckFormatSupport( D3DIndexFormatTable[i], &supportFlags );
		m_IndexTypeSupportList[i] = ( ( supportFlags & D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER ) == D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER );
	}

	//\[X̑ΉtH[}bg
	m_ResourceFmtList[FMT_UNKNOWN].format = DXGI_FORMAT_UNKNOWN;
	m_ResourceFmtList[FMT_D16].format = DXGI_FORMAT_D16_UNORM;
	m_ResourceFmtList[FMT_D32].format = DXGI_FORMAT_D32_FLOAT;
	m_ResourceFmtList[FMT_D24S8].format = DXGI_FORMAT_D24_UNORM_S8_UINT;
	m_ResourceFmtList[FMT_R8G8B8A8].format = DXGI_FORMAT_R8G8B8A8_UNORM;
	m_ResourceFmtList[FMT_A8].format = DXGI_FORMAT_A8_UNORM;
	m_ResourceFmtList[FMT_R16F].format = DXGI_FORMAT_R16_FLOAT;
	m_ResourceFmtList[FMT_R32F].format = DXGI_FORMAT_R32_FLOAT;
	m_ResourceFmtList[FMT_R16G16F].format = DXGI_FORMAT_R16G16_FLOAT;
	m_ResourceFmtList[FMT_R32G32F].format = DXGI_FORMAT_R32G32_FLOAT;
	m_ResourceFmtList[FMT_R16G16B16A16F].format = DXGI_FORMAT_R16G16B16A16_FLOAT;
	m_ResourceFmtList[FMT_R32G32B32A32F].format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	m_ResourceFmtList[FMT_DXT1].format = DXGI_FORMAT_BC1_UNORM;
	m_ResourceFmtList[FMT_DXT2].format = DXGI_FORMAT_BC1_UNORM;
	m_ResourceFmtList[FMT_DXT3].format = DXGI_FORMAT_BC2_UNORM;
	m_ResourceFmtList[FMT_DXT4].format = DXGI_FORMAT_BC2_UNORM;
	m_ResourceFmtList[FMT_DXT5].format = DXGI_FORMAT_BC3_UNORM;

	for( i = 0; i < Mix::Graphics::FMT_MAX; i++ )
	{
		supportFlags = 0;
		m_pD3DDevice->CheckFormatSupport( m_ResourceFmtList[i].format, &supportFlags );

		m_ResourceFmtList[i].flags = 0;

		if( ( supportFlags & D3D11_FORMAT_SUPPORT_TEXTURE2D ) == D3D11_FORMAT_SUPPORT_TEXTURE2D )
		{
			m_ResourceFmtList[i].flags |= Device::RS_TEXTURE2D;
		}

		if( ( supportFlags & D3D11_FORMAT_SUPPORT_RENDER_TARGET ) == D3D11_FORMAT_SUPPORT_RENDER_TARGET )
		{
			m_ResourceFmtList[i].flags |= Device::RS_TARGET;

			if( ( supportFlags & D3D11_FORMAT_SUPPORT_TEXTURECUBE ) == D3D11_FORMAT_SUPPORT_TEXTURECUBE )
			{
				m_ResourceFmtList[i].flags |= Device::RS_CUBE;
			}
		}

		if( ( supportFlags & D3D11_FORMAT_SUPPORT_DEPTH_STENCIL ) == D3D11_FORMAT_SUPPORT_DEPTH_STENCIL )
		{
			m_ResourceFmtList[i].flags |= Device::RS_DEPTH_STENCIL;
		}
	}

	//etH[}bg|[g
	if( pSysReport->Open() == True )
	{
		Mix::Graphics::FORMAT texFormatTable[] =
		{
			Mix::Graphics::FMT_R8G8B8A8,
			Mix::Graphics::FMT_A8,
			Mix::Graphics::FMT_R16F,
			Mix::Graphics::FMT_R32F,
			Mix::Graphics::FMT_R16G16F,
			Mix::Graphics::FMT_R32G32F,
			Mix::Graphics::FMT_R16G16B16A16F,
			Mix::Graphics::FMT_R32G32B32A32F,
			Mix::Graphics::FMT_DXT1,
			Mix::Graphics::FMT_DXT2,
			Mix::Graphics::FMT_DXT3,
			Mix::Graphics::FMT_DXT4,
			Mix::Graphics::FMT_DXT5,
			Mix::Graphics::FMT_UNKNOWN,
		};

		Mix::Graphics::FORMAT targetFormatTable[] =
		{
			Mix::Graphics::FMT_R8G8B8A8,
			Mix::Graphics::FMT_R16F,
			Mix::Graphics::FMT_R32F,
			Mix::Graphics::FMT_R16G16F,
			Mix::Graphics::FMT_R32G32F,
			Mix::Graphics::FMT_R16G16B16A16F,
			Mix::Graphics::FMT_R32G32B32A32F,
			Mix::Graphics::FMT_UNKNOWN,
		};

		Mix::Graphics::FORMAT dsFormatTable[] =
		{
			Mix::Graphics::FMT_D16,
			Mix::Graphics::FMT_D32,
			Mix::Graphics::FMT_D24S8,
			Mix::Graphics::FMT_UNKNOWN,
		};

		//2DeNX`tH[}bg|[g
		pSysReport->WriteLine( L"[2DeNX`]" );
		for( i = 0; texFormatTable[i] != Mix::Graphics::FMT_UNKNOWN; i++ )
		{
			pSysReport->WriteLine( L"%s[%s]", GetFormatText( texFormatTable[i] ), ( ( m_ResourceFmtList[texFormatTable[i]].flags & Device::RS_TEXTURE2D ) == Device::RS_TEXTURE2D )? L"" : L"~" );
		}
		pSysReport->WriteLine( L"" );

		//L[ueNX`|[g
		pSysReport->WriteLine( L"[L[ueNX`]" );
		for( i = 0; targetFormatTable[i] != Mix::Graphics::FMT_UNKNOWN; i++ )
		{
			pSysReport->WriteLine( L"%s[%s]", GetFormatText( targetFormatTable[i] ), ( ( m_ResourceFmtList[targetFormatTable[i]].flags & Device::RS_CUBE ) == Device::RS_CUBE )? L"" : L"~" );
		}
		pSysReport->WriteLine( L"" );

		//2DeNX`tH[}bg|[g
		pSysReport->WriteLine( L"[_Ci~bNeNX`]" );
		for( i = 0; texFormatTable[i] != Mix::Graphics::FMT_UNKNOWN; i++ )
		{
			pSysReport->WriteLine( L"%s[%s]", GetFormatText( texFormatTable[i] ), ( ( m_ResourceFmtList[texFormatTable[i]].flags & Device::RS_TEXTURE2D ) == Device::RS_TEXTURE2D )? L"" : L"~" );
		}
		pSysReport->WriteLine( L"" );

		//^[Qbg^[Qbg|[g
		pSysReport->WriteLine( L"[^[QbgeNX`]" );
		for( i = 0; targetFormatTable[i] != Mix::Graphics::FMT_UNKNOWN; i++ )
		{
			pSysReport->WriteLine( L"%s[%s]", GetFormatText( targetFormatTable[i] ), ( ( m_ResourceFmtList[targetFormatTable[i]].flags & Device::RS_TARGET ) == Device::RS_TARGET )? L"" : L"~" );
		}
		pSysReport->WriteLine( L"" );

		//fvXeNX`|[g
		pSysReport->WriteLine( L"[fvXeNX`]" );
		for( i = 0; dsFormatTable[i] != Mix::Graphics::FMT_UNKNOWN; i++ )
		{
			pSysReport->WriteLine( L"%s[%s]", GetFormatText( dsFormatTable[i] ), ( ( m_ResourceFmtList[dsFormatTable[i]].flags & Device::RS_DEPTH_STENCIL ) == Device::RS_DEPTH_STENCIL )? L"" : L"~" );
		}
		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	//fBXvC[h
	ret = m_pDXGIAdapter->EnumOutputs( 0, &m_pDXGIOutput );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIAdapter::EnumOutputs %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}
	ret = m_pDXGIOutput->GetDisplayModeList( DXGI_FORMAT_R8G8B8A8_UNORM, 0, &numMode, NULL );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIOutput::GetDisplayModeList %s(1) : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}
	m_DisplayModeList.resize( numMode );
	ret = m_pDXGIOutput->GetDisplayModeList( DXGI_FORMAT_R8G8B8A8_UNORM, 0, &numMode, &( m_DisplayModeList[0] ) );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIOutput::GetDisplayModeList %s(2) : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//fBXvC[h
	Mix::Memory::Zero( &displayMode, sizeof( displayMode ) );
	Mix::Memory::Zero( &bestDisplayMode, sizeof( bestDisplayMode ) );
	displayMode.Width = backBuffSize.x;
	displayMode.Height = backBuffSize.y;
	displayMode.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	ret = m_pDXGIOutput->FindClosestMatchingMode( &displayMode, &bestDisplayMode, m_pD3DDevice );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIOutput::FindClosestMatchingMode %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//Xbv`F[̍쐬
	m_SwapChainDesc.BufferDesc.Width			= bestDisplayMode.Width;
	m_SwapChainDesc.BufferDesc.Height			= bestDisplayMode.Height;
	m_SwapChainDesc.BufferDesc.Format			= bestDisplayMode.Format;
	m_SwapChainDesc.BufferDesc.RefreshRate		= bestDisplayMode.RefreshRate;
	m_SwapChainDesc.BufferDesc.Scaling			= bestDisplayMode.Scaling;
	m_SwapChainDesc.BufferDesc.ScanlineOrdering	= bestDisplayMode.ScanlineOrdering;
	m_SwapChainDesc.SampleDesc.Count			= 1;
	m_SwapChainDesc.SampleDesc.Quality			= 0;
	m_SwapChainDesc.BufferUsage					= DXGI_USAGE_RENDER_TARGET_OUTPUT;
	m_SwapChainDesc.BufferCount					= 1;
	m_SwapChainDesc.OutputWindow				= m_pWindow->GetHandle();
	m_SwapChainDesc.Windowed					= TRUE;
	m_SwapChainDesc.SwapEffect					= DXGI_SWAP_EFFECT_DISCARD;
	m_SwapChainDesc.Flags						= DXGI_SWAP_CHAIN_FLAG_ALLOW_MODE_SWITCH;

	//Xbv`F[̍쐬
	ret = m_pDXGIFactory->CreateSwapChain( m_pD3DDevice, &m_SwapChainDesc, &m_pDXGISwapChain );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIFactory::CreateSwapChain %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//obNobt@쐬
	ret = CreateBackBuffer( FAILED_INITIALIZE );
	if( ret != S_OK )
	{
		return False;
	}

	//ALT+ENTER ɂ郂[h̐؂ւ֎~
	ret = m_pDXGIFactory->MakeWindowAssociation( m_pWindow->GetHandle(), DXGI_MWA_NO_WINDOW_CHANGES | DXGI_MWA_NO_ALT_ENTER );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGIFactory::MakeWindowAssociation %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//XN[`
	rect.x = 0;
	rect.y = 0;
	rect.width = m_SwapChainDesc.BufferDesc.Width;
	rect.height = m_SwapChainDesc.BufferDesc.Height;

	//^[QbgTCYݒ
	m_TargetState.rect = rect;

	//r[|[gݒ
	SetViewport( rect );

	//VU[ݒ
	SetScissor( rect );

	//X^CUXe[g쐬
	for( i = 0; i < Mix::Graphics::FILL_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::CULL_MAX; j++ )
		{
			for( k = 0; k < 2; k++ )
			{
				D3D11_RASTERIZER_DESC desc;

				desc.FillMode = fillTable[i];
				desc.CullMode = cullTable[j];
				desc.FrontCounterClockwise = FALSE;
				desc.DepthBias = 0;
				desc.SlopeScaledDepthBias = 0.0f;
				desc.DepthBiasClamp = 0.0f;
				desc.DepthClipEnable = TRUE;
				desc.ScissorEnable = ( k == 1 );
				desc.MultisampleEnable = FALSE;
				desc.AntialiasedLineEnable = FALSE;

				m_pD3DDevice->CreateRasterizerState( &desc, &m_pRasterizerStateArray[i][j][k] );
			}
		}
	}

	//fvXXe[g쐬
	for( i = 0; i < 2; i++ )
	{
		for( j = 0; j < 2; j++ )
		{
			for( k = 0; k < Mix::Graphics::ZFUNC_MAX; k++ )
			{
				D3D11_DEPTH_STENCIL_DESC desc;

				Mix::Memory::Zero( &desc, sizeof( desc ) );

				desc.DepthEnable = ( i == 1 );
				desc.DepthWriteMask = ( j == 0 )? D3D11_DEPTH_WRITE_MASK_ZERO : D3D11_DEPTH_WRITE_MASK_ALL;
				desc.DepthFunc = zFuncTable[k];

				m_pD3DDevice->CreateDepthStencilState( &desc, &m_pDepthStateArray[i][j][k] );
			}
		}
	}

	//uhXe[g쐬
	for( i = 0; i < Mix::Graphics::BLEND_MAX; i++ )
	{
		Boolean bBlendEnabled = ( i != Mix::Graphics::BLEND_COPY );

		D3D11_BLEND srcBlend;
		D3D11_BLEND destBlend;
		D3D11_BLEND_OP blendOp;
		D3D11_BLEND srcBlendAlpha;
		D3D11_BLEND destBlendAlpha;
		D3D11_BLEND_OP blendOpAlpha;

		switch( i )
		{
		case Mix::Graphics::BLEND_COPY:
			srcBlend		= D3D11_BLEND_ONE;
			destBlend		= D3D11_BLEND_ZERO;
			blendOp			= D3D11_BLEND_OP_ADD;
			srcBlendAlpha	= D3D11_BLEND_ONE;
			destBlendAlpha	= D3D11_BLEND_ZERO;
			blendOpAlpha	= D3D11_BLEND_OP_ADD;
			break;

		case Mix::Graphics::BLEND_NORMAL:
			srcBlend		= D3D11_BLEND_SRC_ALPHA;
			destBlend		= D3D11_BLEND_INV_SRC_ALPHA;
			blendOp			= D3D11_BLEND_OP_ADD;
			srcBlendAlpha	= D3D11_BLEND_SRC_ALPHA;
			destBlendAlpha	= D3D11_BLEND_INV_SRC_ALPHA;
			blendOpAlpha	= D3D11_BLEND_OP_ADD;
			break;

		case Mix::Graphics::BLEND_ADD:
			srcBlend		= D3D11_BLEND_SRC_ALPHA;
			destBlend		= D3D11_BLEND_ONE;
			blendOp			= D3D11_BLEND_OP_ADD;
			srcBlendAlpha	= D3D11_BLEND_SRC_ALPHA;
			destBlendAlpha	= D3D11_BLEND_ONE;
//			srcBlendAlpha	= D3D11_BLEND_ONE;
//			destBlendAlpha	= D3D11_BLEND_ZERO;
			blendOpAlpha	= D3D11_BLEND_OP_ADD;
			break;

		case Mix::Graphics::BLEND_SUB:
			srcBlend		= D3D11_BLEND_SRC_ALPHA;
			destBlend		= D3D11_BLEND_ONE;
			blendOp			= D3D11_BLEND_OP_REV_SUBTRACT;
			srcBlendAlpha	= D3D11_BLEND_SRC_ALPHA;
			destBlendAlpha	= D3D11_BLEND_ONE;
			blendOpAlpha	= D3D11_BLEND_OP_REV_SUBTRACT;
			break;

		case Mix::Graphics::BLEND_MUL:
			srcBlend		= D3D11_BLEND_ZERO;
			destBlend		= D3D11_BLEND_SRC_COLOR;
			blendOp			= D3D11_BLEND_OP_ADD;
			srcBlendAlpha	= D3D11_BLEND_ZERO;
			destBlendAlpha	= D3D11_BLEND_SRC_ALPHA;
			blendOpAlpha	= D3D11_BLEND_OP_ADD;
			break;

		case Mix::Graphics::BLEND_SCREEN:
			srcBlend		= D3D11_BLEND_INV_DEST_COLOR;
			destBlend		= D3D11_BLEND_ONE;
			blendOp			= D3D11_BLEND_OP_ADD;
			srcBlendAlpha	= D3D11_BLEND_INV_DEST_ALPHA;
			destBlendAlpha	= D3D11_BLEND_ONE;
			blendOpAlpha	= D3D11_BLEND_OP_ADD;
			break;
		}

		for( j = 0; j < Mix::Graphics::COLOR_WRITE_MASK_MAX; j++ )
		{
			UInt8 colorWriteMask = colorWriteMaskTable[j];

			D3D11_BLEND_DESC desc;

			desc.AlphaToCoverageEnable = FALSE;
			desc.IndependentBlendEnable = FALSE;

			for( k = 0; k < 8; k++ )
			{
				desc.RenderTarget[k].BlendEnable			= bBlendEnabled;
				desc.RenderTarget[k].RenderTargetWriteMask	= colorWriteMask;
				desc.RenderTarget[k].SrcBlend				= srcBlend;
				desc.RenderTarget[k].DestBlend				= destBlend;
				desc.RenderTarget[k].BlendOp				= blendOp;
				desc.RenderTarget[k].SrcBlendAlpha			= srcBlendAlpha;
				desc.RenderTarget[k].DestBlendAlpha			= destBlendAlpha;
				desc.RenderTarget[k].BlendOpAlpha			= blendOpAlpha;

//				desc.RenderTarget[k].SrcBlendAlpha  = D3D11_BLEND_ONE;
//				desc.RenderTarget[k].DestBlendAlpha = D3D11_BLEND_ONE;
//				desc.RenderTarget[k].BlendOpAlpha   = D3D11_BLEND_OP_MAX;

//				desc.RenderTarget[k].SrcBlendAlpha  = D3D11_BLEND_ONE;
//				desc.RenderTarget[k].DestBlendAlpha = D3D11_BLEND_ZERO;
//				desc.RenderTarget[k].BlendOpAlpha   = D3D11_BLEND_OP_ADD;
			}

			m_pD3DDevice->CreateBlendState( &desc, &m_pBlendStateArray[i][j] );
		}
	}

	//Tv[Xe[g쐬
	for( i = 0; i < Mix::Graphics::TEXTUREFILTER_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::TEXTUREADDRESS_MAX; j++ )
		{
			D3D11_SAMPLER_DESC desc;

			desc.Filter = texFilterTable[i];
			desc.AddressU = texAddressTable[j];
			desc.AddressV = texAddressTable[j];
			desc.AddressW = D3D11_TEXTURE_ADDRESS_CLAMP;
			desc.MipLODBias = 0.0f;
			desc.MaxAnisotropy = texAnisotropyTable[i];
			desc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
			desc.BorderColor[0] = 0.0f;
			desc.BorderColor[1] = 0.0f;
			desc.BorderColor[2] = 0.0f;
			desc.BorderColor[3] = 0.0f;
			desc.MinLOD = 0;
			desc.MaxLOD = D3D11_FLOAT32_MAX;

			m_pD3DDevice->CreateSamplerState( &desc, &( m_pSamplerArray[i][j] ) );
		}
	}

	//TvXe[g|[g
	if( pSysReport->Open() == True )
	{
		const wchar_t* texFilterNameTable[Mix::Graphics::TEXTUREFILTER_MAX] =
		{
			L"POINT",
			L"LINEAR",
			L"ANISOTROPIC",
		};

		const wchar_t* texAddressNameTable[Mix::Graphics::TEXTUREADDRESS_MAX] =
		{
			L"WRAP",
			L"CLAMP",
		};

		pSysReport->WriteLine( L"[Tv[Xe[g]" );

		for( i = 0; i < Mix::Graphics::TEXTUREFILTER_MAX; i++ )
		{
			for( j = 0; j < Mix::Graphics::TEXTUREADDRESS_MAX; j++ )
			{
				pSysReport->WriteLine( L"%s %s [%s]",
					texFilterNameTable[i],
					texAddressNameTable[j],
					( m_pSamplerArray[i][j] != NULL )? L"" : L"~" );
			}
		}

		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	if( bFullscreen == True )
	{
		//tXN[[hɐ؂ւ
		ChangeWindowMode( False );
	}

	MIX_LOG_INFO( L"OtBbNXfoCX( DirectX11 )" );

	return True;
}

HRESULT Device::CreateBuffer( D3D11_BIND_FLAG bindFlags, UInt32 size, Boolean bDynamic, const void* pInitialData, ID3D11Buffer** ppBuffer )
{
	HRESULT ret;
	D3D11_BUFFER_DESC desc;
	::ID3D11Buffer* pD3DBuffer;

	desc.ByteWidth = size;
	desc.Usage = ( bDynamic == True )? D3D11_USAGE_DYNAMIC : D3D11_USAGE_DEFAULT;
	desc.BindFlags = bindFlags;
	desc.CPUAccessFlags = ( bDynamic == True )? D3D11_CPU_ACCESS_WRITE : 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;

	if( pInitialData != NULL )
	{
		D3D11_SUBRESOURCE_DATA data;

		data.pSysMem = pInitialData;
		data.SysMemPitch = 0;
		data.SysMemSlicePitch = 0;

		ret = m_pD3DDevice->CreateBuffer( &desc, &data, &pD3DBuffer );
	}
	else
	{
		ret = m_pD3DDevice->CreateBuffer( &desc, NULL, &pD3DBuffer );
	}

	if( ret == S_OK )
	{
		( *ppBuffer ) = pD3DBuffer;
	}

	return ret;
}

HRESULT Device::CreateVertexBuffer( UInt32 count, UInt32 stride, Boolean bDynamic, const void* pInitialData, ID3D11Buffer** ppBuffer )
{
	HRESULT ret;
	D3D11_BUFFER_DESC desc;
	::ID3D11Buffer* pD3DBuffer;

	desc.ByteWidth = ( stride * count );
	desc.Usage = ( bDynamic == True )? D3D11_USAGE_DYNAMIC : D3D11_USAGE_DEFAULT;
	desc.BindFlags = D3D11_BIND_VERTEX_BUFFER;
	desc.CPUAccessFlags = ( bDynamic == True )? D3D11_CPU_ACCESS_WRITE : 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;

	if( pInitialData != NULL )
	{
		D3D11_SUBRESOURCE_DATA data;

		data.pSysMem = pInitialData;
		data.SysMemPitch = 0;
		data.SysMemSlicePitch = 0;

		ret = m_pD3DDevice->CreateBuffer( &desc, &data, &pD3DBuffer );
	}
	else
	{
		ret = m_pD3DDevice->CreateBuffer( &desc, NULL, &pD3DBuffer );
	}

	if( ret == S_OK )
	{
		( *ppBuffer ) = pD3DBuffer;
	}

	return ret;
}

HRESULT Device::CreateIndexBuffer( Mix::Graphics::INDEX_TYPE type, UInt32 count, Boolean bDynamic, const void* pInitialData, ID3D11Buffer** ppBuffer )
{
	HRESULT ret;
	D3D11_BUFFER_DESC desc;
	::ID3D11Buffer* pD3DBuffer;

	desc.ByteWidth = ( Device::D3DIndexStrideTable[type] * count );
	desc.Usage = ( bDynamic == True )? D3D11_USAGE_DYNAMIC : D3D11_USAGE_DEFAULT;
	desc.BindFlags = D3D11_BIND_INDEX_BUFFER;
	desc.CPUAccessFlags = ( bDynamic == True )? D3D11_CPU_ACCESS_WRITE : 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;

	if( pInitialData != NULL )
	{
		D3D11_SUBRESOURCE_DATA data;

		data.pSysMem = pInitialData;
		data.SysMemPitch = 0;
		data.SysMemSlicePitch = 0;

		ret = m_pD3DDevice->CreateBuffer( &desc, &data, &pD3DBuffer );
	}
	else
	{
		ret = m_pD3DDevice->CreateBuffer( &desc, NULL, &pD3DBuffer );
	}

	if( ret == S_OK )
	{
		( *ppBuffer ) = pD3DBuffer;
	}

	return ret;
}

HRESULT Device::Map( ID3D11Resource* pResource, Boolean bDynamic, D3D11_MAPPED_SUBRESOURCE& mapped )
{
	return m_pD3DDeviceContext->Map( pResource, 0, ( bDynamic == True )? D3D11_MAP_WRITE_DISCARD : D3D11_MAP_WRITE, 0, &mapped );
}

void Device::Unmap( ID3D11Resource* pResource )
{
	m_pD3DDeviceContext->Unmap( pResource, 0 );
}

void Device::BeginQuery( ID3D11Query* pQuery )
{
	m_pD3DDeviceContext->Begin( pQuery );
}

void Device::EndQuery( ID3D11Query* pQuery )
{
	m_pD3DDeviceContext->End( pQuery );
}

HRESULT Device::GetQueryData( ID3D11Query* pQuery, Boolean bFlush, UInt32& data )
{
	return m_pD3DDeviceContext->GetData( pQuery, &data, sizeof( UInt32 ), ( bFlush == True )? 0 : D3D11_ASYNC_GETDATA_DONOTFLUSH );
}

Mix::Graphics::FORMAT Device::ConvertTextureFormat( DXGI_FORMAT d3dFormat )
{
	switch( d3dFormat )
	{
	case DXGI_FORMAT_D16_UNORM:
		return Mix::Graphics::FMT_D16;
	case DXGI_FORMAT_D32_FLOAT:
		return Mix::Graphics::FMT_D32;
	case DXGI_FORMAT_D24_UNORM_S8_UINT:
		return Mix::Graphics::FMT_D24S8;

	case DXGI_FORMAT_R8G8B8A8_UNORM:
		return Mix::Graphics::FMT_R8G8B8A8;
	case DXGI_FORMAT_A8_UNORM:
		return Mix::Graphics::FMT_A8;
	case DXGI_FORMAT_R16_FLOAT:
		return Mix::Graphics::FMT_R16F;
	case DXGI_FORMAT_R32_FLOAT:
		return Mix::Graphics::FMT_R32F;
	case DXGI_FORMAT_R16G16_FLOAT:
		return Mix::Graphics::FMT_R16G16F;
	case DXGI_FORMAT_R32G32_FLOAT:
		return Mix::Graphics::FMT_R32G32F;
	case DXGI_FORMAT_R16G16B16A16_FLOAT:
		return Mix::Graphics::FMT_R16G16B16A16F;
	case DXGI_FORMAT_R32G32B32A32_FLOAT:
		return Mix::Graphics::FMT_R32G32B32A32F;

	case DXGI_FORMAT_BC1_UNORM:
		return Mix::Graphics::FMT_DXT1;
	case DXGI_FORMAT_BC2_UNORM:
		return Mix::Graphics::FMT_DXT3;
	case DXGI_FORMAT_BC3_UNORM:
		return Mix::Graphics::FMT_DXT5;
	}

	return Mix::Graphics::FMT_UNKNOWN;
}

const wchar_t* Device::GetD3DResultText( HRESULT ret )
{
	switch( ret )
	{
	case D3D11_ERROR_FILE_NOT_FOUND:
		return D3DResultTextArray[0];
	case D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS:
		return D3DResultTextArray[1];
	case D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS:
		return D3DResultTextArray[2];
	case D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD:
		return D3DResultTextArray[3];
	case D3DERR_INVALIDCALL:
		return D3DResultTextArray[4];
	case D3DERR_WASSTILLDRAWING:
		return D3DResultTextArray[5];
	case E_FAIL:
		return D3DResultTextArray[6];
	case E_INVALIDARG:
		return D3DResultTextArray[7];
	case E_OUTOFMEMORY:
		return D3DResultTextArray[8];
	case S_FALSE:
		return D3DResultTextArray[9];
	case S_OK:
		return D3DResultTextArray[10];
	}

	return D3DResultTextArray[11];
}

Boolean Device::MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
	case WM_SYSKEYDOWN:
		if( wParam == VK_RETURN )
		{
			if( m_pDXGISwapChain->SetFullscreenState( m_bWindowed, NULL ) == S_OK )
			{
				ResizeBackBuffer();
				m_bWindowed = ( m_bWindowed == True )? False : True;
			}
		}
		break;

	case WM_ACTIVATEAPP:
		if( LOWORD( wParam ) == WA_INACTIVE )
		{
			if( m_bWindowed == False )
			{
				m_bWindowed = True;
			}
		}
		break;

	case WM_SIZE:
		ResizeBackBuffer();
		break;
	}

	return True;
}

Boolean Device::CompileShader(	const void* pSrc, UInt32 srcSize,
								Mix::Graphics::SHADER_MACRO* pMacros,
								const char* pFuncName,
								Mix::Graphics::SHADER_TARGET target,
								Mix::Memory::IBuffer** ppBuffer )
{
	D3DX11CompileFromMemoryFunc D3DX11CompileFromMemory = static_cast<D3DX11CompileFromMemoryFunc>( m_D3DX11Module.GetFunction( L"D3DX11CompileFromMemory" ) );
	UInt32 compileFlags = D3D10_SHADER_OPTIMIZATION_LEVEL3 | D3D10_SHADER_PACK_MATRIX_COLUMN_MAJOR | D3D10_SHADER_ENABLE_STRICTNESS;

	std::vector<D3D10_SHADER_MACRO> d3dMacros;

	HRESULT ret;
	ID3D10Blob* pShaderBuffer = NULL;
	ID3D10Blob* pShaderError = NULL;

	Mix::Memory::IBuffer* pDst = NULL;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// }NXg̍쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( pMacros != NULL )
	{
		D3D10_SHADER_MACRO temp;

		for( UInt32 i = 0; ( ( pMacros[i].pNameA != NULL ) && ( pMacros[i].pDefA != NULL ) ); i++ )
		{
			temp.Name = pMacros[i].pNameA;
			temp.Definition = pMacros[i].pDefA;
			d3dMacros.push_back( temp );
		}

		temp.Name = NULL;
		temp.Definition = NULL;
		d3dMacros.push_back( temp );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// RpC
	////////////////////////////////////////////////////////////////////////////////////////////////////

	ret = D3DX11CompileFromMemory( reinterpret_cast<LPCSTR>( pSrc ),
		srcSize,
		NULL,
		( d3dMacros.size() > 0 )? &( d3dMacros[0] ) : NULL,
		NULL,
		pFuncName,
		Mix::Graphics::SHADER_TARGET_TABLE[target],
		compileFlags,
		0,
		NULL,
		&pShaderBuffer,
		&pShaderError,
		NULL );

	if( ret != S_OK )
	{
		Mix::StringW errMsg = ( pShaderError != NULL )? static_cast<char*>( pShaderError->GetBufferPointer() ) : "???";

		MIX_LOG_ERROR( L"D3DX11CompileFromMemory %s : %s", Mix::STR_RETERROR, errMsg.GetConstPtr() );

		MIX_RELEASE( pShaderBuffer );
		MIX_RELEASE( pShaderError );

		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// obt@쐬ăRs[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( Mix::Memory::CreateBuffer( pShaderBuffer->GetBufferSize(), pShaderBuffer->GetBufferPointer(), &pDst ) == False )
	{
		MIX_LOG_ERROR( L"%s : Size[%dByte]", Mix::STR_OUTOFMEMORY, pShaderBuffer->GetBufferSize() );

		MIX_RELEASE( pShaderBuffer );
		MIX_RELEASE( pShaderError );

		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ㏈
	////////////////////////////////////////////////////////////////////////////////////////////////////

	MIX_RELEASE( pShaderBuffer );
	MIX_RELEASE( pShaderError );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// n
	////////////////////////////////////////////////////////////////////////////////////////////////////

	( *ppBuffer ) = pDst;

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return True;
}

void Device::OnDispose( void )
{
	BOOL bFullscreen;
	UInt32 i;
	UInt32 j;
	UInt32 k;

	if( ( m_pDXGISwapChain != NULL ) &&
		( m_pDXGISwapChain->GetFullscreenState( &bFullscreen, NULL ) == S_OK ) &&
		( bFullscreen == TRUE ) )
	{
		m_pDXGISwapChain->SetFullscreenState( FALSE, NULL );
	}

	for( i = 0; i < Mix::Graphics::TEXTUREFILTER_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::TEXTUREADDRESS_MAX; j++ )
		{
			MIX_RELEASE( m_pSamplerArray[i][j] );
		}
	}

	for( i = 0; i < Mix::Graphics::BLEND_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::COLOR_WRITE_MASK_MAX; j++ )
		{
			MIX_RELEASE( m_pBlendStateArray[i][j] );
		}
	}

	for( i = 0; i < 2; i++ )
	{
		for( j = 0; j < 2; j++ )
		{
			for( k = 0; k < Mix::Graphics::ZFUNC_MAX; k++ )
			{
				MIX_RELEASE( m_pDepthStateArray[i][j][k] );
			}
		}
	}

	for( i = 0; i < Mix::Graphics::FILL_MAX; i++ )
	{
		for( j = 0; j < Mix::Graphics::CULL_MAX; j++ )
		{
			for( k = 0; k < 2; k++ )
			{
				MIX_RELEASE( m_pRasterizerStateArray[i][j][k] );
			}
		}
	}

	ResetTargetState();
	ResetDrawState();

	MIX_RELEASE( m_pBackBufferView );
	MIX_RELEASE( m_pBackBuffer );
	MIX_RELEASE( m_pD3DDeviceContext );
	MIX_RELEASE( m_pD3DDevice );

	MIX_RELEASE( m_pDXGISwapChain );
	MIX_RELEASE( m_pDXGIOutput );
	MIX_RELEASE( m_pDXGIAdapter );
	MIX_RELEASE( m_pDXGIFactory );
}

Boolean Device::CreateVertexLayout( const Mix::Graphics::VERTEX_ELEMENT* pElements, UInt32 elementCount, const Mix::Graphics::IVertexShader* pVertexShader, Mix::Graphics::IVertexLayout** ppVertexLayout, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( pElements == NULL ) ||
		( elementCount == 0 ) ||
		( pVertexShader == NULL ) ||
		( ppVertexLayout == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pElements[%s] elementCount[%d] pVertexShader[%s] ppVertexLayout[%s]",
			FAILED_CREATEVERTEXLAYOUT,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pElements != NULL )? L"" : L"~",
			elementCount,
			( pVertexShader != NULL )? L"" : L"~",
			( ppVertexLayout != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	UInt32 i;
	UInt32 stride;
	D3D11_INPUT_ELEMENT_DESC* pD3DElements;
	ID3D11InputLayout* pD3DVertexLayout;
	const Mix::Graphics::DX11::VertexShader* pCompVS;
	Mix::Graphics::DX11::VertexLayout* pVertexLayout;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// o[ebNXCAEg쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	stride = 0;

	pD3DElements = static_cast<D3D11_INPUT_ELEMENT_DESC*>( Mix::Memory::Allocate( sizeof( D3D11_INPUT_ELEMENT_DESC ) * elementCount ) );
	if( pD3DElements == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEVERTEXLAYOUT, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	for( i = 0; i < elementCount; i++ )
	{
		UInt32 format = pElements[i].format;

		pD3DElements[i].SemanticName = D3DVLSemanticTable[pElements[i].semanticType];
		pD3DElements[i].SemanticIndex = pElements[i].semanticIndex;
		pD3DElements[i].Format = Device::D3DVLFormatTable[format];
		pD3DElements[i].InputSlot = 0;
		pD3DElements[i].AlignedByteOffset = pElements[i].offset;
		pD3DElements[i].InputSlotClass = D3D11_INPUT_PER_VERTEX_DATA;
		pD3DElements[i].InstanceDataStepRate = 0;

		stride += Device::VERTEX_ELEMENT_SIZE_TABLE[format];
	}

	pCompVS = dynamic_cast<const Mix::Graphics::DX11::VertexShader*>( pVertexShader );

	ret = m_pD3DDevice->CreateInputLayout( pD3DElements, elementCount, pCompVS->GetInputSignature(), pCompVS->GetInputSignatureSize(), &pD3DVertexLayout );
	if( ret != S_OK )
	{
		Mix::Memory::Free( pD3DElements );
		MIX_LOG_ERROR( L"%s : CreateInputLayout %s : Name[%s] Result[%s]", FAILED_CREATEVERTEXLAYOUT, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	Mix::Memory::Free( pD3DElements );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// C^[tF[X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	pVertexLayout = Mix::Graphics::DX11::VertexLayout::CreateInstance(	this,
																		pD3DVertexLayout,
																		pElements,
																		elementCount,
																		stride,
																		name.GetConstPtr() );
	if( pVertexLayout != NULL )
	{
		( *ppVertexLayout ) = pVertexLayout;
	}
	else
	{
		MIX_RELEASE( pD3DVertexLayout );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEVERTEXLAYOUT, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// O
	////////////////////////////////////////////////////////////////////////////////////////////////////

	MIX_LOG_INFO( L"o[ebNXCAEg쐬 : Name[%s] Stride[%d]", name.GetConstPtr(), stride );

	return True;
}

Boolean Device::CreateHullShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IHullShader** ppHullShader )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"%s : VF[_[fT̂ݎgpł܂ : File[%s]", FAILED_CREATEHULLSHADER, pFileName );
		return False;
	}

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppHullShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppHullShader[%s]",
			FAILED_CREATEHULLSHADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppHullShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::IBuffer* pBuffer;
	ID3D11HullShader* pD3DHullShader;
	Mix::Graphics::DX11::HullShader* pHullShader;

	if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_CREATEHULLSHADER, pFileName );
		return False;
	}

	ret = m_pD3DDevice->CreateHullShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DHullShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreateHullShader %s : File[%s] Result[%s]", FAILED_CREATEHULLSHADER, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	pHullShader = Mix::Graphics::DX11::HullShader::CreateInstance( this, pD3DHullShader, pFileName );
	if( pHullShader != NULL )
	{
		( *ppHullShader ) = pHullShader;
	}
	else
	{
		MIX_RELEASE( pD3DHullShader );
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEHULLSHADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"nVF[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Device::CreateHullShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IHullShader** ppHullShader, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"%s : VF[_[fT̂ݎgpł܂ : File[%s]", FAILED_CREATEHULLSHADER, name.GetConstPtr() );
		return False;
	}

	if( ( pSrc == NULL ) ||
		( srcSize == 0 ) ||
		( ppHullShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pSrc[%s] srcSize[%d] ppHullShader[%s]",
			FAILED_CREATEHULLSHADER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pSrc != NULL )? L"" : L"~",
			srcSize,
			( ppHullShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	ID3D11HullShader* pD3DHullShader;
	Mix::Graphics::DX11::HullShader* pHullShader;

	ret = m_pD3DDevice->CreateHullShader( pSrc, srcSize, NULL, &pD3DHullShader );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateHullShader %s : Name[%s] Result[%s]", FAILED_CREATEHULLSHADER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pHullShader = Mix::Graphics::DX11::HullShader::CreateInstance( this, pD3DHullShader, name.GetConstPtr() );
	if( pHullShader != NULL )
	{
		( *ppHullShader ) = pHullShader;
	}
	else
	{
		MIX_RELEASE( pD3DHullShader );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEHULLSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"nVF[_[쐬 : Name[%s]", name.GetConstPtr() );

	return True;
}

Boolean Device::CreateDomainShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IDomainShader** ppDomainShader )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"%s : VF[_[fT̂ݎgpł܂ : File[%s]", FAILED_CREATEDOMAINSHADER, pFileName );
		return False;
	}

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppDomainShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppDomainShader[%s]",
			FAILED_CREATEDOMAINSHADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppDomainShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::IBuffer* pBuffer;
	ID3D11DomainShader* pD3DDomainShader;
	Mix::Graphics::DX11::DomainShader* pDomainShader;

	if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_CREATEDOMAINSHADER, pFileName );
		return False;
	}

	ret = m_pD3DDevice->CreateDomainShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DDomainShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreateDomainShader %s : File[%s] Result[%s]", FAILED_CREATEDOMAINSHADER, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	pDomainShader = Mix::Graphics::DX11::DomainShader::CreateInstance( this, pD3DDomainShader, pFileName );
	if( pDomainShader != NULL )
	{
		( *ppDomainShader ) = pDomainShader;
	}
	else
	{
		MIX_RELEASE( pD3DDomainShader );
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEDOMAINSHADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"hCVF[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Device::CreateDomainShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IDomainShader** ppDomainShader, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"%s : VF[_[fT̂ݎgpł܂ : File[%s]", FAILED_CREATEDOMAINSHADER, name.GetConstPtr() );
		return False;
	}

	if( ( pSrc == NULL ) ||
		( srcSize == 0 ) ||
		( ppDomainShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pSrc[%s] srcSize[%d] ppDomainShader[%s]",
			FAILED_CREATEDOMAINSHADER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pSrc != NULL )? L"" : L"~",
			srcSize,
			( ppDomainShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	ID3D11DomainShader* pD3DDomainShader;
	Mix::Graphics::DX11::DomainShader* pDomainShader;

	ret = m_pD3DDevice->CreateDomainShader( pSrc, srcSize, NULL, &pD3DDomainShader );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateDomainShader %s : Name[%s] Result[%s]", FAILED_CREATEDOMAINSHADER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pDomainShader = Mix::Graphics::DX11::DomainShader::CreateInstance( this, pD3DDomainShader, name.GetConstPtr() );
	if( pDomainShader != NULL )
	{
		( *ppDomainShader ) = pDomainShader;
	}
	else
	{
		MIX_RELEASE( pD3DDomainShader );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEDOMAINSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"hCVF[_[쐬 : Name[%s]", name.GetConstPtr() );

	return True;
}

Boolean Device::CreateGeometryShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IGeometryShader** ppGeometryShader )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppGeometryShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppGeometryShader[%s]",
			FAILED_CREATEGEOMETRYSHADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppGeometryShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::IBuffer* pBuffer;
	ID3D11GeometryShader* pD3DGeometryShader;
	Mix::Graphics::DX11::GeometryShader* pGeometryShader;

	if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_CREATEGEOMETRYSHADER, pFileName );
		return False;
	}

	ret = m_pD3DDevice->CreateGeometryShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DGeometryShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreateGeometryShader %s : File[%s] Result[%s]", FAILED_CREATEGEOMETRYSHADER, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	pGeometryShader = Mix::Graphics::DX11::GeometryShader::CreateInstance( this, pD3DGeometryShader, pFileName );
	if( pGeometryShader != NULL )
	{
		( *ppGeometryShader ) = pGeometryShader;
	}
	else
	{
		MIX_RELEASE( pD3DGeometryShader );
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEGEOMETRYSHADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"WIgVF[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Device::CreateGeometryShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IGeometryShader** ppGeometryShader, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( pSrc == NULL ) ||
		( srcSize == 0 ) ||
		( ppGeometryShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pSrc[%s] srcSize[%d] ppGeometryShader[%s]",
			FAILED_CREATEGEOMETRYSHADER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pSrc != NULL )? L"" : L"~",
			srcSize,
			( ppGeometryShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	ID3D11GeometryShader* pD3DGeometryShader;
	Mix::Graphics::DX11::GeometryShader* pGeometryShader;

	ret = m_pD3DDevice->CreateGeometryShader( pSrc, srcSize, NULL, &pD3DGeometryShader );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateGeometryShader %s : Name[%s] Result[%s]", FAILED_CREATEGEOMETRYSHADER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pGeometryShader = Mix::Graphics::DX11::GeometryShader::CreateInstance( this, pD3DGeometryShader, name.GetConstPtr() );
	if( pGeometryShader != NULL )
	{
		( *ppGeometryShader ) = pGeometryShader;
	}
	else
	{
		MIX_RELEASE( pD3DGeometryShader );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEGEOMETRYSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"WIgVF[_[쐬 : Name[%s]", name.GetConstPtr() );

	return True;
}

Boolean Device::CreateVertexShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IVertexShader** ppVertexShader )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppVertexShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppVertexShader[%s]",
			FAILED_CREATEVERTEXSHADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppVertexShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::IBuffer* pBuffer;
	Mix::Graphics::DX11::VertexShader* pVertexShader;
	ID3D11VertexShader* pD3DVertexShader;

	if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_CREATEVERTEXSHADER, pFileName );
		return False;
	}

	ret = m_pD3DDevice->CreateVertexShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DVertexShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreateVertexShader %s : File[%s] Result[%s]", FAILED_CREATEVERTEXSHADER, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	pVertexShader = Mix::Graphics::DX11::VertexShader::CreateInstance( this, pD3DVertexShader, pBuffer, pFileName );
	if( pVertexShader != NULL )
	{
		( *ppVertexShader ) = pVertexShader;
	}
	else
	{
		MIX_RELEASE( pD3DVertexShader );
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEVERTEXSHADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"o[ebNXVF[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Device::CreateVertexShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IVertexShader** ppVertexShader, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( pSrcData == NULL ) ||
		( srcDataSize == 0 ) ||
		( ppVertexShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pSrcData[%s] srcDataSize[%d] ppVertexShader[%s]",
			FAILED_CREATEVERTEXSHADER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pSrcData != NULL )? L"" : L"~",
			srcDataSize,
			( ppVertexShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::Buffer* pBuffer;
	ID3D11VertexShader* pD3DVertexShader;
	Mix::Graphics::DX11::VertexShader* pVertexShader;

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( ( pBuffer != NULL ) &&
		( pBuffer->Create( srcDataSize ) == True ) ) 
	{
		Mix::Memory::Copy( pBuffer->GetPointer(), pSrcData, srcDataSize );
	}
	else
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEVERTEXSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}
	
	ret = m_pD3DDevice->CreateVertexShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DVertexShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreateVertexShader %s : Name[%s] Result[%s]", FAILED_CREATEVERTEXSHADER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pVertexShader = Mix::Graphics::DX11::VertexShader::CreateInstance( this, pD3DVertexShader, pBuffer, name.GetConstPtr() );
	if( pVertexShader != NULL )
	{
		( *ppVertexShader ) = pVertexShader;
	}
	else
	{
		MIX_RELEASE( pD3DVertexShader );
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEVERTEXSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"o[ebNXVF[_[쐬 : Name[%s]", name.GetConstPtr() );

	return True;
}

Boolean Device::CreatePixelShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IPixelShader** ppPixelShader )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppPixelShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppPixelShader[%s]",
			FAILED_CREATEPIXELSHADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppPixelShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Memory::IBuffer* pBuffer;
	Mix::Graphics::DX11::PixelShader* pPixelShader;
	ID3D11PixelShader* pD3DPixelShader;

	if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_CREATEPIXELSHADER, pFileName );
		return False;
	}

	ret = m_pD3DDevice->CreatePixelShader( pBuffer->GetConstPointer(), pBuffer->GetSize(), NULL, &pD3DPixelShader );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_LOG_ERROR( L"%s : CreatePixelShader %s : File[%s] Result[%s]", FAILED_CREATEPIXELSHADER, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	MIX_RELEASE( pBuffer );

	pPixelShader = Mix::Graphics::DX11::PixelShader::CreateInstance( this, pD3DPixelShader, pFileName );
	if( pPixelShader != NULL )
	{
		( *ppPixelShader ) = pPixelShader;
	}
	else
	{
		MIX_RELEASE( pD3DPixelShader );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEPIXELSHADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"sNZVF[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Device::CreatePixelShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IPixelShader** ppPixelShader, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( pSrcData == NULL ) ||
		( srcDataSize == 0 ) ||
		( ppPixelShader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pSrcData[%s] srcDataSize[%d] ppPixelShader[%s]",
			FAILED_CREATEPIXELSHADER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			( pSrcData != NULL )? L"" : L"~",
			srcDataSize,
			( ppPixelShader != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Graphics::DX11::PixelShader* pPixelShader;
	ID3D11PixelShader* pD3DPixelShader;

	ret = m_pD3DDevice->CreatePixelShader( pSrcData, srcDataSize, NULL, &pD3DPixelShader );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreatePixelShader %s : Name[%s] Result[%s]", FAILED_CREATEPIXELSHADER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pPixelShader = Mix::Graphics::DX11::PixelShader::CreateInstance( this, pD3DPixelShader, name.GetConstPtr() );
	if( pPixelShader != NULL )
	{
		( *ppPixelShader ) = pPixelShader;
	}
	else
	{
		MIX_RELEASE( pD3DPixelShader );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEPIXELSHADER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"sNZVF[_[쐬 : Name[%s]", name.GetConstPtr() );

	return True;
}

Boolean Device::CreateShaderConstant( UInt32 size, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IShaderConstant** ppShaderConstant, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( size == 0 ) ||
		( ppShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : size[%d] bDynamic[%s] pInitialData[%s] ppShaderConstant[%s]",
			FAILED_CREATESHADERCONST,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			size,
			( bDynamic == True )? L"" : L"~",
			( pInitialData != NULL )? L"" : L"~",
			( ppShaderConstant != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	UInt32 bufferSize;
	D3D11_BUFFER_DESC desc;
	ID3D11Buffer* pD3DBuffer;
	Mix::Graphics::DX11::ShaderConstant* pShaderConstant;

	bufferSize = ( size / 16 ) * 16;
	if( ( size % 16 ) > 0 )
	{
		bufferSize += 16;
	}

	desc.ByteWidth = bufferSize;
	desc.Usage = ( bDynamic == True )? D3D11_USAGE_DYNAMIC : D3D11_USAGE_DEFAULT;
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.CPUAccessFlags = ( bDynamic == True )? D3D11_CPU_ACCESS_WRITE : 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;

	if( pInitialData != NULL )
	{
		D3D11_SUBRESOURCE_DATA data;

		data.pSysMem = pInitialData;
		data.SysMemPitch = 0;
		data.SysMemSlicePitch = 0;

		ret = m_pD3DDevice->CreateBuffer( &desc, &data, &pD3DBuffer );
	}
	else
	{
		ret = m_pD3DDevice->CreateBuffer( &desc, NULL, &pD3DBuffer );
	}

	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateBuffer %s : Name[%s] Result[%s]", FAILED_CREATESHADERCONST, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pShaderConstant = Mix::Graphics::DX11::ShaderConstant::CreateInstance( this, bufferSize, bDynamic, pD3DBuffer, name.GetConstPtr() );
	if( pShaderConstant != NULL )
	{
		( *ppShaderConstant ) = pShaderConstant;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATESHADERCONST, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		MIX_RELEASE( pD3DBuffer );
		return False;
	}

	MIX_LOG_INFO( L"VF[_[萔쐬 : Name[%s] Size[%d] Dynamic[%s] %s",
		name.GetConstPtr(),
		bufferSize,
		( bDynamic == True )? L"" : L"~",
		( size != bufferSize )? L": TCY16̔{ɏC܂" : L"" );

	return True;
}

Boolean Device::CreateVertexBuffer( UInt32 count, UInt32 stride, UInt32 resizeStep, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IVertexBuffer** ppVertexBuffer, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( count == 0 ) ||
		( stride == 0 ) ||
		( ppVertexBuffer == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : count[%d] stride[%d] resizeStep[%d] bDyanamic[%s] pInitialData[%s] ppVertexBuffer[%s]",
			FAILED_CREATEVERTEXBUFFER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			count,
			stride,
			resizeStep,
			( bDynamic == True )? L"" : L"~",
			( pInitialData != NULL )? L"" : L"~",
			( ppVertexBuffer != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Graphics::DX11::VertexBuffer* pVertexBuffer;

	pVertexBuffer = Mix::Graphics::DX11::VertexBuffer::CreateInstance( this, count, stride, resizeStep, bDynamic, name.GetConstPtr() );
	if( pVertexBuffer == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEVERTEXBUFFER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	ret = pVertexBuffer->Initialize( pInitialData );
	if( ret == S_OK )
	{
		( *ppVertexBuffer ) = pVertexBuffer;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : Initialize %s : Name[%s] Result[%s]", FAILED_CREATEVERTEXBUFFER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pVertexBuffer );
		return False;
	}

	MIX_LOG_INFO( L"o[ebNXobt@쐬 : Name[%s] Count[%d] Stride[%d] ResizeStep[%d] Dynamic[%s]",
		name.GetConstPtr(),
		count,
		stride,
		resizeStep,
		( bDynamic == True )? L"" : L"~"
		);

	return True;
}

Boolean Device::CreateIndexBuffer( Mix::Graphics::INDEX_TYPE type, UInt32 count, UInt32 resizeStep, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IIndexBuffer** ppIndexBuffer, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( count == 0 ) ||
		( ppIndexBuffer == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : count[%d] resizeStep[%d] bDynamic[%s] initialData[%s] indexBuffer[%s]",
			FAILED_CREATEINDEXBUFFER,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			count,
			resizeStep,
			( bDynamic == True )? L"" : L"~",
			( pInitialData != NULL )? L"" : L"~",
			( ppIndexBuffer != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Graphics::DX11::IndexBuffer* pIndexBuffer;

	if( m_IndexTypeSupportList[type] == False )
	{
		MIX_LOG_ERROR( L"%s : w肳ꂽCfbNX^Cv̓T|[gĂ܂ : IndexType[%s]", FAILED_CREATEINDEXBUFFER, D3DIndexFormatTextTable[type] );
		return False;
	}

	if( ( bDynamic == False ) &&
		( resizeStep > 0 ) )
	{
		MIX_LOG_WARNING( L"%s : Ił͂Ȃ̂ɃTCYXebvw肳Ă܂ : Name[%s]", FAILED_CREATEINDEXBUFFER, name.GetConstPtr() );
	}

	pIndexBuffer = Mix::Graphics::DX11::IndexBuffer::CreateInstance( this, type, count, resizeStep, bDynamic, name.GetConstPtr() );
	if( pIndexBuffer == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEINDEXBUFFER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	ret = pIndexBuffer->Initialize( pInitialData );
	if( ret == S_OK )
	{
		( *ppIndexBuffer ) = pIndexBuffer;
	}
	else
	{
		MIX_RELEASE( pIndexBuffer );
		MIX_LOG_ERROR( L"%s : Initialize %s : Name[%s] Result[%s]", FAILED_CREATEINDEXBUFFER, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	MIX_LOG_INFO( L"CfbNXobt@쐬 : Name[%s] Count[%d] ResizeStep[%d] Dynamic[%s]",
		name.GetConstPtr(),
		count,
		resizeStep,
		( bDynamic == True )? L"" : L"~"
		);

	return True;
}

Boolean Device::CreateTextureFromFile( const wchar_t* pFileName, Mix::Graphics::ITexture** ppTexture )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppTexture[%s]",
			FAILED_CREATETEXTURE,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppTexture != NULL )? L"" : L"~"
			);

		return False;
	}

	Mix::Graphics::Common::DeviceObject* pDeviceObject = FindDeviceObject( pFileName );

	if( pDeviceObject != NULL )
	{
		switch( pDeviceObject->GetType() )
		{
		case Mix::Graphics::Common::DOT_TEXTURE_2D:
		case Mix::Graphics::Common::DOT_TEXTURE_CUBE:
			( *ppTexture ) = dynamic_cast<Mix::Graphics::ITexture*>( pDeviceObject );
			( *ppTexture )->AddRef();

			MIX_LOG_INFO( L"eNX`쐬 : LbV擾 : File[%s]", pFileName );
			break;
		default:
			MIX_LOG_ERROR( L"%s : w肳ꂽt@C̓eNX`ł͂܂ : File[%s]", FAILED_CREATETEXTURE, pFileName );
			return False;
		}
	}
	else
	{
		D3D11_TEXTURE2D_DESC desc;
		ID3D11Texture2D* pD3DTexture;
		ID3D11ShaderResourceView* pD3DSRView;
		Mix::Memory::IBuffer* pBuffer;

		//obt@쐬
		if( m_pFileMgr->CreateBufferFromFile( pFileName, &pBuffer ) == False )
		{
			return False;
		}

		//obt@玟`FbN
		if( GetTextureDimension( pBuffer->GetConstPointer(), pBuffer->GetSize() ) != 2 )
		{
			MIX_LOG_ERROR( L"%s : 2DeNX`̂݃T|[gĂ܂ : File[%s]", FAILED_CREATETEXTURE, pFileName );
			MIX_RELEASE( pBuffer );
			return False;
		}

		//eNX`쐬
		if( CreateDeviceObject( pBuffer->GetConstPointer(), pBuffer->GetSize(), desc, &pD3DTexture, &pD3DSRView ) == False )
		{
			MIX_RELEASE( pBuffer );
			MIX_LOG_ERROR( L"%s : sȃeNX` : File[%s]", FAILED_CREATETEXTURE, pFileName );
			return False;
		}

		MIX_RELEASE( pBuffer );

		if( MIX_TESTBIT( desc.MiscFlags, D3D11_RESOURCE_MISC_TEXTURECUBE ) != D3D11_RESOURCE_MISC_TEXTURECUBE )
		{
			Mix::Graphics::DX11::Texture2D* pTexture;

			pTexture = Mix::Graphics::DX11::Texture2D::CreateInstance(	this,
																		False, desc.Width, desc.Height, Device::ConvertTextureFormat( desc.Format ),
																		pD3DTexture, pD3DSRView,
																		True, pFileName );
			if( pTexture == NULL )
			{
				MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATETEXTURE, Mix::STR_OUTOFMEMORY, pFileName );
				MIX_RELEASE( pD3DSRView );
				MIX_RELEASE( pD3DTexture );
				return False;
			}

			( *ppTexture ) = pTexture;

			MIX_LOG_INFO( L"eNX`쐬 : File[%s] Width[%d] Height[%d]", pFileName, desc.Width, desc.Height );
		}
		else
		{
			Mix::Graphics::DX11::TextureCube* pTexture;

			pTexture = Mix::Graphics::DX11::TextureCube::CreateInstance(	this,
																			desc.Width, desc.Height, Device::ConvertTextureFormat( desc.Format ),
																			pD3DTexture, pD3DSRView, NULL,
																			True, pFileName );
			if( pTexture == NULL )
			{
				MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATETEXTURE, Mix::STR_OUTOFMEMORY, pFileName );
				MIX_RELEASE( pD3DSRView );
				MIX_RELEASE( pD3DTexture );
				return False;
			}

			( *ppTexture ) = pTexture;

			MIX_LOG_INFO( L"eNX`쐬 : File[%s] Width[%d] Height[%d]", pFileName, desc.Width, desc.Height );
		}
	}

	return True;
}

Boolean Device::CreateTextureFromMemory( const wchar_t* pName, const void* pSrc, UInt32 srcSize, Mix::Graphics::ITexture** ppTexture )
{
	if( ( pName == NULL ) ||
		( ::wcslen( pName ) == 0 ) ||
		( pSrc == NULL ) ||
		( srcSize == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pName[%s] pSrc[%s] srcSize[%d] ppTexture[%s]",
			FAILED_CREATETEXTURE,
			Mix::STR_ILLEGALARG,
			( pName != NULL )? pName : L"NULL",
			( pSrc != NULL )? L"" : L"~",
			srcSize,
			( ppTexture != NULL )? L"" : L"~"
			);

		return False;
	}

	Mix::Graphics::Common::DeviceObject* pDeviceObject = FindDeviceObject( pName );

	if( pDeviceObject != NULL )
	{
		if( pDeviceObject->GetType() == Mix::Graphics::Common::DOT_TEXTURE_2D )
		{
			( *ppTexture ) = dynamic_cast<Mix::Graphics::DX11::Texture2D*>( pDeviceObject );
			( *ppTexture )->AddRef();
			MIX_LOG_INFO( L"eNX`쐬 : LbV擾 : Name[%s]", pName );
		}
		else
		{
			MIX_LOG_ERROR( L"%s : w肳ꂽt@C̓eNX`ł͂܂ : Name[%s]", FAILED_CREATETEXTURE, pName );
			return False;
		}
	}
	else
	{
		D3D11_TEXTURE2D_DESC desc;
		ID3D11Texture2D* pD3DTexture;
		ID3D11ShaderResourceView* pD3DSRView;
		Mix::Graphics::DX11::Texture2D* pTexture;

		//obt@玟`FbN
		if( GetTextureDimension( pSrc, srcSize ) != 2 )
		{
			MIX_LOG_ERROR( L"%s : 2DeNX`̂݃T|[gĂ܂ : Name[%s]", FAILED_CREATETEXTURE, pName );
			return False;
		}

		//eNX`쐬
		if( CreateDeviceObject( pSrc, srcSize, desc, &pD3DTexture, &pD3DSRView ) == False )
		{
			MIX_LOG_ERROR( L"%s : sȃeNX` : Name[%s]", FAILED_CREATETEXTURE, pName );
			return False;
		}

		//eNX`C^[tF[X쐬
		pTexture = Mix::Graphics::DX11::Texture2D::CreateInstance(	this,
																	False, desc.Width, desc.Height, Device::ConvertTextureFormat( desc.Format ),
																	pD3DTexture, pD3DSRView,
																	True, pName );
		if( pTexture != NULL )
		{
			( *ppTexture ) = pTexture;
		}
		else
		{
			MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATETEXTURE, Mix::STR_OUTOFMEMORY );
		}

		MIX_LOG_INFO( L"eNX`쐬 : Name[%s] Width[%d] Height[%d]", pName, desc.Width, desc.Height );
	}

	return True;
}

Boolean Device::CreateCubeTexture( UInt32 edgeLength, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( edgeLength == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : edgeLength[%d] ppTexture[%s]",
			FAILED_CREATECUBETEXTURE,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			edgeLength,
			MIX_LOG_PTR( ppTexture ) );

		return False;
	}

	HRESULT ret;
	D3D11_TEXTURE2D_DESC desc;
	D3D11_SHADER_RESOURCE_VIEW_DESC srvDesc;
	D3D11_RENDER_TARGET_VIEW_DESC rtvDesc;
	ID3D11Texture2D* pD3DTexture;
	ID3D11RenderTargetView* pD3DRTView;
	ID3D11ShaderResourceView* pD3DSRView;
	Mix::Graphics::DX11::TextureCube* pTexture;

	if( MIX_TESTBIT( m_ResourceFmtList[format].flags, Device::RS_CUBE ) != Device::RS_CUBE )
	{
		MIX_LOG_ERROR( L"%s : T|[gȂtH[}bg : Name[%s] Format[%s]", FAILED_CREATECUBETEXTURE, name.GetConstPtr(), GetFormatText( format ) );
		return False;
	}

	desc.Width = edgeLength;
	desc.Height = edgeLength;
	desc.MipLevels = 1;
	desc.ArraySize = Mix::Graphics::CUBEMAP_FACE_MAX;
	desc.Format = m_ResourceFmtList[format].format;
	desc.SampleDesc.Count = 1;
	desc.SampleDesc.Quality = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	desc.BindFlags = ( D3D11_BIND_SHADER_RESOURCE | D3D11_BIND_RENDER_TARGET );
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = D3D11_RESOURCE_MISC_TEXTURECUBE;

	ret = m_pD3DDevice->CreateTexture2D( &desc, NULL, &pD3DTexture );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateTexture2D %s : Name[%s] Result[%s]", FAILED_CREATECUBETEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	srvDesc.Format = m_ResourceFmtList[format].format;
	srvDesc.ViewDimension = D3D11_SRV_DIMENSION_TEXTURECUBE;
	srvDesc.TextureCube.MostDetailedMip	= 0;
	srvDesc.TextureCube.MipLevels = desc.MipLevels;

	ret = m_pD3DDevice->CreateShaderResourceView( pD3DTexture, &srvDesc, &pD3DSRView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateShaderResourceView %s : Name[%s] Result[%s]", FAILED_CREATECUBETEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	rtvDesc.Format = m_ResourceFmtList[format].format;
	rtvDesc.ViewDimension = D3D11_RTV_DIMENSION_TEXTURE2DARRAY;
	rtvDesc.Texture2DArray.MipSlice = 0;
	rtvDesc.Texture2DArray.FirstArraySlice = 0;
	rtvDesc.Texture2DArray.ArraySize = Mix::Graphics::CUBEMAP_FACE_MAX;

	ret = m_pD3DDevice->CreateRenderTargetView( pD3DTexture, &rtvDesc, &pD3DRTView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateRenderTargetView %s : Name[%s] Result[%s]", FAILED_CREATECUBETEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	pTexture = Mix::Graphics::DX11::TextureCube::CreateInstance(	this,
																	edgeLength, edgeLength, Device::ConvertTextureFormat( desc.Format ),
																	pD3DTexture, pD3DSRView, pD3DRTView,
																	False, name.GetConstPtr() );
	if( pTexture == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATECUBETEXTURE, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		MIX_RELEASE( pD3DSRView );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	MIX_LOG_INFO( L"L[ueNX`쐬 : Name[%s] EdgeLength[%d] Format[%s]", name.GetConstPtr(), edgeLength, GetFormatText( format ) );

	return True;
}

Boolean Device::CreateDynamicTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( width == 0 ) ||
		( height == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : width[%d] height[%d] format[%s] ppTexture[%s]",
			FAILED_CREATEDYNAMICTEXTURE,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			width,
			height,
			GetFormatText( format ),
			( ppTexture != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	D3D11_TEXTURE2D_DESC desc;
	ID3D11Texture2D* pD3DTexture;
	ID3D11ShaderResourceView* pD3DView;
	Mix::Graphics::DX11::Texture2D* pTexture;

	if( MIX_TESTBIT( m_ResourceFmtList[format].flags, Device::RS_TEXTURE2D ) != Device::RS_TEXTURE2D )
	{
		MIX_LOG_ERROR( L"%s : T|[gȂtH[}bg : Name[%s] Format[%s]", FAILED_CREATEDYNAMICTEXTURE, name.GetConstPtr(), GetFormatText( format ) );
		return False;
	}

	desc.Width = width;
	desc.Height = height;
	desc.MipLevels = 1;
	desc.ArraySize = 1;
	desc.Format = m_ResourceFmtList[format].format;
	desc.SampleDesc.Count = 1;
	desc.SampleDesc.Quality = 0;
	desc.Usage = D3D11_USAGE_DYNAMIC;
	desc.BindFlags = D3D11_BIND_SHADER_RESOURCE;
	desc.CPUAccessFlags = D3D11_CPU_ACCESS_WRITE;
	desc.MiscFlags = 0;

	ret = m_pD3DDevice->CreateTexture2D( &desc, NULL, &pD3DTexture );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateTexture2D %s : Name[%s] Result[%s]", FAILED_CREATEDYNAMICTEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	ret = m_pD3DDevice->CreateShaderResourceView( pD3DTexture, NULL, &pD3DView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateShaderResourceView %s : Name[%s] Result[%s]", FAILED_CREATEDYNAMICTEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	pTexture = Mix::Graphics::DX11::Texture2D::CreateInstance(	this,
																True, width, height, Device::ConvertTextureFormat( desc.Format ),
																pD3DTexture, pD3DView,
																False, name.GetConstPtr() );
	if( pTexture != NULL )
	{
		( *ppTexture ) = pTexture;
	}
	else
	{
		MIX_RELEASE( pD3DView );
		MIX_RELEASE( pD3DTexture );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEDYNAMICTEXTURE, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"_Ci~bNeNX`쐬 : Name[%s] Width[%d] Height[%d] Format[%s]",
		name.GetConstPtr(),
		width,
		height,
		GetFormatText( format ) );

	return True;
}

Boolean Device::CreateTargetTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName )
{
	Mix::String safeName = MIX_SAFE_NAME( pName );

	if( ( width == 0 ) ||
		( height == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : width[%d] height[%d] format[%s] ppTexture[%s]",
			FAILED_CREATETARGETTEXTURE,
			Mix::STR_ILLEGALARG,
			safeName.GetConstPtr(),
			width,
			height,
			GetFormatText( format ),
			( ppTexture != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	D3D11_TEXTURE2D_DESC desc;
	D3D11_RENDER_TARGET_VIEW_DESC rtDesc;
	D3D11_SHADER_RESOURCE_VIEW_DESC srDesc;
	ID3D11Texture2D* pD3DTexture;
	ID3D11RenderTargetView* pD3DRTView;
	ID3D11ShaderResourceView* pD3DSRView;
	Mix::Graphics::DX11::TextureTarget* pTexture;

	if( MIX_TESTBIT( m_ResourceFmtList[format].flags, Device::RS_TARGET ) != Device::RS_TARGET )
	{
		MIX_LOG_ERROR( L"%s : T|[gȂtH[}bg : Name[%s] Format[%s]", FAILED_CREATETARGETTEXTURE, safeName.GetConstPtr(), GetFormatText( format ) );
		return False;
	}

	desc.Width = width;
	desc.Height = height;
	desc.MipLevels = 1;
	desc.ArraySize = 1;
	desc.Format = m_ResourceFmtList[format].format;
	desc.SampleDesc.Count = 1;
	desc.SampleDesc.Quality = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	desc.BindFlags = ( D3D11_BIND_SHADER_RESOURCE | D3D11_BIND_RENDER_TARGET );
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;

	ret = m_pD3DDevice->CreateTexture2D( &desc, NULL, &pD3DTexture );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateTexture2D %s : Name[%s] Result[%s]", FAILED_CREATETARGETTEXTURE, Mix::STR_RETERROR, safeName.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	rtDesc.Format = m_ResourceFmtList[format].format;
	rtDesc.ViewDimension = D3D11_RTV_DIMENSION_TEXTURE2D;
	rtDesc.Texture2D.MipSlice = 0;

	ret = m_pD3DDevice->CreateRenderTargetView( pD3DTexture, &rtDesc, &pD3DRTView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateRenderTargetView %s : Name[%s] Result[%s]", FAILED_CREATETARGETTEXTURE, Mix::STR_RETERROR, safeName.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	srDesc.Format = m_ResourceFmtList[format].format;
	srDesc.ViewDimension = D3D11_SRV_DIMENSION_TEXTURE2D;
	srDesc.Texture2D.MostDetailedMip = 0;
	srDesc.Texture2D.MipLevels = 1;

	ret = m_pD3DDevice->CreateShaderResourceView( pD3DTexture, &srDesc, &pD3DSRView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateShaderResourceView %s : Name[%s] Result[%s]", FAILED_CREATETARGETTEXTURE, Mix::STR_RETERROR, safeName.GetConstPtr(), GetD3DResultText( ret ) );
		MIX_RELEASE( pD3DRTView );
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	pTexture = Mix::Graphics::DX11::TextureTarget::CreateInstance(	this,
																	width, height, format,
																	pD3DTexture, pD3DRTView, pD3DSRView,
																	safeName.GetConstPtr() );
	if( pTexture != NULL )
	{
		( *ppTexture ) = pTexture;
	}
	else
	{
		MIX_RELEASE( pD3DRTView );
		MIX_RELEASE( pD3DSRView );
		MIX_RELEASE( pD3DTexture );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATETARGETTEXTURE, Mix::STR_OUTOFMEMORY, safeName.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"^[QbgeNX`쐬 : Name[%s] Width[%d] Height[%d] Format[%s]", safeName.GetConstPtr(), width, height, GetFormatText( format ) );

	return True;
}

Boolean Device::CreateDepthTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName )
{
	Mix::String name = MIX_SAFE_NAME( pName );

	if( ( width == 0 ) ||
		( height == 0 ) ||
		( ppTexture == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : width[%d] height[%d] format[%d] ppTexture[%s]",
			FAILED_CREATEDEPTHTEXTURE,
			Mix::STR_ILLEGALARG,
			name.GetConstPtr(),
			width,
			height,
			GetFormatText( format ),
			( ppTexture != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	D3D11_TEXTURE2D_DESC texDesc;
	D3D11_DEPTH_STENCIL_VIEW_DESC dsViewDesc;
	ID3D11Texture2D* pD3DTexture;
	ID3D11DepthStencilView* pD3DDSView;
	Mix::Graphics::DX11::TextureDepth* pTexture;

	if( MIX_TESTBIT( m_ResourceFmtList[format].flags, Device::RS_DEPTH_STENCIL ) != Device::RS_DEPTH_STENCIL )
	{
		MIX_LOG_ERROR( L"%s : T|[gȂtH[}bg : Name[%s ]Format[%s]", FAILED_CREATEDEPTHTEXTURE, name.GetConstPtr(), GetFormatText( format ) );
		return False;
	}

	texDesc.Width = width;
	texDesc.Height = height;
	texDesc.MipLevels = 1;
	texDesc.ArraySize = 1;
	texDesc.Format = m_ResourceFmtList[format].format;
	texDesc.SampleDesc.Count = 1;
	texDesc.SampleDesc.Quality = 0;
	texDesc.Usage = D3D11_USAGE_DEFAULT;
	texDesc.BindFlags = D3D11_BIND_DEPTH_STENCIL;
	texDesc.CPUAccessFlags = 0;
	texDesc.MiscFlags = 0;

	ret = m_pD3DDevice->CreateTexture2D( &texDesc, NULL, &pD3DTexture );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateTexture2D %s : Name[%s] Result[%s]", FAILED_CREATEDEPTHTEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	dsViewDesc.Format = m_ResourceFmtList[format].format;
	dsViewDesc.ViewDimension = D3D11_DSV_DIMENSION_TEXTURE2D;
	dsViewDesc.Flags = 0;
	dsViewDesc.Texture2D.MipSlice = 0;

	ret = m_pD3DDevice->CreateDepthStencilView( pD3DTexture, &dsViewDesc, &pD3DDSView );
	if( ret != S_OK )
	{
		MIX_RELEASE( pD3DTexture );
		MIX_LOG_ERROR( L"%s : CreateDepthStencilView %s : Name[%s] Result[%s]", FAILED_CREATEDEPTHTEXTURE, Mix::STR_RETERROR, name.GetConstPtr(), GetD3DResultText( ret ) );
		return False;
	}

	pTexture = Mix::Graphics::DX11::TextureDepth::CreateInstance(	this,
																	width, height, format,
																	pD3DTexture, pD3DDSView,
																	name.GetConstPtr() );
	if( pTexture != NULL )
	{
		( *ppTexture ) = pTexture;
	}
	else
	{
		MIX_RELEASE( pD3DDSView );
		MIX_RELEASE( pD3DTexture );
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEDEPTHTEXTURE, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	MIX_LOG_INFO( L"fvXeNX`쐬 : Name[%s] Width[%d] Height[%d] Format[%s]", name.GetConstPtr(), width, height, GetFormatText( format ) );

	return True;
}

Boolean Device::CreateQuery( Mix::Graphics::QUERY_TYPE type, Mix::Graphics::IQuery** ppQuery )
{
	if( ppQuery == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : ppQuery[%s]", FAILED_CREATEQUERY, Mix::STR_ILLEGALARG, ( ppQuery != NULL )? L"" : L"~" );
		return False;
	}

	HRESULT ret;
	ID3D11Query* pD3DQuery;
	Mix::Graphics::DX11::Query* pQuery;

	ret = m_pD3DDevice->CreateQuery( &( Device::D3DQueryDescTable[type] ), &pD3DQuery );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : ID3D11Device::CreateQuery %s : Type[%s] Result[%s]", FAILED_CREATEQUERY, Mix::STR_RETERROR, Device::D3DQueryTextTable[type], GetD3DResultText( ret ) );
		return False;
	}

	pQuery = Mix::Graphics::DX11::Query::CreateInstance( this, type, pD3DQuery, NULL );
	if( pQuery != NULL )
	{
		( *ppQuery ) = pQuery;
	}
	else
	{
		MIX_RELEASE( pD3DQuery );
		MIX_LOG_ERROR( L"%s : %s : Type[%s]", FAILED_CREATEQUERY, Mix::STR_OUTOFMEMORY, Device::D3DQueryTextTable[type] );
		return False;
	}

	MIX_LOG_INFO( L"NG쐬 : Type[%s]", Device::D3DQueryTextTable[type] );

	return True;
}

Boolean Device::CheckTextureFormat( Mix::Graphics::FORMAT format )
{
	return ( ( m_ResourceFmtList[format].flags & Device::RS_TEXTURE2D ) == Device::RS_TEXTURE2D );
}

Boolean Device::CheckCubeTextureFormat( Mix::Graphics::FORMAT format )
{
	return ( ( m_ResourceFmtList[format].flags & Device::RS_CUBE ) == Device::RS_CUBE );
}

Boolean Device::CheckDynamicTextureFormat( Mix::Graphics::FORMAT format )
{
	return ( ( m_ResourceFmtList[format].flags & Device::RS_TEXTURE2D ) == Device::RS_TEXTURE2D );
}

Boolean Device::CheckTargetTextureFormat( Mix::Graphics::FORMAT format )
{
	return ( ( m_ResourceFmtList[format].flags & Device::RS_TARGET ) == Device::RS_TARGET );
}

Boolean Device::CheckDepthTextureFormat( Mix::Graphics::FORMAT format )
{
	return ( ( m_ResourceFmtList[format].flags & Device::RS_DEPTH_STENCIL ) == Device::RS_DEPTH_STENCIL );
}

Boolean Device::CheckIndexType( Mix::Graphics::INDEX_TYPE type )
{
	return m_IndexTypeSupportList[type];
}

void Device::ChangeWindowMode( Boolean bWindowed )
{
	if( m_bWindowed == bWindowed )
	{
		return;
	}

	if( m_pDXGISwapChain->SetFullscreenState( !bWindowed, NULL ) == S_OK )
	{
		ResizeBackBuffer();
		m_bWindowed = bWindowed;
	}
}

Boolean Device::GetWindowMode( void ) const
{
	return m_bWindowed;
}

Boolean Device::Begin( void )
{
	m_DrawPrimitiveCount = 0;

	return True;
}

void Device::End( void )
{
	ResetTargetState();
	ResetDrawState();
}

void Device::Present( void )
{
	m_pDXGISwapChain->Present( ( m_bWaitVSync == True )? 1 : 0, 0 );
}

void Device::SetTarget( Mix::Graphics::ITexture* pT0, Mix::Graphics::ITexture* pT1, Mix::Graphics::ITexture* pT2, Mix::Graphics::ITexture* pT3, Mix::Graphics::ITexture* pDS )
{
	if( ( ( pT0 != NULL ) && ( pT0->GetType() != Mix::Graphics::TEXTURE_TARGET ) ) ||
		( ( pT1 != NULL ) && ( pT1->GetType() != Mix::Graphics::TEXTURE_TARGET ) ) ||
		( ( pT2 != NULL ) && ( pT2->GetType() != Mix::Graphics::TEXTURE_TARGET ) ) ||
		( ( pT3 != NULL ) && ( pT3->GetType() != Mix::Graphics::TEXTURE_TARGET ) ) ||
		( ( pDS != NULL ) && ( pDS->GetType() != Mix::Graphics::TEXTURE_DEPTH ) ) )
	{
		MIX_LOG_ERROR( L"^[Qbg̐ݒɎs : ȃ^[Qbgw肳Ă܂ : pT0[%s] pT1[%s] pT2[%s] pT3[%s] pDS[%s]",
			( ( pT0 == NULL ) || ( pT0->GetType() == Mix::Graphics::TEXTURE_TARGET ) )? L"" : L"~",
			( ( pT1 == NULL ) || ( pT1->GetType() == Mix::Graphics::TEXTURE_TARGET ) )? L"" : L"~",
			( ( pT2 == NULL ) || ( pT2->GetType() == Mix::Graphics::TEXTURE_TARGET ) )? L"" : L"~",
			( ( pT3 == NULL ) || ( pT3->GetType() == Mix::Graphics::TEXTURE_TARGET ) )? L"" : L"~",
			( ( pDS == NULL ) || ( pDS->GetType() == Mix::Graphics::TEXTURE_DEPTH ) )? L"" : L"~" );

		return;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ID3D11DeviceContext Ƀ^[Qbgݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	ID3D11ShaderResourceView* pSRViewArray[10] = { NULL };	//eNX`Xe[Wő吔NA( ^[QbgAeNX`̂قݒł郊\[X )
	ID3D11RenderTargetView* pRTViewArray[Mix::Graphics::TARGET_MAX];
	ID3D11DepthStencilView* pDSView;

	pRTViewArray[0] = ( pT0 != NULL )? static_cast<Mix::Graphics::DX11::TextureTarget*>( pT0 )->GetRTView() : m_pBackBufferView;
	pRTViewArray[1] = ( pT1 != NULL )? static_cast<Mix::Graphics::DX11::TextureTarget*>( pT1 )->GetRTView() : NULL;
	pRTViewArray[2] = ( pT2 != NULL )? static_cast<Mix::Graphics::DX11::TextureTarget*>( pT2 )->GetRTView() : NULL;
	pRTViewArray[3] = ( pT3 != NULL )? static_cast<Mix::Graphics::DX11::TextureTarget*>( pT3 )->GetRTView() : NULL;

	pDSView = ( pDS != NULL )? static_cast<Mix::Graphics::DX11::TextureDepth*>( pDS )->GetDSView() : NULL;

	m_pD3DDeviceContext->PSSetShaderResources( 0, 10, pSRViewArray );
	m_pD3DDeviceContext->OMSetRenderTargets( Mix::Graphics::TARGET_MAX, pRTViewArray, pDSView );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// eNX`̔j( VF[_[\[X NULL ɐݒ肵 )
	////////////////////////////////////////////////////////////////////////////////////////////////////

	//eNX`
	for( UInt32 i = 0; i < Mix::Graphics::TEXTURESTAGE_MAX; i++ )
	{
		m_DrawState.textureTable[i] = NULL;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ^[Qbgۑ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( pT0 != NULL )
	{
		m_TargetState.rect = Mix::Rectangle( 0, 0, pT0->GetWidth(), pT0->GetHeight() );
	}
	else
	{
		m_TargetState.rect = Mix::Rectangle( 0, 0, m_ScreenSize.x, m_ScreenSize.y );
	}

	MIX_RELEASE( m_TargetState.pT0 );
	MIX_ADD_REF( pT0 );
	m_TargetState.pT0 = pT0;

	MIX_RELEASE( m_TargetState.pT1 );
	MIX_ADD_REF( pT1 );
	m_TargetState.pT1 = pT1;

	MIX_RELEASE( m_TargetState.pT2 );
	MIX_ADD_REF( pT2 );
	m_TargetState.pT2 = pT2;

	MIX_RELEASE( m_TargetState.pT3 );
	MIX_ADD_REF( pT3 );
	m_TargetState.pT3 = pT3;

	MIX_RELEASE( m_TargetState.pDS );
	MIX_ADD_REF( pDS );
	m_TargetState.pDS = pDS;
}

void Device::GetTarget( Mix::Graphics::ITexture** ppT0, Mix::Graphics::ITexture** ppT1, Mix::Graphics::ITexture** ppT2, Mix::Graphics::ITexture** ppT3, Mix::Graphics::ITexture** ppDS )
{
	if( ppT0 != NULL )
	{
		MIX_ADD_REF( m_TargetState.pT0 );
		( *ppT0 ) = m_TargetState.pT0;
	}

	if( ppT1 != NULL )
	{
		MIX_ADD_REF( m_TargetState.pT1 );
		( *ppT1 ) = m_TargetState.pT1;
	}

	if( ppT2 != NULL )
	{
		MIX_ADD_REF( m_TargetState.pT2 );
		( *ppT2 ) = m_TargetState.pT2;
	}

	if( ppT3 != NULL )
	{
		MIX_ADD_REF( m_TargetState.pT3 );
		( *ppT3 ) = m_TargetState.pT3;
	}

	if( ppDS != NULL )
	{
		MIX_ADD_REF( m_TargetState.pDS );
		( *ppDS ) = m_TargetState.pDS;
	}
}

void Device::SetViewport( Int32 x, Int32 y, Int32 width, Int32 height )
{
	if( m_TargetState.rect.Contains( Mix::Rectangle( x, y, width, height ), &m_ViewportRect ) == False )
	{
		m_ViewportRect.x = 0;
		m_ViewportRect.y = 0;
		m_ViewportRect.width = 1;
		m_ViewportRect.height = 1;
	}

	m_Viewport.TopLeftX = static_cast<Float32>( m_ViewportRect.x );
	m_Viewport.TopLeftY = static_cast<Float32>( m_ViewportRect.y );
	m_Viewport.Width = static_cast<Float32>( m_ViewportRect.width );
	m_Viewport.Height = static_cast<Float32>( m_ViewportRect.height );

	m_pD3DDeviceContext->RSSetViewports( 1, &m_Viewport );
}

void Device::SetViewport( const Mix::Rectangle& rect )
{
	SetViewport( rect.x, rect.y, rect.width, rect.height );
}

const Mix::Rectangle& Device::GetViewport( void ) const
{
	return m_ViewportRect;
}

Mix::Matrix4x4 Device::GetScreenTransformMatrix( void ) const
{
//	Float32 x = static_cast<Float32>( m_ViewportRect.x );
//	Float32 y = static_cast<Float32>( m_ViewportRect.y );
	Float32 w = static_cast<Float32>( m_ViewportRect.width );
	Float32 h = static_cast<Float32>( m_ViewportRect.height );

	Mix::Matrix4x4 mat;

	mat.m00 = MIX_FLOAT_DIV( +2.0f, w );
	mat.m11 = MIX_FLOAT_DIV( -2.0f, h );
	mat.m22 = 0.0f;
	mat.m30 = -1.0f + ( 1.0f / w );// + ( x * 2.0f / w );
	mat.m31 = +1.0f - ( 1.0f / h );// - ( y * 2.0f / h );
//	mat.m30 = -1.0f + ( x * 2.0f / w );
//	mat.m31 = +1.0f - ( y * 2.0f / h );

	return mat;
}

void Device::SetScissor( Int32 x, Int32 y, Int32 width, Int32 height )
{
	D3D11_RECT rect;

	if( m_TargetState.rect.Contains( Mix::Rectangle( x, y, width, height ), &m_ScissorRect ) == False )
	{
		m_ScissorRect.x = 0;
		m_ScissorRect.y = 0;
		m_ScissorRect.width = 1;
		m_ScissorRect.height = 1;
	}

	rect.left = m_ScissorRect.x;
	rect.top = m_ScissorRect.y;
	rect.right = m_ScissorRect.x + m_ScissorRect.width;
	rect.bottom = m_ScissorRect.y + m_ScissorRect.height;

	m_pD3DDeviceContext->RSSetScissorRects( 1, &rect );
}

void Device::SetScissor( const Mix::Rectangle& rect )
{
	SetScissor( rect.x, rect.y, rect.width, rect.height );
}

const Mix::Rectangle& Device::GetScissor( void ) const
{
	return m_ScissorRect;
}

void Device::Clear( Boolean clearTarget, Boolean clearDepth, const Mix::Vector4& color, Float32 z )
{
	UInt32 i;
	ID3D11RenderTargetView* rtvTable[Mix::Graphics::TARGET_MAX] = { NULL };
	ID3D11DepthStencilView* pDSView = NULL;

	//^[QbgƃfvX/XeV擾
	m_pD3DDeviceContext->OMGetRenderTargets( Mix::Graphics::TARGET_MAX, rtvTable, &pDSView );

	//^[QbgNA
	if( clearTarget == True )
	{
		for( i = 0; i < Mix::Graphics::TARGET_MAX; i++ )
		{
			if( rtvTable[i] != NULL )
			{
				m_pD3DDeviceContext->ClearRenderTargetView( rtvTable[i], color.data );
			}
		}
	}

	//fvX/XeVNA
	if( ( clearDepth == True ) &&
		( pDSView != NULL ) )
	{
		m_pD3DDeviceContext->ClearDepthStencilView( pDSView, D3D11_CLEAR_DEPTH, z, 0 );
	}

	//^[Qbg
	for( i = 0; i < Mix::Graphics::TARGET_MAX; i++ )
	{
		MIX_RELEASE( rtvTable[i] );
	}

	//fvXEXeV
	MIX_RELEASE( pDSView );
}

void Device::SetRasterizerState( Mix::Graphics::FILL_TYPE fillMode, Mix::Graphics::CULL_TYPE cullMode, Boolean bScissoring, Boolean bMultisample )
{
	Mix::Graphics::RASTERIZER_DESC desc;

	desc.fillMode = fillMode;
	desc.cullMode = cullMode;
	desc.bScissoring = bScissoring;

	SetRasterizerState( desc );
}

void Device::SetRasterizerState( const Mix::Graphics::RASTERIZER_DESC& desc )
{
	UInt32 fillIdx = desc.fillMode;
	UInt32 cullIdx = desc.cullMode;
	UInt32 scissorIdx = ( desc.bScissoring == True )? 1 : 0;

	m_RasterizeDesc = desc;
	m_pD3DDeviceContext->RSSetState( m_pRasterizerStateArray[fillIdx][cullIdx][scissorIdx] );
}

const Mix::Graphics::RASTERIZER_DESC& Device::GetRasterizerState( void ) const
{
	return m_RasterizeDesc;
}

void Device::SetDepthState( Boolean bTest, Boolean bWrite, Mix::Graphics::ZFUNC_TYPE func )
{
	Mix::Graphics::DEPTH_DESC desc;

	desc.bTest = bTest;
	desc.bWrite = bWrite;
	desc.func = func;

	SetDepthState( desc );
}

void Device::SetDepthState( const Mix::Graphics::DEPTH_DESC& desc )
{
	UInt32 testIdx = ( desc.bTest == True )? 1 : 0;
	UInt32 writeIdx = ( desc.bWrite == True )? 1 : 0;
	UInt32 funcIdx = desc.func;

	m_DepthDesc = desc;
	m_pD3DDeviceContext->OMSetDepthStencilState( m_pDepthStateArray[testIdx][writeIdx][funcIdx], 0 );
}

const Mix::Graphics::DEPTH_DESC& Device::GetDepthState( void ) const
{
	return m_DepthDesc;
}

void Device::SetBlendState( Mix::Graphics::BLEND_TYPE type, Mix::Graphics::COLOR_WRITE_MASK colorWriteMask )
{
	Mix::Graphics::BLEND_DESC desc;

	desc.type = type;
	desc.colorWriteMask = colorWriteMask;

	SetBlendState( desc );
}

void Device::SetBlendState( const Mix::Graphics::BLEND_DESC& desc )
{
	m_BlendDesc = desc;
	m_pD3DDeviceContext->OMSetBlendState( m_pBlendStateArray[m_BlendDesc.type][m_BlendDesc.colorWriteMask], NULL, 0xFFFFFFFF );
}

const Mix::Graphics::BLEND_DESC& Device::GetBlendState( void ) const
{
	return m_BlendDesc;
}

void Device::SetVertexLayout( Mix::Graphics::IVertexLayout* pVertexLayout )
{
	m_DrawState.next.pVertexLayout = pVertexLayout;
}

void Device::SetHullShader( Mix::Graphics::IHullShader* pHullShader )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"nVF[_[̐ݒɎs : VF[_[fT̏ꍇ̂ݎgpł܂" );
		return;
	}

	m_DrawState.next.pHullShader = pHullShader;
}

void Device::SetDomainShader( Mix::Graphics::IDomainShader* pDomainShader )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"hCVF[_[̐ݒɎs : VF[_[fT̏ꍇ̂ݎgpł܂" );
		return;
	}

	m_DrawState.next.pDomainShader = pDomainShader;
}

void Device::SetGeometryShader( Mix::Graphics::IGeometryShader* pGeometryShader )
{
	m_DrawState.next.pGeometryShader = pGeometryShader;
}

void Device::SetVertexShader( Mix::Graphics::IVertexShader* pVertexShader )
{
	m_DrawState.next.pVertexShader = pVertexShader;
}

void Device::SetPixelShader( Mix::Graphics::IPixelShader* pPixelShader )
{
	m_DrawState.next.pPixelShader = pPixelShader;
}

void Device::SetVertexShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count )
{
	MIX_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : VF[_[fSAT SetVertexShaderConstantB ͎gpł܂" );
}

void Device::SetVertexShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count )
{
	MIX_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : VF[_[fSAT SetVertexShaderConstantI ͎gpł܂" );
}

void Device::SetVertexShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count )
{
	MIX_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : VF[_[fSAT SetVertexShaderConstantF ͎gpł܂" );
}

void Device::SetVertexShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count )
{
	MIX_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : VF[_[fSAT SetVertexShaderConstantF ͎gpł܂" );
}

void Device::SetVertexShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count )
{
	MIX_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : VF[_[fSAT SetVertexShaderConstantF ͎gpł܂" );
}

void Device::SetPixelShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count )
{
	MIX_ERROR( L"sNZVF[_[RX^g̐ݒɎs : VF[_[fSAT SetPixelShaderConstantB ͎gpł܂" );
}

void Device::SetPixelShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count )
{
	MIX_ERROR( L"sNZVF[_[RX^g̐ݒɎs : VF[_[fSAT SetPixelShaderConstantI ͎gpł܂" );
}

void Device::SetPixelShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count )
{
	MIX_ERROR( L"sNZVF[_[RX^g̐ݒɎs : VF[_[fSAT SetPixelShaderConstantF ͎gpł܂" );
}

void Device::SetPixelShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count )
{
	MIX_ERROR( L"sNZVF[_[RX^g̐ݒɎs : VF[_[fSAT SetPixelShaderConstantF ͎gpł܂" );
}

void Device::SetPixelShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count )
{
	MIX_ERROR( L"sNZVF[_[RX^g̐ݒɎs : VF[_[fSAT SetPixelShaderConstantF ͎gpł܂" );
}

void Device::SetHullShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"nVF[_[RX^g̐ݒɎs : VF[_[fT̏ꍇ̂ݎgpł܂" );
		return;
	}

	if( ( slot >= D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT ) ||
		( pShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"nVF[_[RX^g̐ݒɎs : %s : slot[%d]( 0`13 ) pShaderConstant[%s]",
			Mix::STR_ILLEGALARG,
			slot,
			MIX_LOG_PTR( pShaderConstant ) );

		return;
	}

	if( m_DrawState.hscTable[slot] != pShaderConstant )
	{
		ID3D11Buffer* buffTable[1] = { static_cast<Mix::Graphics::DX11::ShaderConstant*>( pShaderConstant )->GetInterface() };

		m_pD3DDeviceContext->HSSetConstantBuffers( slot, 1, buffTable );
		m_DrawState.hscTable[slot] = pShaderConstant;
	}
}

void Device::SetDomainShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant )
{
	if( MIX_TESTBIT( m_Caps.flags, Device::HAL_DOMAIN_SHADER ) != Device::HAL_DOMAIN_SHADER )
	{
		MIX_LOG_ERROR( L"hCVF[_[RX^g̐ݒɎs : VF[_[fT̏ꍇ̂ݎgpł܂" );
		return;
	}

	if( ( slot >= D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT ) ||
		( pShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"hCVF[_[RX^g̐ݒɎs : %s : slot[%d]( 0`13 ) pShaderConstant[%s]",
			Mix::STR_ILLEGALARG,
			slot,
			MIX_LOG_PTR( pShaderConstant ) );

		return;
	}

	if( m_DrawState.dscTable[slot] != pShaderConstant )
	{
		ID3D11Buffer* buffTable[1] = { static_cast<Mix::Graphics::DX11::ShaderConstant*>( pShaderConstant )->GetInterface() };

		m_pD3DDeviceContext->DSSetConstantBuffers( slot, 1, buffTable );
		m_DrawState.dscTable[slot] = pShaderConstant;
	}
}

void Device::SetGeometryShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant )
{
	if( ( slot >= D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT ) ||
		( pShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"WIgVF[_[RX^g̐ݒɎs : %s : slot[%d]( 0`13 ) pShaderConstant[%s]",
			Mix::STR_ILLEGALARG,
			slot,
			MIX_LOG_PTR( pShaderConstant ) );

		return;
	}

	if( m_DrawState.gscTable[slot] != pShaderConstant )
	{
		ID3D11Buffer* buffTable[1] = { static_cast<Mix::Graphics::DX11::ShaderConstant*>( pShaderConstant )->GetInterface() };

		m_pD3DDeviceContext->GSSetConstantBuffers( slot, 1, buffTable );
		m_DrawState.gscTable[slot] = pShaderConstant;
	}
}

void Device::SetVertexShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant )
{
	if( ( slot >= D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT ) ||
		( pShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"o[ebNXVF[_[RX^g̐ݒɎs : %s : slot[%d]( 0`13 ) pShaderConstant[%s]",
			Mix::STR_ILLEGALARG,
			slot,
			MIX_LOG_PTR( pShaderConstant ) );

		return;
	}

	if( m_DrawState.vscTable[slot] != pShaderConstant )
	{
		ID3D11Buffer* buffTable[1] = { static_cast<Mix::Graphics::DX11::ShaderConstant*>( pShaderConstant )->GetInterface() };

		m_pD3DDeviceContext->VSSetConstantBuffers( slot, 1, buffTable );
		m_DrawState.vscTable[slot] = pShaderConstant;
	}
}

void Device::SetPixelShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant )
{
	if( ( slot >= D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT ) ||
		( pShaderConstant == NULL ) )
	{
		MIX_LOG_ERROR( L"sNZVF[_[RX^g̐ݒɎs : %s : slot[%d]( 0`13 ) pShaderConstant[%s]",
			Mix::STR_ILLEGALARG,
			slot,
			MIX_LOG_PTR( pShaderConstant ) );

		return;
	}

	if( m_DrawState.pscTable[slot] != pShaderConstant )
	{
		ID3D11Buffer* bufferTable[1] = { static_cast<Mix::Graphics::DX11::ShaderConstant*>( pShaderConstant )->GetInterface() };

		m_pD3DDeviceContext->PSSetConstantBuffers( slot, 1, bufferTable );
		m_DrawState.pscTable[slot] = pShaderConstant;
	}
}

void Device::SetVertexBuffer( Mix::Graphics::IVertexBuffer* pVertexBuffer )
{
	m_DrawState.next.pVertexBuffer = pVertexBuffer;
}

void Device::SetIndexBuffer( Mix::Graphics::IIndexBuffer* pIndexBuffer )
{
	m_DrawState.next.pIndexBuffer = pIndexBuffer;
}

UInt32 Device::GetTextureStageMax( void ) const
{
	return Mix::Graphics::TEXTURESTAGE_MAX;
}

void Device::SetTexture( UInt32 stage, Mix::Graphics::TEXTURE_FILTER_TYPE filter, Mix::Graphics::TEXTURE_ADDRESS_TYPE address, Mix::Graphics::ITexture* pTexture )
{
	if( GetTextureStageMax() <= stage )
	{
		MIX_LOG_ERROR( L"eNX`̐ݒɎs : %s : stage[0 <= %d <= 7]", Mix::STR_ILLEGALARG, stage );
		return;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Tv[Xe[g̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	::ID3D11SamplerState* ssTable[1] = { m_pSamplerArray[filter][address] };

	if( m_DrawState.samplerTable[stage] != ssTable[0] )
	{
		m_pD3DDeviceContext->PSSetSamplers( stage, 1, ssTable );
		m_DrawState.samplerTable[stage] = ssTable[0];
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// eNX`̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_DrawState.textureTable[stage] != pTexture )
	{
		::ID3D11ShaderResourceView* srvTable[1] = {
			( pTexture != NULL )? static_cast<Mix::Graphics::DX11::Texture*>( pTexture )->GetSRView() : NULL };

		m_pD3DDeviceContext->PSSetShaderResources( stage, 1, srvTable );
		m_DrawState.textureTable[stage] = pTexture;
	}
}

void Device::ResetTexture( UInt32 stage )
{
	if( stage >= Mix::Graphics::TEXTURESTAGE_MAX )
	{
		MIX_LOG_ERROR( L"eNX`̃ZbgɎs : %s : stage[0 <= %d <= 7]", Mix::STR_ILLEGALARG, stage );
		return;
	}

	if( m_DrawState.textureTable[stage] != NULL )
	{
		::ID3D11ShaderResourceView* srvTable[1] = { NULL };

		m_pD3DDeviceContext->PSSetShaderResources( stage, 1, srvTable );
		m_DrawState.textureTable[stage] = NULL;
	}
}

void Device::Draw( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex )
{
	if( numVertex == 0 )
	{
		MIX_LOG_ERROR( L"Mix::Graphics::IDevice::Draw : %s : numVertex[%d]", Mix::STR_ILLEGALARG, numVertex );
		return;
	}

	if( ( m_DrawState.next.pVertexLayout == NULL ) ||
		( m_DrawState.next.pVertexShader == NULL ) ||
		( m_DrawState.next.pPixelShader == NULL ) ||
		( m_DrawState.next.pVertexBuffer == NULL ) )
	{
		MIX_LOG_ERROR( L"Mix::Graphics::IDevice::Draw : `ɕKvȃ\[Xݒ肳Ă܂ : VertexLayout[%s] VertexShader[%s] PixelShader[%s] VertexBuffer[%s]",
			MIX_LOG_PTR( m_DrawState.next.pVertexLayout ),
			MIX_LOG_PTR( m_DrawState.next.pVertexShader ),
			MIX_LOG_PTR( m_DrawState.next.pPixelShader ),
			MIX_LOG_PTR( m_DrawState.next.pVertexBuffer ) );

		return;
	}

	FlushDrawState( 0, 0 );

	m_pD3DDeviceContext->IASetPrimitiveTopology( Device::D3DPrimitiveTopologyTable[primitiveType] );
	m_pD3DDeviceContext->Draw( numVertex, startVertex );

	m_DrawPrimitiveCount += ComputePrimitiveCount( primitiveType, numVertex );
}

void Device::DrawIndexed( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex, UInt32 startIndex, UInt32 numIndex )
{
	if( ( numVertex == 0 ) ||
		( numIndex == 0 ) )
	{
		MIX_LOG_ERROR( L"Mix::Graphics::IDevice::Draw : %s : numVertex[%d] numIndex[%d]", Mix::STR_ILLEGALARG, numVertex, numIndex );
		return;
	}

	if( ( m_DrawState.next.pVertexLayout == NULL ) ||
		( m_DrawState.next.pVertexShader == NULL ) ||
		( m_DrawState.next.pPixelShader == NULL ) ||
		( m_DrawState.next.pVertexBuffer == NULL ) ||
		( m_DrawState.next.pIndexBuffer == NULL ) )
	{
		MIX_LOG_ERROR( L"Mix::Graphics::IDevice::DrawIndexed : `ɕKvȃ\[Xݒ肳Ă܂ : VertexLayout[%s] VertexShader[%s] PixelShader[%s] VertexBuffer[%s] IndexBuffer[%s]",
			MIX_LOG_PTR( m_DrawState.next.pVertexLayout ),
			MIX_LOG_PTR( m_DrawState.next.pVertexShader ),
			MIX_LOG_PTR( m_DrawState.next.pPixelShader ),
			MIX_LOG_PTR( m_DrawState.next.pVertexBuffer ),
			MIX_LOG_PTR( m_DrawState.next.pIndexBuffer ) );

		return;
	}

	FlushDrawState( 0, 0 );

	m_pD3DDeviceContext->IASetPrimitiveTopology( Device::D3DPrimitiveTopologyTable[primitiveType] );
	m_pD3DDeviceContext->DrawIndexed( numIndex, startIndex, 0 );

	m_DrawPrimitiveCount += ComputePrimitiveCount( primitiveType, numIndex );
}

Boolean Device::SaveScreenshot( const wchar_t* pFileName )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) < 4 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s]", FAILED_SAVESCREENSHOT, Mix::STR_ILLEGALARG, ( pFileName != NULL )? pFileName : L"NULL" );
		return False;
	}

	wchar_t fileExt[5];
	HRESULT ret;
	D3DX11_IMAGE_FILE_FORMAT format;
	D3DX11SaveTextureToFileWFunc D3DX11SaveTextureToFileW;

	D3DX11SaveTextureToFileW = static_cast<D3DX11SaveTextureToFileWFunc>( m_D3DX11Module.GetFunction( L"D3DX11SaveTextureToFileWFunc" ) );

	::wcscpy_s( fileExt, 5, &( pFileName[( ::wcslen( pFileName ) - 4 )] ) );
	::_wcsupr_s( fileExt, 5 );

	if( ::wcscmp( fileExt, L".BMP" ) == 0 )
	{
		format = D3DX11_IFF_BMP;
	}
	else if( ::wcscmp( fileExt, L".JPG" ) == 0 )
	{
		format = D3DX11_IFF_JPG;
	}
	else if( ::wcscmp( fileExt, L".PNG" ) == 0 )
	{
		format = D3DX11_IFF_PNG;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : T|[gĂȂtH[}bg( BMP JPG PNG ) : File[%s]", FAILED_SAVESCREENSHOT, pFileName );
		return False;
	}

	ret = D3DX11SaveTextureToFileW( m_pD3DDeviceContext, m_pBackBuffer, format, pFileName  );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : D3DX11SaveTextureToFileW %s : File[%s] Result[%s]", FAILED_SAVESCREENSHOT, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	MIX_LOG_INFO( L"XN[Vbgۑ : File[%s]", pFileName );

	return True;
}

Boolean Device::SaveTexture( Mix::Graphics::ITexture* pTexture, const wchar_t* pFileName )
{
	if( ( pTexture == NULL ) ||
		( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pTexture[%s], pFileName[%s]",
			FAILED_SAVETEXTURE,
			Mix::STR_ILLEGALARG,
			( pTexture != NULL )? L"" : L"~",
			( pFileName != NULL )? pFileName : L"NULL"
			);

		return False;
	}

	wchar_t fileExt[5];
	HRESULT ret;
	D3DX11_IMAGE_FILE_FORMAT format;
	D3DX11SaveTextureToFileWFunc D3DX11SaveTextureToFileW;

	D3DX11SaveTextureToFileW = static_cast<D3DX11SaveTextureToFileWFunc>( m_D3DX11Module.GetFunction( L"D3DX11SaveTextureToFileWFunc" ) );

	::wcscpy_s( fileExt, 5, &( pFileName[( ::wcslen( pFileName ) - 4 )] ) );
	::_wcsupr_s( fileExt, 5 );

	if( ::wcscmp( fileExt, L".BMP" ) == 0 )
	{
		format = D3DX11_IFF_BMP;
	}
	else if( ::wcscmp( fileExt, L".JPG" ) == 0 )
	{
		format = D3DX11_IFF_JPG;
	}
	else if( ::wcscmp( fileExt, L".PNG" ) == 0 )
	{
		format = D3DX11_IFF_PNG;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : T|[gĂȂtH[}bg( BMP JPG PNG ) : File[%s]", FAILED_SAVETEXTURE, pFileName );
		return False;
	}

	ret = D3DX11SaveTextureToFile( m_pD3DDeviceContext, static_cast<Mix::Graphics::DX11::Texture*>( pTexture )->GetInterface(), format, pFileName  );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : D3DX11SaveTextureToFile %s : File[%s] Result[%s]", FAILED_SAVETEXTURE, Mix::STR_RETERROR, pFileName, GetD3DResultText( ret ) );
		return False;
	}

	MIX_LOG_INFO( L"eNX`ۑ : File[%s]", pFileName );

	return True;
}

const Mix::Point& Device::GetScreenSize( void ) const
{
	return m_ScreenSize;
}

UInt32 Device::GetDrawPrimitiveCount( void ) const
{
	return m_DrawPrimitiveCount;
}

Mix::Graphics::SHADER_MODEL Device::GetShaderModel( void ) const
{
	return m_ShaderModel;
}

HRESULT Device::CreateBackBuffer( const wchar_t* failedMsg )
{
	HRESULT ret;
	const Float32 clearColor[4] = {	0.0f, 0.0f, 0.0f, 0.0f, };
	ID3D11RenderTargetView* viewTable[1];
	D3D11_TEXTURE2D_DESC desc;

	//Xbv`F[obNobt@擾
	ret = m_pDXGISwapChain->GetBuffer( 0, __uuidof(ID3D11Texture2D), reinterpret_cast<void**>( &m_pBackBuffer ) );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGISwapChain::GetBuffer %s : Result[%s]", failedMsg, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return ret;
	}

	//obNobt@r[쐬
	ret = m_pD3DDevice->CreateRenderTargetView( m_pBackBuffer, NULL, &m_pBackBufferView );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : ID3D11Device::CreateRenderTargetView %s : Result[%s]", failedMsg, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return ret;
	}

	//obNobt@NA
	m_pD3DDeviceContext->ClearRenderTargetView( m_pBackBufferView, clearColor );

	//obNobt@ݒ
	viewTable[0] = m_pBackBufferView;
	m_pD3DDeviceContext->OMSetRenderTargets( 1, viewTable, NULL );

	//XN[TCYXV
	m_pBackBuffer->GetDesc( &desc );
	m_ScreenSize.x= desc.Width;
	m_ScreenSize.y = desc.Height;

	return S_OK;
}

//obNobt@̃TCYύX
Boolean Device::ResizeBackBuffer( void )
{
	HRESULT ret;

	//obNobt@
	MIX_RELEASE( m_pBackBufferView );
	MIX_RELEASE( m_pBackBuffer );

	//obNobt@TCY
	ret = m_pDXGISwapChain->ResizeBuffers(
		1,
		m_SwapChainDesc.BufferDesc.Width,
		m_SwapChainDesc.BufferDesc.Height,
		m_SwapChainDesc.BufferDesc.Format,
		m_SwapChainDesc.Flags );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IDXGISwapChain::ResizeBuffers %s : Result[%s]", FAILED_RESIZEBACKBUFFER, Mix::STR_RETERROR, GetD3DResultText( ret ) );
		return False;
	}

	//obNobt@쐬
	if( CreateBackBuffer( FAILED_RESIZEBACKBUFFER ) != S_OK )
	{
		return False;
	}

	return True;
}

void Device::ResetTargetState( void )
{
	ID3D11ShaderResourceView* srvTable[Mix::Graphics::TARGET_MAX] = { NULL, NULL, NULL, NULL };
	ID3D11RenderTargetView* rtvTable[Mix::Graphics::TARGET_MAX] = { m_pBackBufferView, NULL, NULL, NULL };

	m_TargetState.rect = Mix::Rectangle( 0, 0, m_ScreenSize.x, m_ScreenSize.y );

	MIX_RELEASE( m_TargetState.pT0 );
	MIX_RELEASE( m_TargetState.pT1 );
	MIX_RELEASE( m_TargetState.pT2 );
	MIX_RELEASE( m_TargetState.pT3 );
	MIX_RELEASE( m_TargetState.pDS );

	m_pD3DDeviceContext->PSSetShaderResources( 0, Mix::Graphics::TARGET_MAX, srvTable );
	m_pD3DDeviceContext->OMSetRenderTargets( Mix::Graphics::TARGET_MAX, rtvTable, NULL );
}

void Device::ResetDrawState( void )
{
	UInt32 i;

	for( i = 0; i < D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT; i++ )
	{
		m_DrawState.hscTable[i] = NULL;
		m_DrawState.dscTable[i] = NULL;
		m_DrawState.gscTable[i] = NULL;
		m_DrawState.vscTable[i] = NULL;
		m_DrawState.pscTable[i] = NULL;
	}

	for( i = 0; i < Mix::Graphics::TEXTURESTAGE_MAX; i++ )
	{
		m_DrawState.samplerTable[i] = NULL;
		m_DrawState.textureTable[i] = NULL;
	}

	m_DrawState.current.pVertexLayout = NULL;
	m_DrawState.current.pHullShader = NULL;
	m_DrawState.current.pDomainShader = NULL;
	m_DrawState.current.pGeometryShader = NULL;
	m_DrawState.current.pVertexShader = NULL;
	m_DrawState.current.pPixelShader = NULL;
	m_DrawState.current.pVertexBuffer = NULL;
	m_DrawState.current.pIndexBuffer = NULL;
	m_DrawState.next.pVertexLayout = NULL;
	m_DrawState.next.pHullShader = NULL;
	m_DrawState.next.pDomainShader = NULL;
	m_DrawState.next.pGeometryShader = NULL;
	m_DrawState.next.pVertexShader = NULL;
	m_DrawState.next.pPixelShader = NULL;
	m_DrawState.next.pVertexBuffer = NULL;
	m_DrawState.next.pIndexBuffer = NULL;
}

void Device::FlushDrawState( UInt32 startVertex, UInt32 startIndex )
{
	//o[ebNXCAEg
	if( m_DrawState.current.pVertexLayout != m_DrawState.next.pVertexLayout )
	{
		m_pD3DDeviceContext->IASetInputLayout( static_cast<Mix::Graphics::DX11::VertexLayout*>( m_DrawState.next.pVertexLayout )->GetInterface() );
		m_DrawState.current.pVertexLayout = m_DrawState.next.pVertexLayout;
	}

	//nVF[_[
	if( m_DrawState.current.pHullShader != m_DrawState.next.pHullShader )
	{
		if( m_DrawState.next.pHullShader != NULL )
		{
			m_pD3DDeviceContext->HSSetShader( static_cast<Mix::Graphics::DX11::HullShader*>( m_DrawState.next.pHullShader )->GetInterface(), NULL, 0 );
		}
		else
		{
			m_pD3DDeviceContext->HSSetShader( NULL, NULL, 0 );
		}

		m_DrawState.current.pHullShader = m_DrawState.next.pHullShader;
	}

	//hCVF[_[
	if( m_DrawState.current.pDomainShader != m_DrawState.next.pDomainShader )
	{
		if( m_DrawState.next.pDomainShader != NULL )
		{
			m_pD3DDeviceContext->DSSetShader( static_cast<Mix::Graphics::DX11::DomainShader*>( m_DrawState.next.pDomainShader )->GetInterface(), NULL, 0 );
		}
		else
		{
			m_pD3DDeviceContext->DSSetShader( NULL, NULL, 0 );
		}

		m_DrawState.current.pDomainShader = m_DrawState.next.pDomainShader;
	}

	//WIgVF[_[
	if( m_DrawState.current.pGeometryShader != m_DrawState.next.pGeometryShader )
	{
		if( m_DrawState.next.pGeometryShader != NULL )
		{
			m_pD3DDeviceContext->GSSetShader( static_cast<Mix::Graphics::DX11::GeometryShader*>( m_DrawState.next.pGeometryShader )->GetInterface(), NULL, 0 );
		}
		else
		{
			m_pD3DDeviceContext->GSSetShader( NULL, NULL, 0 );
		}

		m_DrawState.current.pGeometryShader = m_DrawState.next.pGeometryShader;
	}

	//o[ebNXVF[_[
	if( m_DrawState.current.pVertexShader != m_DrawState.next.pVertexShader )
	{
		m_pD3DDeviceContext->VSSetShader( static_cast<Mix::Graphics::DX11::VertexShader*>( m_DrawState.next.pVertexShader )->GetInterface(), NULL, 0 );
		m_DrawState.current.pVertexShader = m_DrawState.next.pVertexShader;
	}

	//sNZVF[_[
	if( m_DrawState.current.pPixelShader != m_DrawState.next.pPixelShader )
	{
		m_pD3DDeviceContext->PSSetShader( static_cast<Mix::Graphics::DX11::PixelShader*>( m_DrawState.next.pPixelShader )->GetInterface(), NULL, 0 );
		m_DrawState.current.pPixelShader = m_DrawState.next.pPixelShader;
	}

	//o[ebNXobt@
	if( m_DrawState.current.pVertexBuffer != m_DrawState.next.pVertexBuffer )
	{
		ID3D11Buffer* bufferTable[1] = { static_cast<Mix::Graphics::DX11::VertexBuffer*>( m_DrawState.next.pVertexBuffer )->GetInsterface() };
		UInt32 strideTable[1] = { m_DrawState.next.pVertexBuffer->GetStride() };
		UInt32 offsetTable[1] = { 0 };

		m_pD3DDeviceContext->IASetVertexBuffers( 0,	1, bufferTable, strideTable, offsetTable );
		m_DrawState.current.pVertexBuffer = m_DrawState.next.pVertexBuffer;
	}

	//CfbNXobt@
	if( (  m_DrawState.next.pIndexBuffer != NULL ) &&
		( m_DrawState.current.pIndexBuffer != m_DrawState.next.pIndexBuffer ) )
	{
		Mix::Graphics::DX11::IndexBuffer* pIndexBuffer = static_cast<Mix::Graphics::DX11::IndexBuffer*>( m_DrawState.next.pIndexBuffer );
		Mix::Graphics::INDEX_TYPE indexType = pIndexBuffer->GetType();

		m_pD3DDeviceContext->IASetIndexBuffer(	pIndexBuffer->GetInterface(),
												Device::D3DIndexFormatTable[indexType],
												0 );//( startIndex * Device::D3DIndexStrideTable[indexType] ) );

		m_DrawState.current.pIndexBuffer = m_DrawState.next.pIndexBuffer;
	}
}

Boolean Device::CreateDeviceObject( const void* pBuff, UInt32 buffSize, D3D11_TEXTURE2D_DESC& desc, ID3D11Texture2D** ppD3DTexture, ID3D11ShaderResourceView** ppD3DView )
{
	D3DX11_IMAGE_INFO info;
	D3DX11_IMAGE_LOAD_INFO loadInfo;
	ID3D11Texture2D* pD3DTexture;
	ID3D11ShaderResourceView* pD3DView;
	D3DX11GetImageInfoFromMemoryFunc D3DX11GetImageInfoFromMemory;
	D3DX11CreateTextureFromMemoryFunc D3DX11CreateTextureFromMemory;

	D3DX11GetImageInfoFromMemory = static_cast<D3DX11GetImageInfoFromMemoryFunc>( m_D3DX11Module.GetFunction( L"D3DX11GetImageInfoFromMemory" ) );
	D3DX11CreateTextureFromMemory = static_cast<D3DX11CreateTextureFromMemoryFunc>( m_D3DX11Module.GetFunction( L"D3DX11CreateTextureFromMemory" ) );

	if( D3DX11GetImageInfoFromMemory( pBuff, buffSize, NULL, &info, NULL ) != S_OK )
	{
		return False;
	}

	loadInfo.Width = info.Width;
	loadInfo.Height = info.Height;
	loadInfo.Depth = info.Depth;
	loadInfo.FirstMipLevel = D3DX11_DEFAULT;
	loadInfo.MipLevels = info.MipLevels;
	loadInfo.Usage = D3D11_USAGE_DEFAULT;
	loadInfo.BindFlags = D3D11_BIND_SHADER_RESOURCE;
	loadInfo.CpuAccessFlags = 0;
	loadInfo.MiscFlags = info.MiscFlags;
	loadInfo.Format = DXGI_FORMAT_FROM_FILE;
	loadInfo.Filter = D3DX11_DEFAULT;
	loadInfo.MipFilter = D3DX11_DEFAULT;
	loadInfo.pSrcInfo = NULL;

	if( D3DX11CreateTextureFromMemory( m_pD3DDevice, pBuff, buffSize, &loadInfo, NULL, reinterpret_cast<ID3D11Resource**>( &pD3DTexture ), NULL ) != S_OK )
	{
		return False;
	}

	if( m_pD3DDevice->CreateShaderResourceView( pD3DTexture, NULL, &pD3DView ) != S_OK )
	{
		MIX_RELEASE( pD3DTexture );
		return False;
	}

	pD3DTexture->GetDesc( &desc );

	( *ppD3DTexture ) = pD3DTexture;
	( *ppD3DView ) = pD3DView;

	return True;
}

UInt32 Device::ComputePrimitiveCount( Mix::Graphics::PRIMITIVE_TYPE type, UInt32 num )
{
	UInt32 count = 0;

	switch( type )
	{
	case PRIMITIVE_POINTLIST:
		count = num;
		break;
	case PRIMITIVE_LINELIST:
		count = ( num >> 1 );
		break;
	case PRIMITIVE_LINESTRIP:
		if( num >= 2 )
		{
			count = ( num - 1 );
		}
		break;
	case PRIMITIVE_TRIANGLELIST:
		count = ( num / 3 );
		break;
	case PRIMITIVE_TRIANGLESTRIP:
		if( num >= 3 )
		{
			count = ( num - 2 );
		}
		break;
	}

	return count;
}

}}}
