#pragma once

#include <map>
#include "Mix/Graphics/IManager.h"

namespace Mix{

	class UserFile;
	class IWindow;

	namespace File{
		class IManager;
	}

	namespace Graphics{
		namespace Common{
			class Device;
		}
	}
}

namespace Mix{ namespace Graphics{ namespace Common{

	class Manager : public Mix::Graphics::IManager
	{
	protected:
		static const wchar_t* FAILED_INITIALIZE;
		static const wchar_t* SUCCESS_INITIALIZE;
		static const wchar_t* FAILED_CREATETARGETTEXTURECHAIN;
		static const wchar_t* FAILED_CREATEFONT;
		static const wchar_t* FAILED_CREATETEXT;
		static const wchar_t* FAILED_CREATELINEART;
		static const wchar_t* FAILED_CREATECANVAS;

	protected:
		//VF[_[^Cv񋓒萔
		enum SHADER_TYPES
		{
			SHADER_CANVAS_VS					= 0,	// VS : LoX
			SHADER_CANVAS_COLOR_PS				= 1,	// PS : LoX : eNX`
			SHADER_CANVAS_COLOR_AND_TEXTURE_PS	= 2,	// PS : LoX : eNX`L

			SHADER_LINE_VS						= 3,	// VS : C
			SHADER_LINE_PS						= 4,	// VS : C
		};

		//VF[_[oCi\
		struct SHADER_BINARY
		{
			enum VALUE{ NAME_SIZE = 64, };

			wchar_t name[SHADER_BINARY::NAME_SIZE];
			const void* pData;
			UInt32 dataSize;
		};

	public:
		//풓GtFNgIvV񋓒萔
		enum EFFECT_RESIDENT_OPT
		{
			ER_CANVAS				= 13,
			ER_LINE					= 14,
		};

		//o[ebNXGtFNgVF[_[\
		enum VERTEX_EFFECT_SHADER
		{
			VES_DEFAULT			= 0,
			VES_MAX				= 1,
		};

		//sNZGtFNgVF[_[\
		enum PIXEL_EFFECT_SHADER
		{
			PES_DEFAULT					= 0,

			PES_CANVAS_COLOR			= 0,
			PES_CANVAS_COLOR_TEX		= 1,

			PES_MAX						= 2,
		};

		//o[ebNXGtFNg\
		struct VERTEX_EFFECT
		{
			Mix::Graphics::IVertexLayout* pLayout;
			Mix::Graphics::IVertexShader* pShader[Manager::VES_MAX];

			VERTEX_EFFECT( void );
			void Dispose( void );
		};

		//sNZGtFNg\
		struct PIXEL_EFFECT
		{
			Mix::Graphics::IPixelShader* pShader[Manager::PES_MAX];

			PIXEL_EFFECT( void );
			void Dispose( void );
		};

	private:

		typedef std::map<UInt32, Manager::VERTEX_EFFECT> VertexEffectMap;
		typedef std::map<UInt32, Manager::PIXEL_EFFECT> PixelEffectMap;

	protected:
		Mix::File::IManager* m_pFileMgr;

	private:
		Manager::VertexEffectMap m_ResidentVEMap;
		Manager::PixelEffectMap m_ResidentPEMap;

	protected:
		Manager( void );
		virtual ~Manager( void );

		virtual Boolean OnInitialize( const Mix::GRAPHICS_CONFIG& cfg, Mix::UserFile* pSysReport ) = 0;
		virtual void OnDispose( void ) = 0;

		virtual Mix::Graphics::Common::Device* GetDevicePtr( void ) = 0;
		virtual void GetShaderBinary( Manager::SHADER_TYPES type, Manager::SHADER_BINARY& out ) = 0;

	public:
		Boolean Initialize( const Mix::GRAPHICS_CONFIG& cfg, Mix::UserFile* pSysReport );
		void Dispose( void );

		Boolean Update( void );

		void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

		Manager::VERTEX_EFFECT* GetVertexEffectPtr( UInt32 opt = 0 );
		Manager::PIXEL_EFFECT* GetPixelEffectPtr( UInt32 opt = 0 );

	public:
		virtual Boolean GetDevice( Mix::Graphics::IDevice** ppDevice );

		virtual Boolean CreateTargetTextureChain(	UInt32 width,
													UInt32 height,
													Mix::Graphics::FORMAT format,
													Mix::Graphics::Utility::ITargetTextureChain** ppTargetTextureChain,
													const wchar_t* pName );

		virtual Boolean CreateFontFromFile( const wchar_t* pFileName, Mix::Graphics::Utility::IFont** ppFont );
		virtual Boolean CreateFontFromMemory( Mix::Memory::IBuffer* pBuffer, Mix::Graphics::Utility::IFont** ppFont, const wchar_t* pName );

		virtual Boolean CreateText( Mix::Graphics::Utility::IText** ppText );

		virtual Boolean CreateLineArt( Mix::Graphics::Utility::ILineArt** ppLineArt, const wchar_t* pName );

		virtual Boolean CreateCanvas( Mix::Graphics::Utility::ICanvas** ppCanvas, const wchar_t* pName );
	};

}}}
