#pragma once

namespace Mix{ namespace Graphics{ namespace Common{

	enum DEVICEOBJECTTYPE
	{
		DOT_VERTEXLAYOUT	= 0,
		DOT_COMPUTESHADER	= 1,
		DOT_HULLSHADER		= 2,
		DOT_DOMAINSHADER	= 3,
		DOT_GEOMETRYSHADER	= 4,
		DOT_VERTEXSHADER	= 5,
		DOT_PIXELSHADER		= 6,
		DOT_SHADERCONSTANT	= 7,
		DOT_VERTEXBUFFER	= 8,
		DOT_INDEXBUFFER		= 9,
		DOT_TEXTURE_2D		= 10,
		DOT_TEXTURE_CUBE	= 11,
		DOT_TEXTURE_TARGET	= 12,
		DOT_TEXTURE_DS		= 13,
		DOT_QUERY			= 14,
	};

	class Device;

	class DeviceObject
	{
	private:
		Mix::Graphics::Common::Device* m_pDevice;
		Mix::Graphics::Common::DEVICEOBJECTTYPE m_Type;
		Mix::String m_Name;
		Boolean m_bRegisterMap;

	protected:
		DeviceObject( Mix::Graphics::Common::Device* pDevice, Mix::Graphics::Common::DEVICEOBJECTTYPE type, Boolean bRegisterMap, const wchar_t* pName );
		virtual ~DeviceObject( void );

	public:
		virtual void Invalidate( void ){}
		virtual void Validate( void ){}

	public:
		Mix::Graphics::Common::DEVICEOBJECTTYPE GetType( void ) const;
		const wchar_t* GetName( void ) const;
		Boolean IsRegisterMap( void ) const;
	};

}}}
