#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Class/Graphics/Common/Device.h"

namespace Mix{ namespace Graphics{ namespace Common{

DeviceObject::DeviceObject( Mix::Graphics::Common::Device* pDevice, Mix::Graphics::Common::DEVICEOBJECTTYPE type, Boolean bRegisterMap, const wchar_t* pName ) :
m_pDevice( pDevice ),
m_Type( type ),
m_Name( ( pName != NULL )? pName : L"UNKNOWN" ),
m_bRegisterMap( bRegisterMap )
{
	MIX_ADD_REF( m_pDevice );
	m_pDevice->AppendDeviceObject( this );
}

DeviceObject::~DeviceObject( void )
{
	if( m_pDevice != NULL )
	{
		m_pDevice->RemoveDeviceObject( this );
	}

	MIX_RELEASE( m_pDevice );
}

Mix::Graphics::Common::DEVICEOBJECTTYPE DeviceObject::GetType( void ) const
{
	return m_Type;
}

const wchar_t* DeviceObject::GetName( void ) const
{
	return m_Name.GetConstPtr();
}

Boolean DeviceObject::IsRegisterMap( void ) const
{
	return m_bRegisterMap;
}

}}}
