#pragma once

#include <map>
#include <list>

#include "Mix/File/IManager.h"
#include "Mix/Graphics/IDevice.h"

#include "Mix/Class/Window.h"
#include "Mix/Class/Graphics/Common/DeviceObject.h"

namespace Mix{ namespace Graphics{ namespace Common{

	class Device : public Mix::Graphics::IDevice
	{
	protected:
		static const wchar_t* FORMAT_TEXT_TABLE[Mix::Graphics::FMT_MAX];
		static UInt32 VERTEX_ELEMENT_SIZE_TABLE[Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX];

	private:
		typedef std::map<Mix::String, Mix::Graphics::Common::DeviceObject*> DeviceObjectMap;
		typedef std::list<Mix::Graphics::Common::DeviceObject*> DeviceObjectList;

	private:
		DeviceObjectMap m_Map;
		DeviceObjectList m_List;
		DeviceObjectList m_SafeList;

	protected:
		Mix::Window* m_pWindow;
		Mix::File::IManager* m_pFileMgr;
		Boolean m_bWaitVSync;

	protected:
		Device( Boolean bWaitVSync );
		virtual ~Device( void );

		UInt32 GetTextureDimension( const void* pSrc, UInt32 srcSize );

	protected:
		virtual Boolean CompileShader(	const void* pSrc, UInt32 srcSize,
										Mix::Graphics::SHADER_MACRO* pMacros,
										const char* pFuncName,
										Mix::Graphics::SHADER_TARGET target,
										Mix::Memory::IBuffer** ppBuffer ) = 0;

		virtual void OnDispose( void );

	public:
		virtual Boolean Initialize( Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Mix::UserFile* pSysReport );
		virtual Boolean Update( void );
		virtual Boolean MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

		virtual Boolean CompileShaderFromFile(	const wchar_t* pFilePath,
												Mix::Graphics::SHADER_MACRO* pMacros,
												const char* pFuncName,
												Mix::Graphics::SHADER_TARGET target,
												Mix::Memory::IBuffer** ppBuffer );

		virtual Boolean CompileShaderFromMemory(	const wchar_t* pName,
													const void* pSrc, UInt32 srcSize,
													Mix::Graphics::SHADER_MACRO* pMacros,
													const char* pFuncName,
													Mix::Graphics::SHADER_TARGET target,
													Mix::Memory::IBuffer** ppBuffer );

	public:
		void Dispose( void );

		void AppendDeviceObject( Mix::Graphics::Common::DeviceObject* pDeviceObject );
		void RemoveDeviceObject( Mix::Graphics::Common::DeviceObject* pDeviceObject );
		Mix::Graphics::Common::DeviceObject* FindDeviceObject( const wchar_t* pName );
		void InvalidateDeviceObject( void );
		void ValidateDeviceObject( void );

		const wchar_t* GetFormatText( Mix::Graphics::FORMAT format ) const;

	protected:
		static const wchar_t* FAILED_COMPILESHADER;
	};

}}}
