#include "Mix/Graphics.h"
#include "Mix/Graphics/Utility/IFont.h"

namespace Mix{ namespace Graphics{ namespace Utility{

_MIX_DLL_API Mix::Point MeasureString( Mix::Graphics::Utility::IFont* pFont, const wchar_t* str )
{
	if( ( pFont == NULL ) ||
		( str == NULL ) ||
		( ::wcslen( str ) == 0 ) )
	{
		return Mix::Point( 0, 0 );
	}

	Int32 fontHeightI = static_cast<Int32>( pFont->GetHeight() );
	Int32 fontHalfHeightI = fontHeightI >> 1;
	Int32 tabI = fontHalfHeightI * Mix::Graphics::Utility::STR_TAB_COUNT;

	Int32 line = 0;
	Mix::Point pos( 0, 0 );
	Mix::Point size( 0, 0 );

	//쐬
	for( UInt32 i = 0; str[i] != L'\0'; i++ )
	{
		wchar_t code = str[i];
		Mix::Graphics::Utility::IFont::GLYPH glyph;

		if( code == L' ' )
		{
			pos.x += fontHalfHeightI;
			pos.y = line + fontHalfHeightI;
		}
		else if( code == L'@' )
		{
			pos.x += fontHeightI;
			pos.y = line + fontHeightI;
		}
		else if( code == L'\t' )
		{
			pos.x += tabI;
			pos.y = line + fontHeightI;
		}
		else if( code == L'\r' )
		{
			;
		}
		else if( code == L'\n' )
		{
			pos.x = 0;
			pos.y = 0;

			line += fontHeightI;
		}
		else if( pFont->GetGlyph( code, glyph ) == True )
		{
			pos.x += glyph.cellWidth;
			pos.y = line + glyph.cellHeight;
		}

		if( size.x < pos.x ) { size.x = pos.x; }
		if( size.y < pos.y ) { size.y = pos.y; }
	}

	return size;
}

}}}
