#pragma once

#include <map>
#include <list>

#include "Mix/File/IManager.h"
#include "Mix/CriticalSection.h"
#include "Mix/Semaphore.h"
#include "Mix/Thread.h"

namespace Mix{ namespace File{

	class Controller;
	class Archive;
	class Loader;

	class Manager : public Mix::File::IManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZE;
		static const wchar_t* FAILED_MOUNTARCHIVE;
		static const wchar_t* FAILED_MOUNTDIRECTORY;
		static const wchar_t* FAILED_MOUNTFILE;
		static const wchar_t* FAILED_GETABSPATH;
		static const wchar_t* FAILED_EXISTFILE;
		static const wchar_t* FAILED_CREATEFILEREADER;
		static const wchar_t* FAILED_CREATEFILEWRITER;
		static const wchar_t* FAILED_CREATEBUFFEREDREADER;
		static const wchar_t* FAILED_CREATEFILELOADER;
		static const wchar_t* FAILED_CREATEFILEBUFFER;

		//CSIDLe[u( tH_擾p )
		static const Int32 CSIDLTable[Mix::File::DIRECTORY_IDENT_MAX];

	private:
		//el
		enum VALUE
		{
			ARCHIVE_MAGICNUMBER = 0x5F46414D,
			ARCHIVE_VERSION = 0x01000000,

			TYPE_LOAD = 0,
			TYPE_EXIT = 1,

			MAX_LOADQUEUE = 1024,
		};

		//A[JCuwb_\
		struct ARCHIVE_HEADER
		{
			UInt32 magicNumber;
			UInt32 version;
			UInt32 alignment;
			UInt32 fileCount;
			UInt32 stringSize;
			UInt32 reserve;
			UInt64 fileStart;
			UInt64 stringStart;
		};

		//A[JCut@C\
		struct ARCHIVE_FILE
		{
			UInt32 namePos;
			UInt32 dataPos;
			UInt32 dataSize;
			UInt32 reserve;
		};

		//t@C}bv
		typedef std::map<Mix::StringW, Mix::File::Controller*> FileMap;

		//Xbhf[^\
		struct THREADDATA
		{
			UInt32 type;
			Mix::String fileName;
			Mix::Reference* pObject;
			Mix::Memory::IBuffer* pBuffer;
			Mix::File::Loader* pLoader;
		};

		//Xbhf[^Xg
		typedef std::list<THREADDATA> ThreadDataList;

		//ǂݍ݃L[\
		struct LOADQUEUE
		{
			Boolean bAvaliable;

			Mix::Semaphore semaEmpty;
			Mix::Semaphore semaCount;
			Mix::CriticalSection syncList;
			ThreadDataList list;

			LOADQUEUE( void ) :
			bAvaliable( True ),
			semaEmpty( MAX_LOADQUEUE, MAX_LOADQUEUE ),
			semaCount( 0, MAX_LOADQUEUE )
			{
			}
		};

		//L[\
		struct COMPQUEUE
		{
			Mix::CriticalSection sync;
			ThreadDataList list;
		};

	public:
		static Manager* CreateInstance( void );

	private:
		Mix::CriticalSection m_MySync;
		Mix::StringW m_UserDirectoryName;
		Mix::StringW m_RootDirectoryName;

		FileMap m_FileMap;

		Mix::Thread m_Thread;
		LOADQUEUE m_LoadQueue;
		COMPQUEUE m_CompQueue;

	private:
		Manager( void );
		virtual ~Manager( void );

		void ThreadMain( void );
		static void __cdecl ThreadEntry( void* pArg );

	private:
		Boolean CreateDirectory( const wchar_t* pFailedMsg, const wchar_t* pDirectoryName );
		Boolean GetFileReader( const wchar_t* pFailedMsg, const wchar_t* pFileName, Mix::File::IReader** ppReader );
		
		Mix::File::Controller* FindFile( const wchar_t* pFailedMsg, const wchar_t* pFileName, Boolean bCreateAlways );
		Mix::File::Controller* InsertFile( const wchar_t* pFailedMsg, const wchar_t* pFileName );

		Boolean IsAbsolutePath( const wchar_t* pSrc );
		Boolean ModifyPath( const wchar_t* pSrc, Boolean bDirectory, Boolean bLower, Mix::StringW& dst );
		void ModifyDelimiter( Boolean bDirectory, Mix::StringW& path );

	public:
		Boolean Initialize( const Mix::FILE_CONFIG& cfg );
		void Dispose( void );
		void Update( void );
		Boolean PushLoad( const wchar_t* pFileName, Mix::File::Loader* pLoader, Mix::Reference* pObject );

	public:
		virtual Boolean MountArchive( const wchar_t* pFileName );
		virtual Boolean MountDirectory( const wchar_t* pDirectoryName );
		virtual Boolean MountFile( const wchar_t* pFileName );

		virtual Boolean GetAbsolutePath( const wchar_t* pSrc, Boolean bDirectory, Mix::StringW& dst );
		virtual Boolean GetSpecialDirectoryName( Mix::File::DIRECTORY_IDENT ident, Mix::String& directoryName );

		virtual Boolean ExistFile( const wchar_t* pFileName );

		virtual Boolean CreateFileReader( const wchar_t* pFileName, Mix::File::IReader** ppReader );
		virtual Boolean CreateFileWriter( const wchar_t* pFileName, Mix::File::IWriter** ppWriter );

		virtual Boolean CreateBufferedReader( const wchar_t* pFileName, Mix::File::IReader** ppReader );
		virtual Boolean CreateBufferedReader( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::File::IReader** ppReader );

		virtual Boolean CreateFileLoader( Mix::File::ILoaderCallback* pCallback, Mix::File::ILoader** ppLoader, const wchar_t* pName );

		virtual Boolean CreateBufferFromFile( const wchar_t* pFileName, Mix::Memory::IBuffer** ppBuffer );
	};

}}
