#include "Mix/Class/File/Manager.h"
#include "Mix/Class/File/FileReader.h"
#include "Mix/Class/File/FileWriter.h"
#include "Mix/Class/File/BufferedReader.h"
#include "Mix/Class/File/Loader.h"
#include "Mix/Class/File/Archive.h"
#include "Mix/Class/File/LocalController.h"
#include "Mix/Class/File/ArchiveController.h"
#include "Mix/Class/Memory/Buffer.h"
#include "Mix/ScopedLock.h"

#include <Shlwapi.h>

namespace Mix{ namespace File{

//O̕
const wchar_t* Manager::FAILED_INITIALIZE            = L"t@C}l[W̏Ɏs";
const wchar_t* Manager::FAILED_MOUNTARCHIVE          = L"A[JCũ}EgɎs";
const wchar_t* Manager::FAILED_MOUNTDIRECTORY        = L"fBNg̃}EgɎs";
const wchar_t* Manager::FAILED_MOUNTFILE             = L"t@C̃}EgɎs";
const wchar_t* Manager::FAILED_GETABSPATH            = L"΃pX̎擾Ɏs";
const wchar_t* Manager::FAILED_EXISTFILE             = L"t@C̗L̊mFɎs";
const wchar_t* Manager::FAILED_CREATEFILEREADER      = L"t@C[_[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEFILEWRITER      = L"t@CC^[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEBUFFEREDREADER  = L"obt@h[_[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEFILELOADER      = L"t@C[_[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEFILEBUFFER      = L"t@Cobt@̍쐬Ɏs";

//CSIDLe[u( tH_擾p )
const Int32 Manager::CSIDLTable[Mix::File::DIRECTORY_IDENT_MAX] =
{
	0x0000,			//_~[( [g )
	0x0000,			//_~[( [U[ )
	CSIDL_APPDATA,	//AvP[Vf[^
	CSIDL_DESKTOP,	//fXNgbv
	CSIDL_PERSONAL	//}ChLg
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Manager* Manager::CreateInstance( void )
{
	return new Manager();
}

Manager::Manager( void )
{
}

Manager::~Manager( void )
{
	Mix::ScopedLock lock( m_MySync );

	for( FileMap::iterator it = m_FileMap.begin(); it != m_FileMap.end(); ++it )
	{
		MIX_RELEASE( it->second );
	}
}

Boolean Manager::Initialize( const Mix::FILE_CONFIG& cfg )
{
	wchar_t currentPath[MAX_PATH];

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// [U[fBNg擾
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( GetSpecialDirectoryName( Mix::File::DIRECTORY_IDENT_MYDOCUMENT, m_UserDirectoryName ) == False )
	{
		MIX_LOG_ERROR( L"%s : }ChLg̃pX擾ł܂ %s", FAILED_INITIALIZE );
		return False;
	}

	if( cfg.pUserDirectoryName != NULL )
	{
		m_UserDirectoryName += cfg.pUserDirectoryName;
	}
	else
	{
		m_UserDirectoryName += Mix::DEF_USERDIRECTORYNAME;
	}

	m_UserDirectoryName.Lower();
	ModifyDelimiter( True, m_UserDirectoryName );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// [gfBNg擾
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( ::GetCurrentDirectoryW( MAX_PATH, currentPath ) == 0 )
	{
		MIX_LOG_ERROR( L"%s : GetCurrentDirectoryW %s", FAILED_INITIALIZE, Mix::STR_RETERROR );
		return False;
	}

	if( cfg.pRootDirectoryName != NULL )
	{
		if( IsAbsolutePath( cfg.pRootDirectoryName ) == True )
		{
			m_RootDirectoryName = cfg.pRootDirectoryName;
		}
		else
		{
			Mix::StringW temp;
			wchar_t work[MAX_PATH];

			temp = cfg.pRootDirectoryName;
			ModifyDelimiter( True, temp );

			if( ::PathCombineW( work, currentPath, temp.GetConstPtr() ) != NULL )
			{
				m_RootDirectoryName = work;
			}
			else
			{
				MIX_LOG_ERROR( L"%s : PathCombineW %s", FAILED_INITIALIZE, Mix::STR_RETERROR );
				return False;
			}
		}
	}
	else
	{
		m_RootDirectoryName = currentPath;
	}

	m_RootDirectoryName.Lower();
	ModifyDelimiter( True, m_RootDirectoryName );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// [_[pXbh̍쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_Thread.Start( Manager::ThreadEntry, this ) == False )
	{
		MIX_LOG_ERROR( L"%s : XbhJnł܂ł", FAILED_INITIALIZE );
		return False;
	}

	return True;
}

void Manager::Dispose( void )
{
	THREADDATA td;

	//ȏ̃[hL[̒ǉ֎~
	m_LoadQueue.bAvaliable = False;

	//L[ǉĊmɏI悤ɂ
	m_LoadQueue.semaEmpty.Reduce();
	m_LoadQueue.syncList.Enter();
	td.type = Manager::TYPE_EXIT;
	m_LoadQueue.list.push_back( td );
	m_LoadQueue.syncList.Leave();
	m_LoadQueue.semaCount.Increase();

	//Xbh~
	m_Thread.Join();

	//ׂď
	Update();
}

void Manager::Update( void )
{
	THREADDATA* ptd;

	m_CompQueue.sync.Enter();

	for( ThreadDataList::iterator it = m_CompQueue.list.begin(); it != m_CompQueue.list.end(); ++it )
	{
		ptd = &( *it );

		if( ptd->pBuffer != NULL )
		{
			ptd->pLoader->CallLoadComplete( ptd->fileName.GetConstPtr(), ptd->pBuffer, ptd->pObject );
		}
		else
		{
			ptd->pLoader->CallLoadFailed( ptd->fileName.GetConstPtr(), ptd->pObject );
		}

		MIX_RELEASE( ptd->pBuffer );
		MIX_RELEASE( ptd->pLoader );
		MIX_RELEASE( ptd->pObject );
	}

	m_CompQueue.list.clear();

	m_CompQueue.sync.Leave();
}

Boolean Manager::PushLoad( const wchar_t* fileName, Mix::File::Loader* pLoader, Mix::Reference* pObject )
{
	if( m_LoadQueue.bAvaliable == False )
	{
		return False;
	}

	THREADDATA td;

	m_LoadQueue.semaEmpty.Reduce();
	m_LoadQueue.syncList.Enter();

	td.type = Manager::TYPE_LOAD;
	td.fileName = fileName;
	td.pBuffer = NULL;
	td.pLoader = pLoader;
	td.pObject = pObject;

	MIX_ADD_REF( td.pLoader );
	MIX_ADD_REF( td.pObject );

	m_LoadQueue.list.push_back( td );

	m_LoadQueue.syncList.Leave();
	m_LoadQueue.semaCount.Increase();

	return True;
}

Boolean Manager::MountArchive( const wchar_t* pFileName )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s]", FAILED_MOUNTARCHIVE, Mix::STR_ILLEGALARG, ( pFileName != NULL )? pFileName : L"NULL" );
		return False;
	}

	Mix::StringW fileName;
	HANDLE hFile;

	if( ModifyPath( pFileName, False, False, fileName ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@Cł܂ : File[%s]", FAILED_MOUNTARCHIVE, pFileName );
		return False;
	}

	hFile = ::CreateFile( fileName.GetConstPtr(), GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile != INVALID_HANDLE_VALUE )
	{
		DWORD readSize;
		ARCHIVE_HEADER header;

		if( ( ::ReadFile( hFile, &header, sizeof( header ), &readSize, NULL ) == TRUE ) &&
			( sizeof( header ) == readSize ) &&
			( header.magicNumber == ARCHIVE_MAGICNUMBER ) ||
			( header.version == ARCHIVE_VERSION ) )
		{
			Int32 lastIndex;
			Mix::String temp;
			Mix::String path;
			Mix::File::Archive* pArchive = Mix::File::Archive::CreateInstance( fileName.GetConstPtr() );

			temp = fileName;

			lastIndex = temp.LastIndexOf( L'\\' );
			if( lastIndex == -1 )
			{
				lastIndex = temp.LastIndexOf( L'\\' );
			}

			if( lastIndex >= 0 )
			{
				path = temp.Mid( 0, ( lastIndex + 1 ) );
			}
			else
			{
				path = L"";
			}

			if( pArchive != NULL )
			{
				UInt32 fileListByteSize;
				UInt32 stringBufferByteSize;
				std::vector<ARCHIVE_FILE> fileList;
				std::vector<wchar_t> stringBuffer;
				LARGE_INTEGER distance;
				LARGE_INTEGER newPoint;

				fileListByteSize = ( sizeof( ARCHIVE_FILE ) * header.fileCount );
				stringBufferByteSize = ( sizeof( wchar_t ) * header.stringSize );

				fileList.resize( header.fileCount );
				stringBuffer.resize( header.stringSize );

				distance.QuadPart = header.fileStart;
				if( ( ::SetFilePointerEx( hFile, distance, &newPoint, FILE_BEGIN ) == TRUE ) &&
					( ::ReadFile( hFile, &( fileList[0] ), fileListByteSize, &readSize, NULL ) == TRUE ) &&
					( fileListByteSize == readSize ) )
				{
					distance.QuadPart = header.stringStart;
					if( ( ::SetFilePointerEx( hFile, distance, &newPoint, FILE_BEGIN ) == TRUE ) &&
						( ::ReadFile( hFile, &( stringBuffer[0] ), stringBufferByteSize, &readSize, NULL ) == TRUE ) &&
						( stringBufferByteSize == readSize ) )
					{
						for( std::vector<ARCHIVE_FILE>::iterator it = fileList.begin(); it != fileList.end(); ++it )
						{
							Mix::String tempKey;
							Mix::String key;
							Mix::File::ArchiveController* pController;

							tempKey = path;
							tempKey += &( stringBuffer[( *it ).namePos] );

							if( ModifyPath( tempKey.GetConstPtr(), False, True, key ) == False )
							{
								MIX_LOG_ERROR( L"%s : ΃pXɕϊł܂ł : File[%s]", FAILED_MOUNTARCHIVE, tempKey.GetConstPtr() );

								MIX_RELEASE( pArchive );
								::CloseHandle( hFile );

								return False;
							}

							pController = Mix::File::ArchiveController::CreateInstance( key.GetConstPtr(), pArchive, ( sizeof( ARCHIVE_HEADER ) + ( ( *it ).dataPos * header.alignment ) ), ( *it ).dataSize );
							if( pController != NULL )
							{
								FileMap::iterator it_file = m_FileMap.find( key );
								if( it_file != m_FileMap.end() )
								{
									MIX_RELEASE( it_file->second );
									m_FileMap.erase( it_file );
								}

								m_FileMap[key] = pController;
							}
							else
							{
								MIX_LOG_ERROR( L"%s : %s", FAILED_MOUNTARCHIVE, Mix::STR_OUTOFMEMORY );

								MIX_RELEASE( pArchive );
								::CloseHandle( hFile );

								return False;
							}
						}
					}
					else
					{
						MIX_LOG_ERROR( L"%s : sȃA[JCut@C(3) : File[%s]", FAILED_MOUNTARCHIVE, pFileName );

						MIX_RELEASE( pArchive );
						::CloseHandle( hFile );

						return False;
					}
				}
				else
				{
					MIX_LOG_ERROR( L"%s : sȃA[JCut@C(2) : File[%s]", FAILED_MOUNTARCHIVE, pFileName );
					MIX_RELEASE( pArchive );
					::CloseHandle( hFile );
					return False;
				}

				MIX_RELEASE( pArchive );
			}
			else
			{
				MIX_LOG_ERROR( L"%s : %s", FAILED_MOUNTARCHIVE, Mix::STR_OUTOFMEMORY );
				::CloseHandle( hFile );
				return False;
			}
		}
		else
		{
			MIX_LOG_ERROR( L"%s : sȃA[JCut@C(1) : File[%s]", FAILED_MOUNTARCHIVE, pFileName );
			::CloseHandle( hFile );
			return False;
		}

		::CloseHandle( hFile );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]",FAILED_MOUNTARCHIVE, pFileName );
		return False;
	}

	MIX_LOG_INFO( L"A[JCu}Eg : Archive[%s]", pFileName );

	return True;
}

Boolean Manager::MountDirectory( const wchar_t* pDirectoryName )
{
	if( ( pDirectoryName == NULL ) ||
		( ::wcslen( pDirectoryName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pDirectoryName[%s]", FAILED_MOUNTDIRECTORY, Mix::STR_ILLEGALARG, ( pDirectoryName != NULL )? pDirectoryName : L"NULL" );
		return False;
	}

	Boolean bSuccess;
	Mix::StringW directoryName;
	Mix::String searchPath;
	WIN32_FIND_DATAW wfd;
	HANDLE hFind;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	bSuccess = True;

	if( ModifyPath( pDirectoryName, True, False, directoryName ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@Cł܂ : File[%s]", FAILED_MOUNTDIRECTORY, pDirectoryName );
		return False;
	}

	searchPath.Sprintf( L"%s*.*", directoryName.GetConstPtr() );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// fBNg
	////////////////////////////////////////////////////////////////////////////////////////////////////

	hFind = ::FindFirstFileW( searchPath.GetConstPtr(), &wfd );
	if( hFind != INVALID_HANDLE_VALUE )
	{
		do
		{
			if( ( wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) == FILE_ATTRIBUTE_DIRECTORY )
			{
				if( ( ::wcscmp( wfd.cFileName, L"." ) != 0 ) &&
					( ::wcscmp( wfd.cFileName, L".." ) != 0 ) )
				{
					//ɉ̃fBNgֈړ

					Mix::StringW nextDirectoryName;
					nextDirectoryName.Sprintf( L"%s%s", directoryName.GetConstPtr(), wfd.cFileName );
					MountDirectory( nextDirectoryName.GetConstPtr() );
				}
			}
			else
			{
				//[JRg[[ǉ

				Mix::String temp;
				Mix::StringW key;
				Mix::File::LocalController* pController;

				temp.Sprintf( L"%s%s", directoryName.GetConstPtr(), wfd.cFileName );
				ModifyPath( temp.GetConstPtr(), False, True, key );

				pController = Mix::File::LocalController::CreateInstance( key.GetConstPtr() );
				if( pController != NULL )
				{
					FileMap::iterator it_file = m_FileMap.find( key );
					if( it_file != m_FileMap.end() )
					{
						MIX_RELEASE( it_file->second );
						m_FileMap.erase( it_file );
					}

					m_FileMap[key] = pController;
				}
				else
				{
					bSuccess = False;
				}
			}
		}
		while( ( ::FindNextFileW( hFind, &wfd ) == TRUE ) && ( bSuccess == True ) );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : pXs : SearchPath[%s]", FAILED_MOUNTDIRECTORY, searchPath.GetConstPtr() );
		bSuccess = False;
	}

	MIX_LOG_INFO( L"fBNg}Eg : Directory[%s]", pDirectoryName );

	return bSuccess;
}

Boolean Manager::MountFile( const wchar_t* pFileName )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pDirectoryName[%s]", FAILED_MOUNTFILE, Mix::STR_ILLEGALARG, ( pFileName != NULL )? pFileName : L"NULL" );
		return False;
	}

	Mix::StringW fileName;

	if( ModifyPath( pFileName, False, True, fileName ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@Cł܂ : File[%s]", FAILED_MOUNTFILE, pFileName );
		return False;
	}

	HANDLE hFile = ::CreateFileW( fileName.GetConstPtr(), GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile != INVALID_HANDLE_VALUE )
	{
		::CloseHandle( hFile );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", FAILED_MOUNTFILE, pFileName );
		return False;
	}

	Mix::File::LocalController* pController = Mix::File::LocalController::CreateInstance( fileName.GetConstPtr() );
	if( pController != NULL )
	{
		FileMap::iterator it_file = m_FileMap.find( fileName );
		if( it_file != m_FileMap.end() )
		{
			MIX_RELEASE( it_file->second );
			m_FileMap.erase( it_file );
		}

		m_FileMap[fileName] = pController;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_MOUNTFILE, Mix::STR_OUTOFMEMORY );
		return False;
	}

	MIX_LOG_INFO( L"t@C}Eg : File[%s]", pFileName );

	return True;
}

Boolean Manager::GetAbsolutePath( const wchar_t* pSrc, Boolean bDirectory, Mix::StringW& dst )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pSrc == NULL ) ||
		( ::wcslen( pSrc ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pSrc[%s]",
			FAILED_GETABSPATH,
			Mix::STR_ILLEGALARG, 
			( pSrc != NULL )? pSrc : L"NULL" );

		return False;
	}

	if( ModifyPath( pSrc, bDirectory, False, dst ) == False )
	{
		MIX_LOG_ERROR( L"%s : pXł܂ł : Path[%s]", FAILED_GETABSPATH, pSrc );
		return False;
	}

	return True;
}

Boolean Manager::GetSpecialDirectoryName( Mix::File::DIRECTORY_IDENT ident, Mix::String& directoryName )
{
	Boolean ret = True;
	wchar_t temp[MAX_PATH];

	if( ident == Mix::File::DIRECTORY_IDENT_ROOT )
	{
		::wcscpy_s( temp, m_RootDirectoryName.GetConstPtr() );
	}
	else if( ident == Mix::File::DIRECTORY_IDENT_USER )
	{
		::wcscpy_s( temp, m_UserDirectoryName.GetConstPtr() );
	}
	else
	{
		IMalloc* pMalloc;

		if( ::SHGetMalloc( &pMalloc ) == S_OK )
		{
			LPITEMIDLIST pItemIdList;

			if( ::SHGetSpecialFolderLocation( NULL, Manager::CSIDLTable[ident], &pItemIdList ) == S_OK )
			{
				::SHGetPathFromIDList( pItemIdList, temp );
				pMalloc->Free( pItemIdList );
			}
			else
			{
				ret = False;
			}

			pMalloc->Release();
		}
	}

	directoryName = temp;
	directoryName.Lower();
	ModifyDelimiter( True, directoryName );

	return ret;
}

Boolean Manager::ExistFile( const wchar_t* pFileName )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pDirectoryName[%s]", FAILED_EXISTFILE, Mix::STR_ILLEGALARG, ( pFileName != NULL )? pFileName : L"NULL" );
		return False;
	}

	Mix::StringW fileName;

	if( ModifyPath( pFileName, False, True, fileName ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@Cł܂ : File[%s]", FAILED_EXISTFILE, pFileName );
		return False;
	}

	if( m_FileMap.find( fileName.GetConstPtr() ) == m_FileMap.end() )
	{
		return False;
	}

	return True;
}

Boolean Manager::CreateFileReader( const wchar_t* pFileName, Mix::File::IReader** ppReader )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppReader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppReader[%s]",
			FAILED_CREATEFILEREADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppReader != NULL )? L"" : L"NULL"
			);

		return False;
	}

	if( GetFileReader( FAILED_CREATEFILEREADER, pFileName, ppReader ) == False )
	{
		return False;
	}

	MIX_LOG_INFO( L"t@C[_[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Manager::CreateFileWriter( const wchar_t* pFileName, Mix::File::IWriter** ppWriter )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppWriter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppWriter[%s]",
			FAILED_CREATEFILEWRITER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppWriter != NULL )? L"" : L"NULL"
			);

		return False;
	}

	UInt32 pos;
	UInt32 len;
	Mix::String work;
	Mix::String directoryName;
	Mix::File::Controller* pController;
	Mix::File::FileWriter* pFileWriter;

	len = ::wcslen( pFileName );
	for( pos = len; pos > 0; --pos )
	{
		if( ( pFileName[pos] == L'\\' ) ||
			( pFileName[pos] == L'/' ) )
		{
			break;
		}
	}

	if( pos == 0 )
	{
		MIX_LOG_ERROR( L"%s : ȃt@C : File[%s]", FAILED_CREATEFILEWRITER, pFileName );
		return False;
	}

	work = pFileName;
	directoryName = work.Left( pos + 1 );

	if( CreateDirectory( FAILED_CREATEFILEWRITER, directoryName.GetConstPtr() ) == False )
	{
		return False;
	}

	pController = FindFile( FAILED_CREATEFILEWRITER, pFileName, True );
	if( pController == NULL )
	{
		pController = InsertFile( FAILED_CREATEFILEWRITER, pFileName );
		if( pController == NULL )
		{
			return False;
		}
	}

	if( pController->Open( Mix::File::Controller::WRITE ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@CJ܂ł : File[%s]", FAILED_CREATEFILEWRITER, pFileName );
		return False;
	}

	pFileWriter = Mix::File::FileWriter::CreateInstance( pFileName, pController );
	if( pFileWriter == NULL )
	{
		pController->Close();
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEFILEWRITER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	( *ppWriter ) = pFileWriter;

	MIX_LOG_INFO( L"t@CC^[쐬 : File[%s]", pFileName );

	return True;
}

Boolean Manager::CreateBufferedReader( const wchar_t* pFileName, Mix::File::IReader** ppReader )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppReader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppReader[%s]",
			FAILED_CREATEBUFFEREDREADER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppReader != NULL )? L"" : L"NULL"
			);

		return False;
	}

	UInt32 fileSize;
	Mix::File::Controller* pCtrl;
	Mix::File::BufferedReader* pReader;
	Mix::Memory::Buffer* pBuffer;

	pCtrl = FindFile( FAILED_CREATEBUFFEREDREADER, pFileName, False );
	if( pCtrl == NULL )
	{
		return False;
	}

	if( pCtrl->Open( Controller::READ ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@CJ܂ł : File[%s]", FAILED_CREATEBUFFEREDREADER, pFileName );
		return False;
	}

	if( pCtrl->GetSize() > 0x00000000FFFFFFFF )
	{
		pCtrl->Close();
		MIX_LOG_ERROR( L"%s : t@CTCY傫܂ : File[%s] Size[%I64d]", FAILED_CREATEBUFFEREDREADER, pFileName, pCtrl->GetSize() );
		return False;
	}

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( pBuffer == NULL )
	{
		pCtrl->Close();
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEBUFFEREDREADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	fileSize = static_cast<UInt32>( pCtrl->GetSize() );

	if( pBuffer->Create( fileSize ) == False )
	{
		MIX_RELEASE( pBuffer );
		pCtrl->Close();
		MIX_LOG_ERROR( L"%s : %s : File[%s] Size[%d]", FAILED_CREATEBUFFEREDREADER, Mix::STR_OUTOFMEMORY, pFileName, fileSize );
		return False;
	}

	if( pCtrl->Read( pBuffer->GetPointer(), pBuffer->GetSize() ) != pBuffer->GetSize() )
	{
		MIX_RELEASE( pBuffer );
		pCtrl->Close();
		MIX_LOG_ERROR( L"%s : t@Cǂݎ܂ł : File[%s]", FAILED_CREATEBUFFEREDREADER, pFileName );
		return False;
	}

	pReader = Mix::File::BufferedReader::CreateInstance( pFileName, pBuffer );
	if( pReader == NULL )
	{
		MIX_RELEASE( pBuffer );
		pCtrl->Close();
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEBUFFEREDREADER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	pCtrl->Close();

	( *ppReader ) = pReader;

	MIX_LOG_INFO( L"obt@h[_[쐬 : File[%s] Size[%d]", pFileName, fileSize );

	return True;
}

Boolean Manager::CreateBufferedReader( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::File::IReader** ppReader )
{
	Mix::ScopedLock lock( m_MySync );

	Mix::String safeName = MIX_SAFE_NAME( pName );

	if( ( pBuffer == NULL ) ||
		( ppReader == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : Name[%s] : pBuffer[%s] ppReader[%s]",
			FAILED_CREATEBUFFEREDREADER,
			( pBuffer != NULL )? L"" : L"NULL",
			( ppReader != NULL )? L"" : L"NULL"
			);

		return False;
	}

	Mix::File::BufferedReader* pReader;

	pReader = Mix::File::BufferedReader::CreateInstance( safeName.GetConstPtr(), pBuffer );
	if( pReader != NULL )
	{
		MIX_ADD_REF( pBuffer );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEBUFFEREDREADER, Mix::STR_OUTOFMEMORY, safeName.GetConstPtr() );
		return False;
	}

	( *ppReader ) = pReader;

	MIX_LOG_ERROR( L"obt@h[_[쐬 : Name[%s] Size[%s]", safeName.GetConstPtr(), pBuffer->GetSize() );

	return True;
}

Boolean Manager::CreateFileLoader( Mix::File::ILoaderCallback* pCallback, Mix::File::ILoader** ppLoader, const wchar_t* pName )
{
	Mix::String safeName = MIX_SAFE_NAME( pName );

	if( pCallback == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s] : pCallback[%s]",
			FAILED_CREATEFILELOADER,
			Mix::STR_ILLEGALARG,
			safeName.GetConstPtr(),
			( pCallback != NULL )? L"" : L"NULL"
			);

		return False;
	}

	Mix::File::Loader* pLoader;

	pLoader = Mix::File::Loader::CreateInstance( this, pCallback, safeName.GetConstPtr() );
	if( pLoader == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATEFILELOADER, Mix::STR_OUTOFMEMORY, safeName.GetConstPtr() );
		return False;
	}

	( *ppLoader ) = pLoader;

	MIX_LOG_INFO( L"t@C[_[쐬 : Name[%s]", safeName.GetConstPtr() );

	return True;
}

Boolean Manager::CreateBufferFromFile( const wchar_t* pFileName, Mix::Memory::IBuffer** ppBuffer )
{
	Mix::ScopedLock lock( m_MySync );

	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) ||
		( ppBuffer == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppBuffer[%s]",
			FAILED_CREATEFILEBUFFER,
			Mix::STR_ILLEGALARG,
			( pFileName != NULL )? pFileName : L"NULL",
			( ppBuffer != NULL )? L"" : L"NULL"
			);

		return False;
	}

	Mix::File::IReader* pReader;
	Mix::Memory::Buffer* pBuffer;
	UInt32 fileSize;

	if( GetFileReader( FAILED_CREATEFILEBUFFER, pFileName, &pReader ) == False )
	{
		return False;
	}

	if( pReader->GetSize() <= 0x000000FFFFFFFF )
	{
		fileSize = static_cast<UInt32>( pReader->GetSize() );
	}
	else
	{
		MIX_RELEASE( pReader );
		MIX_LOG_ERROR( L"%s : t@CTCY傫܂ : File[%s] Size[%I64uByte]", FAILED_CREATEFILEBUFFER, pFileName, pReader->GetSize() );
		return False;
	}

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( pBuffer == NULL )
	{
		MIX_RELEASE( pReader );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEFILEBUFFER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	if( pBuffer->Create( fileSize ) == False )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pReader );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEFILEBUFFER, Mix::STR_OUTOFMEMORY, pFileName );
		return False;
	}

	if( pReader->Read( pBuffer->GetPointer(), fileSize ) != fileSize )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pReader );
		MIX_LOG_ERROR( L"%s : t@C𐳏ɓǂݎ܂ł : File[%s]", FAILED_CREATEFILEBUFFER, pFileName );
		return False;
	}

	MIX_RELEASE( pReader );

	( *ppBuffer ) = pBuffer;

	MIX_LOG_INFO( L"t@Cobt@쐬 : File[%s] Size[%dByte]", pFileName, fileSize );

	return True;
}

Boolean Manager::CreateDirectory( const wchar_t* pFailedMsg, const wchar_t* pDirectoryName )
{
	UInt32 i;
	UInt32 len;
	Boolean ret;
	Mix::String directoryName;
	Mix::String work;
	HANDLE hFind;
	WIN32_FIND_DATAW wfd;
	const wchar_t* src;

	//fBNg
	if( ModifyPath( pDirectoryName, True, False, directoryName ) == False )
	{
		MIX_LOG_ERROR( L"%s : fBNgł܂ : Directory[%s]", pFailedMsg, pDirectoryName );
		return False;
	}

	//T[`pX쐬
	work.Sprintf( L"%s*.*", directoryName.GetConstPtr() );

	//tH_łɑ݂Ă邩`FbN
	hFind = ::FindFirstFileW( work.GetConstPtr(), &wfd );
	if( hFind != INVALID_HANDLE_VALUE )
	{
		//łɍ쐬Ă
		::FindClose( hFind );
		return True;
	}

	//tH_쐬
	ret = True;
	len = directoryName.GetNum();
	src = directoryName.GetConstPtr();
	for( i = 0; i < len; i++ )
	{
		if( ( i > 3 ) &&
			( src[i] == L'\\' ) ||
			( src[i] == L'/' ) )
		{
			work = directoryName.Left( i + 1 );

			if( ( ::CreateDirectoryW( work.GetConstPtr(), NULL ) == FALSE ) &&
				( i == ( len - 1 ) ) )
			{
				ret = False;
			}
		}
	}

	if( ret == False )
	{
		MIX_LOG_ERROR( L"%s : CreateDirectoryW %s : Directory[%s]", pFailedMsg, Mix::STR_RETERROR, pDirectoryName );
	}

	return ret;
}

Boolean Manager::GetFileReader( const wchar_t* pFailedMsg, const wchar_t* pFileName, Mix::File::IReader** ppReader )
{
	Mix::File::Controller* pController;
	Mix::File::FileReader* pFileReader;
	
	//t@CT
	pController = FindFile( pFailedMsg, pFileName, False );
	if( pController == NULL )
	{
		return False;
	}

	if( pController->Open( Mix::File::Controller::READ ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@CJ܂ł : File[%s]", pFailedMsg, pFileName );
		return False;
	}

	pFileReader = Mix::File::FileReader::CreateInstance( pFileName, pController );
	if( pFileReader == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", pFailedMsg, Mix::STR_OUTOFMEMORY, pFileName );
		pController->Close();
		return False;
	}

	( *ppReader ) = pFileReader;

	return True;
}

Mix::File::Controller* Manager::FindFile( const wchar_t* pFailedMsg, const wchar_t* pFileName, Boolean bCreateAlways )
{
	Mix::StringW fileName;
	FileMap::iterator file_it;
	Mix::File::Controller* pController = NULL;

	//t@CC
	ModifyPath( pFileName, False, True, fileName );

	//t@C擾
	file_it = m_FileMap.find( fileName );
	if( file_it != m_FileMap.end() )
	{
		//I[v`FbN
		if( file_it->second->IsOpen() == False )
		{
			pController = file_it->second;
		}
		else
		{
			MIX_LOG_ERROR( L"%s : t@C͎gpł : File[%s]", pFailedMsg, pFileName );
		}
	}
	else
	{
		if( bCreateAlways == True )
		{
			//VK쐬
			Mix::File::LocalController* pLocalController;

			pLocalController = Mix::File::LocalController::CreateInstance( fileName.GetConstPtr() );
			if( pLocalController != NULL )
			{
				m_FileMap[fileName] = pLocalController;
				pController = pLocalController;
			}
			else
			{
				MIX_LOG_ERROR( L"%s : %s : File[%s]", pFailedMsg, Mix::STR_OUTOFMEMORY, pFileName );
			}
		}
		else
		{
			MIX_LOG_ERROR( L"%s : t@C܂ : File[%s]", pFailedMsg, pFileName );
		}
	}

	return pController;
}

Mix::File::Controller* Manager::InsertFile( const wchar_t* pFailedMsg, const wchar_t* pFileName )
{
	Mix::StringW fileName;
	Mix::File::LocalController* pController = NULL;
	FileMap::iterator file_it;

	//t@CC
	ModifyPath( pFileName, False, True, fileName );

	//t@C炻Ԃ
	file_it = m_FileMap.find( fileName );
	if( file_it != m_FileMap.end() )
	{
		return file_it->second;
	}

	//[Jt@C쐬
	pController = Mix::File::LocalController::CreateInstance( pFileName );
	if( pController != NULL )
	{
		m_FileMap[fileName] = pController;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", pFailedMsg, Mix::STR_OUTOFMEMORY, pFileName );
	}

	return pController;
}

Boolean Manager::IsAbsolutePath( const wchar_t* pSrc )
{
	Boolean bAbsolute;

	if( ::wcslen( pSrc ) >= 3 )
	{
		if( ( pSrc[1] == L':' ) &&
			( ( pSrc[2] == L'\\' ) || ( pSrc[2] == L'/' ) ) )
		{
			bAbsolute = True;
		}
		else
		{
			bAbsolute = False;
		}
	}
	else
	{
		bAbsolute = False;
	}

	return bAbsolute;
}

Boolean Manager::ModifyPath( const wchar_t* pSrc, Boolean bDirectory, Boolean bLower, Mix::String& dst )
{
	Int32 i;
	wchar_t* pDst;

	if( IsAbsolutePath( pSrc ) == True )
	{
		//΃pX
		dst = pSrc;
	}
	else
	{
		//΃pX
		wchar_t work[MAX_PATH];

		if( ::PathCombineW( work, m_RootDirectoryName.GetConstPtr(), pSrc ) != NULL )
		{
			dst = work;
		}
		else
		{
			return False;
		}
	}

	pDst = dst.GetPtr();
	for( i = 0; pDst[i] != L'\0'; i++ )
	{
		if( pDst[i] == L'/' )
		{
			pDst[i] = L'\\';
		}
	}

	if( bDirectory == True )
	{
		if( ( dst[dst.GetNum() - 1] != L'\\' ) &&
			( dst[dst.GetNum() - 1] != L'/' ) )
		{
			dst += L'\\';
		}
	}

	if( bLower == True )
	{
		dst.Lower();
	}

	return True;
}

void Manager::ModifyDelimiter( Boolean bDirectory, Mix::StringW& path )
{
	Int32 i;
	wchar_t* pTemp = path.GetPtr();

	for( i = 0; pTemp[i] != L'\0'; i++ )
	{
		if( pTemp[i] == L'/' )
		{
			pTemp[i] = L'\\';
		}
	}

	if( bDirectory == True )
	{
		if( path[path.GetNum() - 1] != L'\\' )
		{
			path += L'\\';
		}
	}
}

void Manager::ThreadMain( void )
{
	Boolean bRunning;
	THREADDATA td;

	bRunning = True;

	while( bRunning == True )
	{
		m_LoadQueue.semaCount.Reduce();
		m_LoadQueue.syncList.Enter();
		td = m_LoadQueue.list.front();
		m_LoadQueue.list.pop_front();
		m_LoadQueue.syncList.Leave();
		m_LoadQueue.semaEmpty.Increase();

		switch( td.type )
		{
		case Manager::TYPE_LOAD:
			CreateBufferFromFile( td.fileName.GetConstPtr(), &( td.pBuffer ) );
			m_CompQueue.sync.Enter();
			m_CompQueue.list.push_back( td );
			m_CompQueue.sync.Leave();
			break;
		case Manager::TYPE_EXIT:
			bRunning = False;
			break;
		}
	}
}

void Manager::ThreadEntry( void* pArg )
{
	Manager* pFileMgr = static_cast<Mix::File::Manager*>( pArg );
	pFileMgr->ThreadMain();
}

}}
