#pragma once

#include "Mix/Class/File/Controller.h"

namespace Mix{ namespace File{

	class LocalController : public Mix::File::Controller
	{
	public:
		static LocalController* CreateInstance( const wchar_t* fileName );

	private:
		HANDLE m_hFile;

	private:
		LocalController( const wchar_t* fileName );
		virtual ~LocalController( void );

	public:
		virtual Boolean Open( LocalController::MODE mode );
		virtual void Close( void );
		virtual Boolean IsOpen( void ) const;

		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );

		virtual UInt64 Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset );

		virtual Boolean IsArchive( void ) const;
	};

}}
