#pragma once

#include "Mix/File/ILoader.h"

namespace Mix{ namespace File{

	class Manager;

	class Loader : public Mix::File::ILoader
	{
	public:
		static Loader* CreateInstance( Mix::File::Manager* pMgr, Mix::File::ILoaderCallback* pCallback, const wchar_t* name );

	private:
		Mix::File::Manager* m_pMgr;
		Mix::File::ILoaderCallback* m_pCallback;
		Mix::String m_Name;

	private:
		Loader( Mix::File::Manager* pMgr, Mix::File::ILoaderCallback* pCallback, const wchar_t* name );
		virtual ~Loader( void );

	public:
		void CallLoadComplete( const wchar_t* fileName, Mix::Memory::IBuffer* pBuffer, Mix::Reference* pObject );
		void CallLoadFailed( const wchar_t* fileName, Mix::Reference* pObject );

	public:
		virtual Boolean Load( const wchar_t* fileName, Mix::Reference* pObject );
	};

}}
