#include "Mix/Class/File/Loader.h"
#include "Mix/Class/File/Manager.h"
#include "Mix/File/ILoaderCallback.h"

namespace Mix{ namespace File{

Loader* Loader::CreateInstance( Mix::File::Manager* pMgr, Mix::File::ILoaderCallback* pCallback, const wchar_t* name )
{
	return new Loader( pMgr, pCallback, name );
}

Loader::Loader( Mix::File::Manager* pMgr, Mix::File::ILoaderCallback* pCallback, const wchar_t* name ) :
m_pMgr( pMgr ),
m_pCallback( pCallback ),
m_Name( name )
{
	MIX_ADD_REF( m_pMgr );
	MIX_ADD_REF( m_pCallback );
}

Loader::~Loader( void )
{
	MIX_RELEASE( m_pCallback );
	MIX_RELEASE( m_pMgr );
}

Boolean Loader::Load( const wchar_t* fileName, Mix::Reference* pObject )
{
	if( ( fileName == NULL ) ||
		( ::wcslen( fileName ) == 0 ) )
	{
		MIX_LOG_ERROR( L"t@C̓ǂݍ݊JnɎs : s : Name[%s] : fileName[%s]",
			m_Name.GetConstPtr(),
			( fileName != NULL )? fileName : L"NULL"
			);

		return False;
	}

	if( m_pMgr->PushLoad( fileName, this, pObject ) == False )
	{
		MIX_LOG_ERROR( L"t@C̓ǂݍ݊JnɎs : Xbh~Ă܂ : Name[%s]", m_Name.GetConstPtr() );
		return False;
	}

	m_pCallback->OnLoadStart( fileName, pObject );

	return True;
}

void Loader::CallLoadComplete( const wchar_t* fileName, Mix::Memory::IBuffer* pBuffer, Mix::Reference* pObject )
{
	m_pCallback->OnLoadComplete( fileName, pBuffer, pObject );
}

void Loader::CallLoadFailed( const wchar_t* fileName, Mix::Reference* pObject )
{
	m_pCallback->OnLoadFailed( fileName, pObject );
}

}}
