#pragma once

#include "Mix/File/IWriter.h"

namespace Mix{ namespace File{

	class Controller;

	class FileWriter : public Mix::File::IWriter
	{
	public:
		static FileWriter* CreateInstance( const wchar_t* filePath, Mix::File::Controller* pCtrl );

	private:
		Mix::String m_FilePath;
		Mix::File::Controller* m_pCtrl;

	private:
		FileWriter( const wchar_t* filePath, Mix::File::Controller* pCtrl );
		virtual ~FileWriter( void );

	public:
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
	};

}}
