#include "Mix/Class/File/FileWriter.h"
#include "Mix/Class/File/Controller.h"

namespace Mix{ namespace File{

FileWriter* FileWriter::CreateInstance( const wchar_t* filePath, Mix::File::Controller* pCtrl )
{
	return new FileWriter( filePath, pCtrl );
}

FileWriter::FileWriter( const wchar_t* filePath, Mix::File::Controller* pCtrl ) :
m_FilePath( filePath ),
m_pCtrl( pCtrl )
{
	MIX_ADD_REF( m_pCtrl );
}

FileWriter::~FileWriter( void )
{
	if( m_pCtrl != NULL )
	{
		m_pCtrl->Close();
	}

	MIX_RELEASE( m_pCtrl );
}

UInt32 FileWriter::Write( const void* pWriteBuffer, UInt32 writeSize )
{
	return m_pCtrl->Write( pWriteBuffer, writeSize );
}

UInt64 FileWriter::GetSize( void ) const
{
	return m_pCtrl->GetSize();
}

const wchar_t* FileWriter::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

}}
