#pragma once

#include "Mix/File/IReader.h"

namespace Mix{ namespace File{

	class Controller;

	class FileReader : public Mix::File::IReader
	{
	public:
		static FileReader* CreateInstance( const wchar_t* filePath, Mix::File::Controller* pCtrl );

	private:
		Mix::String m_FilePath;
		Mix::File::Controller* m_pCtrl;

	protected:
		FileReader( const wchar_t* filePath, Mix::File::Controller* pCtrl );
		virtual ~FileReader( void );

	public:
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt64 Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset );
		virtual UInt64 GetPos( void ) const;
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean IsBuffered( void ) const;
		virtual Boolean Clone( Mix::File::IReader** ppReader );
	};

}}
