#include "Mix/Class/File/FileReader.h"
#include "Mix/Class/File/Controller.h"

namespace Mix{ namespace File{

FileReader* FileReader::CreateInstance( const wchar_t* filePath, Mix::File::Controller* pCtrl )
{
	return new FileReader( filePath, pCtrl );
}

FileReader::FileReader( const wchar_t* filePath, Mix::File::Controller* pCtrl ) :
m_FilePath( filePath ),
m_pCtrl( pCtrl )
{
	MIX_ADD_REF( m_pCtrl );
}

FileReader::~FileReader( void )
{
	if( m_pCtrl != NULL )
	{
		m_pCtrl->Close();
	}

	MIX_RELEASE( m_pCtrl );
}

UInt32 FileReader::Read( void* pReadBuffer, UInt32 readSize )
{
	return m_pCtrl->Read( pReadBuffer, readSize );
}

UInt64 FileReader::Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset )
{
	return m_pCtrl->Seek( seekMethod, offset );
}

UInt64 FileReader::GetPos( void ) const
{
	return m_pCtrl->GetPos();
}

UInt64 FileReader::GetSize( void ) const
{
	return m_pCtrl->GetSize();
}

const wchar_t* FileReader::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean FileReader::IsBuffered( void ) const
{
	return False;
}

Boolean FileReader::Clone( Mix::File::IReader** ppReader )
{
	return False;
}

}}
