#pragma once

#include "Mix/File/IReader.h"

namespace Mix{ namespace File{

	class BufferedReader : public Mix::File::IReader
	{
	public:
		static BufferedReader* CreateInstance( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer );

	private:
		Mix::String m_FilePath;
		Mix::Memory::IBuffer* m_pBuffer;
		const UInt8* m_pBegin;
		UInt32 m_Pos;
		UInt32 m_Size;

	private:
		BufferedReader( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer );
		virtual ~BufferedReader( void );

	public:
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt64 Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset );
		virtual UInt64 GetPos( void ) const;
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean IsBuffered( void ) const;
		virtual Boolean Clone( Mix::File::IReader** ppReader );
	};

}}
