#include "Mix/Class/File/BufferedReader.h"

namespace Mix{ namespace File{

BufferedReader* BufferedReader::CreateInstance( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer )
{
	return new BufferedReader( filePath, pBuffer );
}

BufferedReader::BufferedReader( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer ) :
m_FilePath( filePath ),
m_pBuffer( pBuffer ),
m_pBegin( static_cast<const UInt8*>( pBuffer->GetConstPointer() ) ),
m_Pos( 0 ),
m_Size( pBuffer->GetSize() )
{
}

BufferedReader::~BufferedReader( void )
{
	MIX_RELEASE( m_pBuffer );
}

UInt32 BufferedReader::Read( void* pReadBuffer, UInt32 readSize )
{
	if( ( pReadBuffer == NULL ) ||
		( readSize == 0 ) ||
		( m_Pos >= m_Size ) )
	{
		return 0;
	}

	UInt32 size;

	if( ( m_Pos + readSize ) >= m_Size )
	{
		size = ( m_Size - m_Pos );
	}
	else
	{
		size = readSize;
	}

	Mix::Memory::Copy( pReadBuffer, ( m_pBegin + m_Pos ), size );

	m_Pos += size;

	return size;
}

UInt64 BufferedReader::Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset )
{
	UInt32 modifyOffset;

	switch( seekMethod )
	{
	case Mix::File::SEEK_METHOD_BEGIN:
		if( offset > 0 )
		{
			if( offset > 0x00000000FFFFFFFF )
			{
				m_Pos = m_Size;
			}
			else
			{
				modifyOffset = static_cast<UInt32>( offset );
				if( m_Size > modifyOffset )
				{
					m_Pos = modifyOffset;
				}
				else
				{
					m_Pos = m_Size;
				}
			}
		}
		else
		{
			m_Pos = 0;
		}
		break;

	case Mix::File::SEEK_METHOD_CURRENT:
		if( offset < 0 )
		{
			if( -offset > 0x00000000FFFFFFFF )
			{
				m_Pos = 0;
			}
			else
			{
				modifyOffset = static_cast<UInt32>( -offset );
				if( m_Pos > modifyOffset )
				{
					m_Pos -= modifyOffset;
				}
				else
				{
					m_Pos = 0;
				}
			}
		}
		else if( offset > 0 )
		{
			if( offset > 0x00000000FFFFFFFF )
			{
				m_Pos = m_Size;
			}
			else
			{
				modifyOffset = static_cast<UInt32>( offset );
				if( ( m_Size - m_Pos ) > modifyOffset )
				{
					m_Pos += modifyOffset;
				}
				else
				{
					m_Pos = m_Size;
				}
			}
		}
		break;

	case Mix::File::SEEK_METHOD_END:
		if( offset < 0 )
		{
			if( -offset > 0x00000000FFFFFFFF )
			{
				m_Pos = 0;
			}
			else
			{
				modifyOffset = static_cast<UInt32>( -offset );
				if( m_Size > modifyOffset )
				{
					m_Pos = ( m_Size - modifyOffset );
				}
				else
				{
					m_Pos = 0;
				}
			}
		}
		else
		{
			m_Pos = m_Size;
		}
		break;
	}

	return m_Pos;
}

UInt64 BufferedReader::GetPos( void ) const
{
	return m_Pos;
}

UInt64 BufferedReader::GetSize( void ) const
{
	return m_Size;
}

const wchar_t* BufferedReader::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean BufferedReader::IsBuffered( void ) const
{
	return True;
}

Boolean BufferedReader::Clone( Mix::File::IReader** ppReader )
{
	Mix::File::BufferedReader* pReader;

	pReader = Mix::File::BufferedReader::CreateInstance( m_FilePath.GetConstPtr(), m_pBuffer );
	if( pReader != NULL )
	{
		MIX_ADD_REF( m_pBuffer );
	}
	else
	{
		return False;
	}

	( *ppReader ) = pReader;

	return True;
}

}}
