#pragma once

#include "Mix/Class/File/Controller.h"

namespace Mix{ namespace File{

	class Archive;

	class ArchiveController : public Mix::File::Controller
	{
	public:
		static ArchiveController* CreateInstance( const wchar_t* fileName, Mix::File::Archive* pArchive, UInt64 head, UInt64 size );

	private:
		Mix::File::Archive* m_pArchive;
		UInt64 m_Head;

	private:
		ArchiveController( const wchar_t* fileName, Mix::File::Archive* pArchive, UInt64 head, UInt64 size );
		virtual ~ArchiveController( void );

	public:
		Mix::File::Archive* GetArchivePointer( void ) const;

	public:
		virtual Boolean Open( Controller::MODE mode );
		virtual void Close( void );
		virtual Boolean IsOpen( void ) const;

		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );

		virtual UInt64 Seek( Mix::File::SEEK_METHOD seekMethod, Int64 offset );

		virtual Boolean IsArchive( void ) const;
	};

}}
