#pragma once

#include "Mix/Reference.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace File{

	class Archive : public Mix::Reference
	{
	public:
		static Archive* CreateInstance( const wchar_t* fileName );

	private:
		Mix::CriticalSection m_MySync;
		Mix::String m_FileName;
		HANDLE m_hFile;
		UInt32 m_OpenCount;
		Int64 m_Pos;

	private:
		Archive( const wchar_t* fileName );
		virtual ~Archive( void );

	public:
		Boolean Open( void );
		void Close( void );

		UInt32 Read( void* pReadBuffer, UInt64 readPos, UInt32 readSize );
	};

}}
