#include "Mix/Event.h"

using namespace Mix;

Event::Event( Boolean bManual, Boolean bSignal ) : m_hEvent( NULL )
{
	m_hEvent = ::CreateEvent( NULL, bManual, bSignal, NULL );
	MIX_ASSERT( m_hEvent != NULL );
}

Event::~Event( void )
{
	if( m_hEvent != NULL )
	{
		::CloseHandle( m_hEvent );
		m_hEvent = NULL;
	}
}

void Event::Set( void )
{
	if( m_hEvent != NULL )
	{
		::SetEvent( m_hEvent );
	}
}

void Event::Reset( void )
{
	if( m_hEvent != NULL )
	{
		::ResetEvent( m_hEvent );
	}
}

Boolean Event::Wait( UInt32 timeOut ) const
{
	UInt32 ret = ::WaitForSingleObject( m_hEvent, timeOut );
	return ( ret == WAIT_TIMEOUT )? ( False ) : ( True );
}
