#pragma once

#include "Mix/IEngine.h"

#include "Mix/Class/Processor.h"
#include "Mix/Class/Window.h"
#include "Mix/Class/File/Manager.h"
#include "Mix/Class/Sound/Manager.h"
#include "Mix/Class/Input/Manager.h"
#include "Mix/Class/Graphics/DX9/Manager.h"
#include "Mix/Class/Graphics/DX11/Manager.h"
#include "Mix/Class/Dynamics/Manager.h"
#include "Mix/Class/Network/Manager.h"
#include "Mix/Class/Scene/Common/Manager.h"

namespace Mix{

	class UserFile;

	class Engine : public Mix::IEngine
	{
	private:
		static Mix::Engine* g_pThis;

		Mix::Processor					m_Processor;
		Mix::Window*					m_pWindow;
		Mix::File::Manager*				m_pFileMgr;	
		Mix::Sound::Manager*			m_pSoundMgr;
		Mix::Input::Manager*			m_pInputMgr;
		Mix::Graphics::Common::Manager*	m_pGraphicsMgr;
		Mix::Dynamics::Manager*			m_pDynamicsMgr;
		Mix::Network::Manager*			m_pNetworkMgr;
		Mix::Scene::Common::Manager*	m_pSceneMgr;

	public:
		static Boolean CreateInstance( const Mix::ENGINE_CONFIG& config, Mix::UserFile* pSysReport );
		static void ReleaseInstance( void );
		static Engine* GetInstance( void );

		virtual Mix::IWindow* GetWindowPtr( void ) const;
		virtual Mix::File::IManager* GetFileManagerPtr( void ) const;
		virtual Mix::Input::IManager* GetInputManagerPtr( void ) const;
		virtual Mix::Graphics::IManager* GetGraphicsManagerPtr( void ) const;
		virtual Mix::Sound::IManager* GetSoundManagerPtr( void ) const;
		virtual Mix::Dynamics::IManager* GetDynamicsManagerPtr( void ) const;
		virtual Mix::Network::IManager* GetNetworkManagerPtr( void ) const;
		virtual Mix::Scene::IManager* GetSceneManagerPtr( void ) const;

		Mix::Window* GetInternalWindowPtr( void ) const;
		Mix::File::Manager* GetInternalFileManagerPtr( void ) const;
		Mix::Input::Manager* GetInternalInputManagerPtr( void ) const;
		Mix::Graphics::Common::Manager* GetInternalGraphicsManagerPtr( void ) const;
		Mix::Sound::Manager* GetInternalSoundManagerPtr( void ) const;
		Mix::Dynamics::Manager* GetInternalDynamicsManagerPtr( void ) const;
		Mix::Network::Manager* GetInternalNetworkManagerPtr( void ) const;
		Mix::Scene::Common::Manager* GetInternalSceneManagerPtr( void ) const;

	private:
		Engine( void );
		virtual ~Engine( void );

		Boolean Initialize( const Mix::ENGINE_CONFIG& cfg, Mix::UserFile* pSysReport );

		void Dispose( void );
		void Dispose_Init( void );

		Boolean MessageProc( Mix::IWindow* pWindow, UInt32 msg, WPARAM wParam, LPARAM lParam );

	public:
		virtual Boolean Update( void );

		virtual Int32 GetBaseFPS( void ) const;
		virtual Float32 GetBaseDT( void ) const;

		virtual void ResetFPS( void );
		virtual Float32 GetFPS( void ) const;

		virtual Float32 GetDT( void ) const;

		virtual Float32 GetSleepTimePerSec( void ) const;

		virtual Int32 GetInsomniaFrameCountPerSec( void ) const;
		virtual Int32 GetInsomniaFrameMax( void ) const;
	};

}
