#include "Mix/Class/Engine.h"
#include "Mix/Class/UserFile.h"

namespace Mix{

Mix::Engine* Engine::g_pThis = NULL;

Boolean Engine::CreateInstance( const Mix::ENGINE_CONFIG& config, Mix::UserFile* pSysReport )
{
	MIX_ASSERT( g_pThis == NULL );

	g_pThis = new Engine();

	if( g_pThis != NULL )
	{
		if( g_pThis->Initialize( config, pSysReport ) == False )
		{
			MIX_RELEASE( g_pThis );
			return False;
		}
	}
	else
	{
		return False;
	}

	return True;
}

void Engine::ReleaseInstance( void )
{
	if( g_pThis != NULL )
	{
		//Ô߂̋@\~
		g_pThis->Dispose();
	}

	MIX_RELEASE( g_pThis );
}

Engine* Engine::GetInstance( void )
{
	return g_pThis;
}

Engine::Engine( void ) :
m_pWindow( NULL ),
m_pFileMgr( NULL ),
m_pSoundMgr( NULL ),
m_pInputMgr( NULL ),
m_pGraphicsMgr( NULL ),
m_pDynamicsMgr( NULL ),
m_pNetworkMgr( NULL ),
m_pSceneMgr( NULL )
{
}

Engine::~Engine( void )
{
	MIX_RELEASE( m_pSceneMgr );
	MIX_RELEASE( m_pNetworkMgr );
	MIX_RELEASE( m_pGraphicsMgr );
	MIX_RELEASE( m_pSoundMgr );
	MIX_RELEASE( m_pDynamicsMgr );
	MIX_RELEASE( m_pInputMgr );
	MIX_RELEASE( m_pFileMgr );
	MIX_RELEASE( m_pWindow );
}

Boolean Engine::Initialize( const Mix::ENGINE_CONFIG& config, Mix::UserFile* pSysReport )
{
	MIX_ASSERT( pSysReport != NULL );

	MIX_ASSERT( m_pWindow == NULL );
	MIX_ASSERT( m_pFileMgr == NULL );
	MIX_ASSERT( m_pInputMgr == NULL );
	MIX_ASSERT( m_pDynamicsMgr == NULL );
	MIX_ASSERT( m_pSoundMgr == NULL );
	MIX_ASSERT( m_pGraphicsMgr == NULL );
	MIX_ASSERT( m_pNetworkMgr == NULL );
	MIX_ASSERT( m_pSceneMgr == NULL );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// vZbT[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_Processor.Initialize( config.baseFPS, config.insomniaFrames );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// EBhE
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_pWindow = Mix::Window::CreateInstance();

	if( m_pWindow != NULL )
	{
		if( m_pWindow->Initialize( config.window ) == True )
		{
			m_pWindow->RegisterMessageHandler( Mix::MessageHandler( this, &Engine::MessageProc ) );
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}
	else
	{
		Dispose_Init();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// t@C
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseFile == True )
	{
		m_pFileMgr = Mix::File::Manager::CreateInstance();

		if( m_pFileMgr != NULL )
		{
			if( m_pFileMgr->Initialize( config.file ) == False )
			{
				Dispose_Init();
				return False;
			}
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Cvbg
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseInput == True )
	{
		m_pInputMgr = Mix::Input::Manager::CreateInstance();

		if( m_pInputMgr != NULL )
		{
			if( m_pInputMgr->Initialize( m_pWindow->GetHandle(), config.input, pSysReport ) == False )
			{
				Dispose_Init();
				return False;
			}
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// _Ci~NX
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseDynamics == True )
	{
		m_pDynamicsMgr = Mix::Dynamics::Manager::CreateInstance();

		if( m_pDynamicsMgr == NULL )
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// TEh
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseSound == True )
	{
		m_pSoundMgr = Mix::Sound::Manager::CreateInstance();
	
		if( m_pSoundMgr != NULL )
		{
			if( m_pSoundMgr->Start( pSysReport ) == False )
			{
				Dispose_Init();
				return False;
			}
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// OtBbNX
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseGraphics == True )
	{
		switch( config.graphics.shaderModel )
		{
		case Mix::Graphics::SHADER_MODEL_3:
			m_pGraphicsMgr = Mix::Graphics::DX9::Manager::CreateInstance();
			break;
		case Mix::Graphics::SHADER_MODEL_4:
		case Mix::Graphics::SHADER_MODEL_5:
			m_pGraphicsMgr = Mix::Graphics::DX11::Manager::CreateInstance();
			break;
		}

		if( m_pGraphicsMgr != NULL )
		{
			if( m_pGraphicsMgr->Initialize( config.graphics, pSysReport ) == False )
			{
				Dispose_Init();
				return False;
			}
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// lbg[N
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseNetwork == True )
	{
		m_pNetworkMgr = Mix::Network::Manager::CreateInstance();

		if( m_pNetworkMgr != NULL )
		{
			if( m_pNetworkMgr->Initialize() == False )
			{
				Dispose_Init();
				return False;
			}
		}
		else
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// V[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseScene == True )
	{
		m_pSceneMgr = Mix::Scene::Common::Manager::CreateInstance();

		if( m_pSceneMgr == NULL )
		{
			Dispose_Init();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return True;
}

Mix::IWindow* Engine::GetWindowPtr( void ) const
{
	return m_pWindow;
}

Mix::File::IManager* Engine::GetFileManagerPtr( void ) const
{
	return m_pFileMgr;
}

Mix::Input::IManager* Engine::GetInputManagerPtr( void ) const
{
	return m_pInputMgr;
}

Mix::Graphics::IManager* Engine::GetGraphicsManagerPtr( void ) const
{
	return m_pGraphicsMgr;
}

Mix::Sound::IManager* Engine::GetSoundManagerPtr( void ) const
{
	return m_pSoundMgr;
}

Mix::Dynamics::IManager* Engine::GetDynamicsManagerPtr( void ) const
{
	return m_pDynamicsMgr;
}

Mix::Network::IManager* Engine::GetNetworkManagerPtr( void ) const
{
	return m_pNetworkMgr;
}

Mix::Scene::IManager* Engine::GetSceneManagerPtr( void ) const
{
	return m_pSceneMgr;
}

Mix::Window* Engine::GetInternalWindowPtr( void ) const
{
	return m_pWindow;
}

Mix::File::Manager* Engine::GetInternalFileManagerPtr( void ) const
{
	return m_pFileMgr;
}

Mix::Input::Manager* Engine::GetInternalInputManagerPtr( void ) const
{
	return m_pInputMgr;
}

Mix::Graphics::Common::Manager* Engine::GetInternalGraphicsManagerPtr( void ) const
{
	return m_pGraphicsMgr;
}

Mix::Sound::Manager* Engine::GetInternalSoundManagerPtr( void ) const
{
	return m_pSoundMgr;
}

Mix::Dynamics::Manager* Engine::GetInternalDynamicsManagerPtr( void ) const
{
	return m_pDynamicsMgr;
}

Mix::Network::Manager* Engine::GetInternalNetworkManagerPtr( void ) const
{
	return m_pNetworkMgr;
}

Mix::Scene::Common::Manager* Engine::GetInternalSceneManagerPtr( void ) const
{
	return m_pSceneMgr;
}

Boolean Engine::Update( void )
{
	Boolean bLeaveLoop = True;
	Boolean bContinue = True;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// vZbT[̍XV
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_Processor.Update();

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// EBhEAOtBbNX̍XV
	////////////////////////////////////////////////////////////////////////////////////////////////////

	do
	{
		if( m_pWindow->Update() == True )
		{
			if( m_pGraphicsMgr != NULL )
			{
				bLeaveLoop = m_pGraphicsMgr->Update();
			}
		}
		else
		{
			bContinue = False;
		}
	}
	while( ( bLeaveLoop == False ) && ( bContinue == True ) );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// t@CACvbgAV[̍XV
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( bContinue == True )
	{
		if( m_pFileMgr != NULL )
		{
			m_pFileMgr->Update();
		}

		if( m_pInputMgr != NULL )
		{
			m_pInputMgr->Update();
		}

		if( m_pSceneMgr != NULL )
		{
			m_pSceneMgr->Update( m_Processor.GetElaspedTime() );
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return bContinue;
}

Int32 Engine::GetBaseFPS( void ) const
{
	return m_Processor.GetBaseFramesPerSec();
}

Float32 Engine::GetBaseDT( void ) const
{
	return m_Processor.GetBaseElaspedTime();
}

void Engine::ResetFPS( void )
{
	return m_Processor.Reset();
}

Float32 Engine::GetFPS( void ) const
{
	return m_Processor.GetFramesPerSec();
}

Float32 Engine::GetDT( void ) const
{
	return m_Processor.GetElaspedTime();
}

Float32 Engine::GetSleepTimePerSec( void ) const
{
	return m_Processor.GetSleepTimePerSec();
}

Int32 Engine::GetInsomniaFrameMax( void ) const
{
	return m_Processor.GetInsomniaFrameMax();
}

Int32 Engine::GetInsomniaFrameCountPerSec( void ) const
{
	return m_Processor.GetInsomniaFrameCountPerSec();
}

void Engine::Dispose( void )
{
	if( m_pSceneMgr != NULL )
	{
		m_pSceneMgr->Dispose();
	}

	if( m_pGraphicsMgr != NULL )
	{
		m_pGraphicsMgr->Dispose();
	}

	if( m_pInputMgr != NULL )
	{
		m_pInputMgr->Dispose();
	}

	if( m_pFileMgr != NULL )
	{
		m_pFileMgr->Dispose();
	}
}

void Engine::Dispose_Init( void )
{
	Dispose();

	if( m_pWindow != NULL )
	{
		m_pWindow->Dispose();
	}
}

Boolean Engine::MessageProc( Mix::IWindow* pWindow, UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	//OtBbNX}l[W̃bZ[W
	if( m_pGraphicsMgr != NULL )
	{
		m_pGraphicsMgr->MessageProc( msg, wParam, lParam );
	}

	//Cvbg}l[W̃bZ[W
	if( m_pInputMgr != NULL )
	{
		m_pInputMgr->MessageProc( msg, wParam, lParam );
	}

	//GW̃bZ[W
	switch( msg )
	{
	case WM_MOVE:
	case WM_EXITSIZEMOVE:
	case WM_EXITMENULOOP:
		m_Processor.Reset();
		break;

	case WM_DESTROY:
		Dispose();
		break;

	case WM_MIX_INTERNALERROR:
		Mix::String text;
		text.Sprintf( L"MixCuŃG[܂B\nAvP[VI܂B\n\nG[ԍ(%d)", wParam );
		::MessageBoxW( m_pWindow->GetHandle(), text.GetConstPtr(), L"Mix", MB_ICONERROR | MB_OK );
		m_pWindow->PostMessage( WM_DESTROY, 0, 0 );
		return 0;
	}

	return True;
}

}
