#pragma once

#include "Mix/Class/Dynamics/Object.h"
#include "Mix/Dynamics/IStaticPlane.h"

#include <vector>

namespace Mix{ namespace Dynamics{

	class ObjectContext;

	class StaticPlane : public Mix::Dynamics::IStaticPlane, public Mix::Dynamics::Object
	{
	public:
		static StaticPlane* CreateInstance( const Mix::Vector3& normal, float constant );

	private:
		btStaticPlaneShape* m_pShape;
		btDefaultMotionState* m_pMotionState;
		btRigidBody* m_pRigidBody;

		Mix::Vector3 m_Normal;
		float m_Constant;

		Mix::Dynamics::ObjectContext* m_pContext;

		Int32 m_UserIndex;
		void* m_pUserPtr;

		Float32 m_DebugDrawInterval;
		UInt32 m_DebugDrawExtent;
		std::vector<Mix::Vector3> m_DebugDrawPoints;

	private:
		StaticPlane( const Mix::Vector3& normal, float constant );
		virtual ~StaticPlane( void );

		void Debug_UpdatePoints( void );

	public:
		Boolean Initialize( const wchar_t* pDebugName );

	public:
		virtual Mix::Dynamics::ObjectContext* GetContextPtr( void ) const;

		virtual btCollisionObject* Bullet_GetCollisionObjectPtr( void ) const;
		virtual btRigidBody* Bullet_GetRigidBodyPtr( void ) const;

	public:
		virtual const Mix::Vector3& GetNormal( void ) const;
		virtual float GetConstant( void ) const;

	public:
		virtual Mix::Dynamics::IObject::TYPE GetType( void ) const;

		virtual Boolean GetShape( Mix::Dynamics::IShape** ppShape );

		virtual Float32 GetShapeMargin( void ) const;
		virtual void SetShapeMargin( Float32 margin );

		virtual UInt16 GetFilterGroup( void ) const;
		virtual void SetFilterGroup( UInt16 filterGroup );

		virtual UInt16 GetFilterMask( void ) const;
		virtual void SetFilterMask( UInt16 filterMask );

		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const;
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material );

		virtual Mix::Quaternion GetWorldRotation( void ) const;
		virtual Mix::Vector3 GetWorldPosition( void ) const;
		virtual Mix::Matrix4x4 GetWorldMatrix( void ) const;

		virtual void SetWorldRotation( const Mix::Quaternion& rotation );
		virtual void SetWorldPosition( const Mix::Vector3& pos );
		virtual void SetWorldTransform( const Mix::Quaternion& rot, const Mix::Vector3& pos );

		virtual Boolean IsInWorld( void ) const;

		virtual Mix::Geometry::AABB GetBounds( void ) const;

		virtual Boolean AddListener( Mix::Dynamics::IObjectListener* pListener );
		virtual void RemoveListener( Mix::Dynamics::IObjectListener* pListener );

		virtual Int32 GetUserIndex( void ) const;
		virtual void SetUserIndex( Int32 index );

		virtual void* GetUserPtr( void ) const;
		virtual void SetUserPtr( void* pData );

		virtual UInt32 Debug_GetDrawFlags( void ) const;
		virtual void Debug_SetDrawFlags( UInt32 flags );

		virtual Float32 Debug_GetDrawAxisScaling( void ) const;
		virtual void Debug_SetDrawAxisScaling( Float32 scaling );

		virtual Float32 Debug_GetDrawInterval( void ) const;
		virtual void Debug_SetDrawInterval( Float32 interval );

		virtual UInt32 Debug_GetDrawExtent( void ) const;
		virtual void Debug_SetDrawExtent( UInt32 extent );

		virtual void Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, Float32 opacity );

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}
