#pragma once

#include "Mix/Dynamics/ISphereShape.h"
#include "Mix/Class/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class SphereShape : public Mix::Dynamics::ISphereShape, public Mix::Dynamics::Shape
	{
	public:
		static SphereShape* CreateInstance( void );

	private:
		btSphereShape* m_pObject;

	private:
		SphereShape( void );
		virtual ~SphereShape( void );

	public:
		Boolean Initialize( Float32 radius );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Float32 GetRadius( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt );
	};

}}
