#include "Mix/Class/Dynamics/SphereShape.h"

#include "Mix/Graphics/Utility/ILineArt.h"

namespace Mix{ namespace Dynamics{

SphereShape* SphereShape::CreateInstance( void )
{
	return new SphereShape();
}

SphereShape::SphereShape( void ) :
m_pObject( NULL )
{
}

SphereShape::~SphereShape( void )
{
	MIX_DELETE( m_pObject );
}

Boolean SphereShape::Initialize( Float32 radius )
{
	m_pObject = new btSphereShape( radius );
	if( m_pObject != NULL )
	{
		Shape::Bullet_SetCollisionShape( m_pObject );
	}
	else
	{
		return False;
	}

	return True;
}

btConvexShape* SphereShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Float32 SphereShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE SphereShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::SPHERE;
}

Float32 SphereShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void SphereShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void SphereShape::DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt )
{
	if( pLineArt != NULL )
	{
		pLineArt->AddSphere( GetRadius() );
	}
}

}}
