#pragma once

#include "Mix/Dynamics/IPointJoint.h"
#include "Mix/Class/Dynamics/Joint.h"

namespace Mix{ namespace Dynamics{

	class PointJoint : public Mix::Dynamics::IPointJoint, public Mix::Dynamics::Joint
	{
	private:
		enum PARAM_FLAG
		{
			PF_PIVOT_SPRING = 0x00000001,
			PF_PIVOT_DAMPER = 0x00000002,
		};

	public:
		static PointJoint* CreateInstance(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											const Mix::Vector3& pivotA );

		static PointJoint* CreateInstance(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											Mix::Dynamics::IRigidBody* pRigidBodyB,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& pivotB );

	private:
		Mix::Dynamics::IRigidBody* m_pRigidBodyA;
		Mix::Dynamics::IRigidBody* m_pRigidBodyB;

		Mix::Vector3 m_PivotA;
		Mix::Vector3 m_PivotB;

		btPoint2PointConstraint* m_pObject;

		UInt32 m_ParamFlags;

	private:
		PointJoint( Mix::Dynamics::IRigidBody* pRigidBodyA,
					const Mix::Vector3& pivotA );

		PointJoint( Mix::Dynamics::IRigidBody* pRigidBodyA,
					Mix::Dynamics::IRigidBody* pRigidBodyB,
					const Mix::Vector3& pivotA,
					const Mix::Vector3& pivotB );

		virtual ~PointJoint( void );

	public:
		Boolean Initialize( const wchar_t* pDebugName );

	public:
		virtual Mix::Dynamics::IJoint::TYPE GetType( void ) const;

		virtual Boolean IsInWorld( void ) const;

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		virtual Float32 GetBreakingImpulseThreshold( void ) const;
		virtual void SetBreakingImpulseThreshold( Float32 threshold );

		virtual Boolean IsSingle( void ) const;

		virtual void GetRigidBodyA( Mix::Dynamics::IRigidBody** ppRigidBody );
		virtual void GetRigidBodyB( Mix::Dynamics::IRigidBody** ppRigidBody );

		virtual const Mix::Vector3& GetPivotA( void ) const;
		virtual void SetPivotA( const Mix::Vector3& pivot );

		virtual const Mix::Vector3& GetPivotB( void ) const;
		virtual void SetPivotB( const Mix::Vector3& pivot );

	public:
		virtual UInt32 Debug_GetDrawFlags( void ) const;
		virtual void Debug_SetDrawFlags( UInt32 flags );

		virtual Float32 Debug_GetDrawFrameMinSize( void ) const;
		virtual void Debug_SetDrawFrameMinSize( Float32 minSize );

		virtual Float32 Debug_GetDrawLimitScaling( void ) const;
		virtual void Debug_SetDrawLimitScaling( Float32 scaling );

		virtual void Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, Float32 opacity );

	public:
		virtual Float32 GetPivotSpring( void ) const;
		virtual void SetPivotSpring( Float32 spring );

		virtual Float32 GetPivotDamper( void ) const;
		virtual void SetPivotDamper( Float32 damper );

	public:
		virtual btTypedConstraint* Bullet_GetTypedConstraintPtr( void ) const;

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}
