#include "Mix/Class/Dynamics/Object.h"
#include "Mix/Class/Dynamics/ObjectContext.h"

namespace Mix{ namespace Dynamics{

Object::Object( UInt16 filterGroup, UInt16 filterMask, UInt32 debugDrawFlags ) :
m_pWorld( NULL ),
m_FilterGroup( filterGroup ),
m_FilterMask( filterMask )
{
	m_DebugDrawFlags = debugDrawFlags;
	m_DebugDrawAxisScaling = 0.1f;
}

Object::~Object( void )
{
}

Boolean Object::IsInWorld( void ) const
{
	return ( m_pWorld != NULL );
}

Mix::Dynamics::World* Object::GetWorldPtr( void ) const
{
	return m_pWorld;
}

void Object::SetWorldPtr( Mix::Dynamics::World* pWorld )
{
	if( m_pWorld != NULL )
	{
		OnDetachFromWorld( m_pWorld );
	}

	m_pWorld = pWorld;

	if( m_pWorld != NULL )
	{
		OnAttachToWorld( m_pWorld );
	}
}

void Object::Bullet_BeginRefresh( void )
{
	if( m_pWorld != NULL )
	{
		m_pWorld->BeginRefreshObject( this );
	}
}

void Object::Bullet_EndRefresh( void )
{
	if( m_pWorld != NULL )
	{
		m_pWorld->EndRefreshObject( this );
	}
}

void Object::Bullet_Refresh( void )
{
	if( m_pWorld != NULL )
	{
		m_pWorld->RefreshObject( this );
	}
}

UInt16 Object::Bullet_GetFilterGroup( void ) const
{
	return m_FilterGroup;
}

void Object::Bullet_SetFilterGroup( UInt16 filterGroup )
{
	m_FilterGroup = filterGroup;

	if( m_pWorld != NULL )
	{
		m_pWorld->RefreshObject( this );
	}
}

UInt16 Object::Bullet_GetFilterMask( void ) const
{
	return m_FilterMask;
}

void Object::Bullet_SetFilterMask( UInt16 filterMask )
{
	m_FilterMask = filterMask;

	if( m_pWorld != NULL )
	{
		m_pWorld->RefreshObject( this );
	}
}

btRigidBody* Object::Bullet_GetRigidBodyPtr( void ) const
{
	return NULL;
}

btActionInterface* Object::Bullet_GetActionInterfacePtr( void ) const
{
	return NULL;
}

btCharacterControllerInterface* Object::Bullet_GetCharacterControllerInterfacePtr( void ) const
{
	return NULL;
}

btRaycastVehicle* Object::Bullet_GetRaycastVehiclePtr( void ) const
{
	return NULL;
}

}}
