#pragma once

#include "Mix/Dynamics/ICylinderShape.h"
#include "Mix/Class/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class CylinderShape : public Mix::Dynamics::ICylinderShape, public Mix::Dynamics::Shape
	{
	public:
		static CylinderShape* CreateInstance( void );

	private:
		Mix::Dynamics::AXIS_TYPE m_Axis;
		Float32 m_Height;
		Float32 m_Radius;
		btCylinderShape* m_pObject;

	private:
		CylinderShape( void );
		virtual ~CylinderShape( void );

	public:
		Boolean Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 height, Float32 radius );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Mix::Dynamics::AXIS_TYPE GetAxis( void ) const;
		virtual Float32 GetHeight( void ) const;
		virtual Float32 GetRadius( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt );
	};

}}
