#pragma once

#include "Mix/Dynamics/IConvexHullShape.h"
#include "Mix/Class/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class ConvexHullShape : public Mix::Dynamics::IConvexHullShape, public Shape
	{
	public:
		static ConvexHullShape* CreateInstance( void );

	private:
		btConvexHullShape* m_pObject;

	private:
		ConvexHullShape( void );
		virtual ~ConvexHullShape( void );

	public:
		Boolean Initialize( const Mix::Dynamics::MESH& mesh );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt );
	};

}}
