#include "Mix/Class/Dynamics/ConvexHullShape.h"

#include "BulletCollision/CollisionShapes/btShapeHull.h"

#include "Mix/Graphics/Utility/ILineArt.h"

namespace Mix{ namespace Dynamics{

ConvexHullShape* ConvexHullShape::CreateInstance( void )
{
	return new ConvexHullShape();
}

ConvexHullShape::ConvexHullShape( void ) :
m_pObject( NULL )
{
}

ConvexHullShape::~ConvexHullShape( void )
{
	MIX_DELETE( m_pObject );
}

Boolean ConvexHullShape::Initialize( const Mix::Dynamics::MESH& mesh )
{
	btIndexedMesh idxMesh;
	btTriangleMesh* triMesh;
	btConvexShape* convex;
	btShapeHull* hull;

	triMesh = new btTriangleMesh();
	if( triMesh == NULL )
	{
		return False;
	}

	idxMesh.m_numTriangles        = mesh.polygonCount;
	idxMesh.m_triangleIndexBase   = reinterpret_cast<const UInt8*>( mesh.polygonIndices );
	idxMesh.m_triangleIndexStride = sizeof( UInt32[3] );
	idxMesh.m_numVertices         = mesh.vertexCount;
	idxMesh.m_vertexBase          = reinterpret_cast<const UInt8*>( mesh.vertices );
	idxMesh.m_vertexStride        = sizeof( Mix::Vector3 );
	idxMesh.m_indexType           = PHY_INTEGER;

	triMesh->addIndexedMesh( idxMesh );

	convex = new btConvexTriangleMeshShape( triMesh );
	if( convex == NULL )
	{
		MIX_DELETE( triMesh );
		return False;
	}

	hull = new btShapeHull( convex );
	if( hull == NULL )
	{
		MIX_DELETE( convex );
		MIX_DELETE( triMesh );
		return False;
	}

	hull->buildHull( convex->getMargin() );

	m_pObject = new btConvexHullShape( reinterpret_cast<const btScalar*>( hull->getVertexPointer() ), hull->numVertices() );
	if( m_pObject != NULL )
	{
		Shape::Bullet_SetCollisionShape( m_pObject );
	}
	else
	{
		MIX_DELETE( hull );
		MIX_DELETE( convex );
		MIX_DELETE( triMesh );
		return False;
	}

	MIX_DELETE( hull );
	MIX_DELETE( convex );
	MIX_DELETE( triMesh );

	return True;
}

btConvexShape* ConvexHullShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Mix::Dynamics::IShape::TYPE ConvexHullShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CONVEXHULL;
}

Float32 ConvexHullShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void ConvexHullShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void ConvexHullShape::DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt )
{
}

}}
