#include "Mix/Class/Dynamics/ConeShape.h"

#include "Mix/Graphics/Utility/ILineArt.h"

namespace Mix{ namespace Dynamics{

ConeShape* ConeShape::CreateInstance( void )
{
	return new ConeShape();
}

ConeShape::ConeShape( void ) :
m_Axis( Mix::Dynamics::AXIS_Y ),
m_pObject( NULL )
{
}

ConeShape::~ConeShape( void )
{
	MIX_DELETE( m_pObject );
}

Boolean ConeShape::Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 axisLength, Float32 radius )
{
	switch( axis )
	{
	case Mix::Dynamics::AXIS_X:
		m_pObject = new btConeShapeX( radius, axisLength );
		break;
	case Mix::Dynamics::AXIS_Y:
		m_pObject = new btConeShape( radius, axisLength );
		break;
	case Mix::Dynamics::AXIS_Z:
		m_pObject = new btConeShapeZ( radius, axisLength );
		break;
	}

	if( m_pObject == NULL )
	{
		return False;
	}

	Shape::Bullet_SetCollisionShape( m_pObject );
	m_Axis = axis;

	return True;
}

btConvexShape* ConeShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Float32 ConeShape::GetAxisLength( void ) const
{
	return m_pObject->getHeight();
}

Float32 ConeShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE ConeShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CONE;
}

Float32 ConeShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void ConeShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void ConeShape::DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt )
{
}

}}
