#include "Mix/Class/Dynamics/CapsuleShape.h"
#include "Mix/Graphics/Utility/ILineArt.h"

namespace Mix{ namespace Dynamics{

CapsuleShape* CapsuleShape::CreateInstance( void )
{
	return new CapsuleShape();
}

CapsuleShape::CapsuleShape( void ) :
m_pObject( NULL ),
m_Height( 0.0f )
{
}

CapsuleShape::~CapsuleShape( void )
{
	MIX_DELETE( m_pObject );
}

Boolean CapsuleShape::Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 height, Float32 radius )
{
	height = max( 0.0f, height - radius * 2.0f );

	switch( axis )
	{
	case Mix::Dynamics::AXIS_X:
		m_pObject = new btCapsuleShapeX( radius, height );
		break;
	case Mix::Dynamics::AXIS_Y:
		m_pObject = new btCapsuleShape( radius, height );
		break;
	case Mix::Dynamics::AXIS_Z:
		m_pObject = new btCapsuleShapeZ( radius, height );
		break;
	}

	if( m_pObject == NULL )
	{
		return False;
	}

	Shape::Bullet_SetCollisionShape( m_pObject );
	m_Axis = axis;
	m_Height = height + radius * 2.0f;

	return True;
}

btConvexShape* CapsuleShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Mix::Dynamics::AXIS_TYPE CapsuleShape::GetAxis( void ) const
{
	return m_Axis;
}

Float32 CapsuleShape::GetHeight( void ) const
{
	return m_Height;
}

Float32 CapsuleShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE CapsuleShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CAPSULE;
}

Float32 CapsuleShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void CapsuleShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void CapsuleShape::DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt )
{
	if( pLineArt != NULL )
	{
		pLineArt->AddCapsule( m_Axis, GetHeight(), GetRadius() );
	}
}

}}
