#include "Mix/Dynamics.h"

#include "Mix/Dynamics/IObject.h"
#include "Mix/Class/Dynamics/Utility.h"
#include "Mix/Class/Dynamics/Object.h"
#include "Mix/Class/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

Boolean TestRay( const Mix::Vector3& rayFrom, const Mix::Vector3& rayTo, Mix::Dynamics::IObject* pReceiveObject, Mix::Dynamics::TEST_LOCAL_RESULT& result )
{
	static const wchar_t* FAILED_TEST = L"ČɎs";

	if( pReceiveObject == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : pReceiveObject[%s]",
			FAILED_TEST,
			Mix::STR_ILLEGALARG,
			( pReceiveObject != NULL )? L"" : L"NULL" );

		return False;
	}

	Mix::Dynamics::Object* pInternalObject = dynamic_cast<Mix::Dynamics::Object*>( pReceiveObject );
	MIX_ASSERT_EX( pInternalObject != NULL, L"%s : IuWFNgփLXgł܂ł", FAILED_TEST );

	btVector3 from = ToBulletVector3( rayFrom );
	btVector3 to = ToBulletVector3( rayTo );

	btCollisionObject* pCollObj = pInternalObject->Bullet_GetCollisionObjectPtr();
	btTransform collObjTr( ToBulletQuaternion( pReceiveObject->GetWorldRotation() ), ToBulletVector3( pReceiveObject->GetWorldPosition() ) );

	btCollisionWorld::ClosestRayResultCallback resultCallback( from, to );

	btCollisionWorld::rayTestSingle(
		btTransform( btQuaternion::getIdentity(), from ),
		btTransform( btQuaternion::getIdentity(), to ),
		NULL,
		pCollObj->getCollisionShape(),
		pCollObj->getWorldTransform(),
		resultCallback );

	if( resultCallback.hasHit() == true )
	{
		result.pos = ToMixVector3( resultCallback.m_hitPointWorld );
		result.normal = ToMixVector3( resultCallback.m_hitNormalWorld );
	}
	else
	{
		return False;
	}

	return True;
}

Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
					const Mix::Vector3& castShapeFromPos,
					const Mix::Vector3& castShapeToPos,
					const Mix::Dynamics::IObject* pReceiveObject,
					Mix::Dynamics::TEST_LOCAL_RESULT& result )
{
	return TestSweep(	pCastShape,
						Mix::Quaternion::Identity(), castShapeFromPos,
						Mix::Quaternion::Identity(), castShapeToPos,
						pReceiveObject,
						result );
}

Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
					const Mix::Quaternion& castShapeFromRot, const Mix::Vector3& castShapeFromPos,
					const Mix::Quaternion& castShapeToRot, const Mix::Vector3& castShapeToPos,
					const Mix::Dynamics::IObject* pReceiveObject,
					Mix::Dynamics::TEST_LOCAL_RESULT& result )
{
	static const wchar_t* FAILED_TEST = L"XB[v̌Ɏs";

	if( ( pCastShape == NULL ) ||
		( pReceiveObject == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pCastShape[%s] pReceiveObject[%s]",
			FAILED_TEST,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pCastShape ),
			MIX_LOG_PTR( pReceiveObject ) );

		return False;
	}

	if( pCastShape->GetType() == Mix::Dynamics::IShape::COMPOUND )
	{
		MIX_LOG_ERROR( L"%s : LXgVFCvɃRpEhVFCvw肷邱Ƃ͂ł܂", FAILED_TEST );
		return False;
	}

	const Mix::Dynamics::Shape* pInternalCastShape = dynamic_cast<const Mix::Dynamics::Shape*>( pCastShape );
	const Mix::Dynamics::Object* pInternalReceiveObject = dynamic_cast<const Mix::Dynamics::Object*>( pReceiveObject );
	btCollisionObject* pReceiveCollObject = pInternalReceiveObject->Bullet_GetCollisionObjectPtr();
	btCollisionShape* pReceiveCollShape = pReceiveCollObject->getCollisionShape();

	btVector3 castFromPos = ToBulletVector3( castShapeFromPos );
	btVector3 castToPos = ToBulletVector3( castShapeToPos );
	btTransform castFromTr( ToBulletQuaternion( castShapeFromRot ), castFromPos );
	btTransform castToTr( ToBulletQuaternion( castShapeToRot ), castToPos );
	btTransform receiveTr( ToBulletQuaternion( pReceiveObject->GetWorldRotation() ), ToBulletVector3( pReceiveObject->GetWorldPosition() ) );

	btCollisionWorld::ClosestConvexResultCallback resultCallback( castFromPos, castToPos );

	btCollisionWorld::objectQuerySingle(
						pInternalCastShape->Bullet_GetConvexShapePtr(),
						castFromTr,
						castToTr,
						NULL,
						pReceiveCollShape,
						receiveTr,
						resultCallback,
						0.0f );

	if( resultCallback.hasHit() == true )
	{
		result.pos = ToMixVector3( resultCallback.m_hitPointWorld );
		result.normal = ToMixVector3( resultCallback.m_hitNormalWorld );
	}
	else
	{
		return False;
	}

	return True;
}

}}
