#pragma once

#include "Mix/Common.h"

namespace Mix
{
	class CpuID
	{
	private:
		enum CPU_FLAG
		{
			CPU_MMX		= 0x00800000,
			CPU_SSE		= 0x02000000,
			CPU_SSE2	= 0x04000000,
			CPU_3DNOW	= 0x80000000,
		};

	private:
		static Mix::CPU_INFO g_Info;

	private:
		static Boolean GetCPUIDSupport( void );
		static Boolean GetOSSupport( UInt32 feature );

	public:
		static Boolean Initialize( void );
		static const Mix::CPU_INFO& GetInfo( void );
	};
};
