#include "Mix/Class/CpuID.h"

namespace Mix{

Mix::CPU_INFO CpuID::g_Info;

Boolean CpuID::Initialize( void )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// cpuid ߂gpł邩`FbN
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( GetCPUIDSupport() == False )
	{
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// CPU擾
	////////////////////////////////////////////////////////////////////////////////////////////////////

	UInt32 standard = 0;
	UInt32 feature = 0;
	UInt32 vmax = 0;
	UInt32 ext = 0;

	union
	{
		char buff[12+1];

		struct
		{
            UInt32 b0;
            UInt32 b1;
            UInt32 b2;
		}s;

	}ident;

	_asm
	{
		push ebx
		push ecx
		push edx

		// get the vender string
		xor eax, eax
		cpuid
		mov vmax, eax
		mov ident.s.b0, ebx
		mov ident.s.b1, edx
		mov ident.s.b2, ecx

		// get the Standard bits
		mov eax, 1
		cpuid
		mov standard, eax
		mov feature, edx

		// get AMD-specials
		mov eax, 80000000h
		cpuid
		cmp eax, 80000000h
		jc notamd
		mov eax, 80000001h
		cpuid
		mov ext, edx

notamd:
		pop ecx
		pop ebx
		pop edx
    }

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// OS̖߃T|[g`FbN
	////////////////////////////////////////////////////////////////////////////////////////////////////

	const UInt32 CPU_TABLE[] =
	{
		CpuID::CPU_MMX,
		CpuID::CPU_SSE,
		CpuID::CPU_SSE2,
	};

	const UInt32 CPU_FEATURE_TABLE[] =
	{
		Mix::CPU_FEATURE_MMX,
		Mix::CPU_FEATURE_SSE,
		Mix::CPU_FEATURE_SSE2,
	};

	const UInt32 CPU_COUNT = sizeof( CPU_TABLE ) / sizeof( UInt32 );

	//INTEL
	for( UInt32 i = 0; i < CPU_COUNT; i++ )
	{
		UInt32 test = CPU_TABLE[i];

		if( MIX_TESTBIT( feature, test ) == test )
		{
			test = CPU_FEATURE_TABLE[i];

			MIX_SETBIT( g_Info.feature, test );

			if( GetOSSupport( test ) == True )
			{
				MIX_SETBIT( g_Info.osFeature, test );
			}
		}
	}

	//AMD
	if( MIX_TESTBIT( ext, CpuID::CPU_3DNOW ) == CpuID::CPU_3DNOW )
	{
		MIX_SETBIT( g_Info.feature, Mix::CPU_FEATURE_3DNOW );

		if( GetOSSupport( Mix::CPU_FEATURE_3DNOW ) == True )
		{
			MIX_SETBIT( g_Info.osFeature, Mix::CPU_FEATURE_3DNOW );
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// t@~[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	g_Info.family = ( standard >> 8 ) & 0xF;
	if( g_Info.family == 15 )
	{
		g_Info.family |= ( standard >> 16 ) & 0xFF0;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// f
	////////////////////////////////////////////////////////////////////////////////////////////////////

	g_Info.model = ( standard >> 4 ) & 0xF;
	if( g_Info.model == 15 )
	{
		g_Info.model |= ( standard >> 12 ) & 0xF;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// rW
	////////////////////////////////////////////////////////////////////////////////////////////////////

	g_Info.revision = ( standard ) & 0xF;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// x_[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::StringW venderName;

	ident.buff[12] = 0;
	venderName = ident.buff;

	::wcscpy_s( g_Info.venderName, sizeof( g_Info.venderName ) >> 1, venderName.GetConstPtr() );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// f
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( ::wcscmp( L"AuthenticAMD", g_Info.venderName ) == 0 )
	{
		switch( g_Info.family )
		{
		//AMD : Am486
		case 4:
			::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD Am486" );
			break;

		//AMD : K6
		case 5:
			switch( g_Info.model )
			{
			case 0:
			case 1:
			case 2:
			case 3:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD K5" );
				break;
			case 6:
			case 7:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD K6" );
				break;
			case 8:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD K6-2" );
				break;
			case 9:
			case 10:
			case 11:
			case 12:
			case 13:
			case 14:
			case 15:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD K6-3" );
				break;
			}
			break;

		//AMD : ATHLON
		case 6:
			::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"AMD ATHLON" );
			break;
		}
	}
	else if ( ::wcscmp( L"GenuineIntel", g_Info.venderName ) == 0 )
	{
		switch( g_Info.family )
		{
		//INTEL : 486
		case 4:
			switch( g_Info.model )
			{
			case 0:
			case 1:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486DX" );
				break;
			case 2:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486SX" );
				break;
			case 3:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486DX2" );
				break;
			case 4:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486SL" );
				break;
			case 5:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486SX2" );
				break;
			case 7:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486DX2E" );
				break;
			case 8:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL 486DX4" );
				break;
			}
			break;

		//INTEL : Pentium
		case 5:
			switch( g_Info.model )
			{
			case 1:
			case 2:
			case 3:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium" );
				break;
			case 4:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium-MMX" );
				break;
			}
			break;

		//INTEL : Pentium II - III
		case 6:
			switch( g_Info.model )
			{
			case 1:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium-Pro" );
				break;
			case 3:
			case 5:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium-II" );
				break;
			case 6:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Celeron" );
				break;
			case 7:
			case 8:
			case 10:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium-III" );
				break;
			}
			break;

		//INTEL : Pentium 4
		case ( 15 | ( 0x00 << 4 ) ):
			switch( g_Info.model )
			{
			case 0:
				::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"INTEL Pentium-4" );
				break;
			}
			break;
		}
	}
	else if( ::wcscmp( L"CyrixInstead", g_Info.venderName ) )
	{
		::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"Cyrix" );
	}
	else if( ::wcscmp( L"CentaurHauls", g_Info.venderName ) )
	{
		::wcscpy_s( g_Info.modelName, sizeof( g_Info.modelName ) >> 1, L"Unknown" );
	}

	return True;
}

const Mix::CPU_INFO& CpuID::GetInfo( void )
{
	return g_Info;
}

Boolean CpuID::GetCPUIDSupport( void )
{
	__try
	{
		_asm
		{
			xor eax, eax
			cpuid
		}
	}
	__except( EXCEPTION_EXECUTE_HANDLER )
	{
		return False;
	}

	return True;
}

Boolean CpuID::GetOSSupport( UInt32 feature )
{
	__try
	{
		switch( feature )
		{
		case Mix::CPU_FEATURE_SSE:
			__asm
			{
				xorps xmm0, xmm0        // executing SSE instruction
			}
			break;

		case Mix::CPU_FEATURE_SSE2:
			__asm 
			{
				xorpd xmm0, xmm0        // executing SSE2 instruction
			}
			break;

#ifdef _USE_NON_INTEL_COMPILER

		case Mix::CPU_FEATURE_3DNOW:
			__asm 
			{
				pfrcp mm0, mm0          // executing 3DNow! instruction
				emms
			}
			break;

#endif  /*_USE_NON_INTEL_COMPILER */

		case Mix::CPU_FEATURE_MMX:
			__asm 
			{
				pxor mm0, mm0           // executing MMX instruction
				emms
			}
			break;
		}
	}
	__except( EXCEPTION_EXECUTE_HANDLER )
	{
		return False;
    }

	return True;
}

}
