﻿using NMeCab;
using NMeCab.Extension.IpaDic;
using Xunit;

namespace LibNMeCabTest
{
    public class IpaDicFeatureExtensionTest
    {
        [Fact]
        public void TestMethod1()
        {
            var node = new MeCabNode
            {
                Feature = "品詞,品詞細分類1,品詞細分類2,品詞細分類3,活用形,活用型,原形,読み,発音"
            };
            Assert.Equal("品詞", node.GetPartsOfSpeech());
            Assert.Equal("品詞細分類1", node.GetPartsOfSpeechSection1());
            Assert.Equal("品詞細分類2", node.GetPartsOfSpeechSection2());
            Assert.Equal("品詞細分類3", node.GetPartsOfSpeechSection3());
            Assert.Equal("活用形", node.GetConjugatedForm());
            Assert.Equal("活用型", node.GetInflection());
            Assert.Equal("原形", node.GetOriginalForm());
            Assert.Equal("読み", node.GetReading());
            Assert.Equal("発音", node.GetPronounciation());
        }

        [Fact]
        public void TestMethod2()
        {
            var node = new MeCabNode
            {
                Feature = ",,,,,,,,"
            };
            Assert.Equal("", node.GetPartsOfSpeech());
            Assert.Equal("", node.GetPartsOfSpeechSection1());
            Assert.Equal("", node.GetPartsOfSpeechSection2());
            Assert.Equal("", node.GetPartsOfSpeechSection3());
            Assert.Equal("", node.GetConjugatedForm());
            Assert.Equal("", node.GetInflection());
            Assert.Equal("", node.GetOriginalForm());
            Assert.Equal("", node.GetReading());
            Assert.Equal("", node.GetPronounciation());
        }

        [Fact]
        public void TestMethod3()
        {
            var node = new MeCabNode
            {
                Feature = null
            };
            Assert.Null(node.GetPartsOfSpeech());
            Assert.Null(node.GetPartsOfSpeechSection1());
            Assert.Null(node.GetPartsOfSpeechSection2());
            Assert.Null(node.GetPartsOfSpeechSection3());
            Assert.Null(node.GetConjugatedForm());
            Assert.Null(node.GetInflection());
            Assert.Null(node.GetOriginalForm());
            Assert.Null(node.GetReading());
            Assert.Null(node.GetPronounciation());
        }

        [Fact]
        public void TestMethod4()
        {
            var node = new MeCabNode
            {
                Feature = ""
            };
            Assert.Equal("", node.GetPartsOfSpeech());
            Assert.Null(node.GetPartsOfSpeechSection1());
            Assert.Null(node.GetPartsOfSpeechSection2());
            Assert.Null(node.GetPartsOfSpeechSection3());
            Assert.Null(node.GetConjugatedForm());
            Assert.Null(node.GetInflection());
            Assert.Null(node.GetOriginalForm());
            Assert.Null(node.GetReading());
            Assert.Null(node.GetPronounciation());
        }

        [Fact]
        public void TestMethod5()
        {
            var node = new MeCabNode
            {
                Feature = "品詞"
            };
            Assert.Equal("品詞", node.GetPartsOfSpeech());
            Assert.Null(node.GetPartsOfSpeechSection1());
            Assert.Null(node.GetPartsOfSpeechSection2());
            Assert.Null(node.GetPartsOfSpeechSection3());
            Assert.Null(node.GetConjugatedForm());
            Assert.Null(node.GetInflection());
            Assert.Null(node.GetOriginalForm());
            Assert.Null(node.GetReading());
            Assert.Null(node.GetPronounciation());
        }

        [Fact]
        public void TestMethod6()
        {
            var node = new MeCabNode
            {
                Feature = "品詞,品詞細分類1"
            };
            Assert.Equal("品詞", node.GetPartsOfSpeech());
            Assert.Equal("品詞細分類1", node.GetPartsOfSpeechSection1());
            Assert.Null(node.GetPartsOfSpeechSection2());
            Assert.Null(node.GetPartsOfSpeechSection3());
            Assert.Null(node.GetConjugatedForm());
            Assert.Null(node.GetInflection());
            Assert.Null(node.GetOriginalForm());
            Assert.Null(node.GetReading());
            Assert.Null(node.GetPronounciation());
        }

        [Fact]
        public void TestMethod7()
        {
            var node = new MeCabNode
            {
                Feature = "品詞,品詞細分類1,"
            };
            Assert.Equal("品詞", node.GetPartsOfSpeech());
            Assert.Equal("品詞細分類1", node.GetPartsOfSpeechSection1());
            Assert.Equal("", node.GetPartsOfSpeechSection2());
            Assert.Null(node.GetPartsOfSpeechSection3());
            Assert.Null(node.GetConjugatedForm());
            Assert.Null(node.GetInflection());
            Assert.Null(node.GetOriginalForm());
            Assert.Null(node.GetReading());
            Assert.Null(node.GetPronounciation());
        }
    }
}
