﻿using System;
using NMeCab;

namespace ConsoleApp
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            try
            {
                var sentence = @"吾輩は猫である。名前はまだない。";
                var param = new MeCabParam();
                param.DicDir = @"../../dic/ipadic";

                var t = MeCabTagger.Create(param);
                var node = t.ParseToNode(sentence);
                while (node != null)
                {
                    if (node.CharType > 0)
                    {
                        Console.WriteLine(node.Surface + "\t" + node.Feature);
                    }

                    node = node.Next;
                }

                Console.WriteLine();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            finally
            {
                Console.Read();
            }
        }
    }
}
