﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Vintagestory.API.Client;
using Vintagestory.API.Common;
using Vintagestory.API.Common.Entities;
using Vintagestory.API.MathTools;

using Vintagestory.GameContent;

namespace ArmourMod
{
	public class ArmourMeshRenderer : IRenderer
	{ 		
		protected ICoreClientAPI ClientApi { get; set; }
		private Dictionary<AssetLocation,ArmourModelData> Armoury;

		public double RenderOrder
		{
			get { return 1; }//First? Last??
		}

		public int RenderRange
		{
			get { return 99; }//Units of?
		}			

		public ArmourMeshRenderer(ICoreClientAPI capi,Dictionary<AssetLocation,ArmourModelData> armoury )
		{
			this.ClientApi = capi;
			this.Armoury = armoury;
			//Pre-cached up ALL the damm armours; Mesh + Texture, Translations, Origins, other important parameters
		}

		public void OnRenderFrame(float deltaTime, EnumRenderStage stage)
		{			
			for (int i = 0; i < ClientApi.World.AllPlayers.Length; i++)
			{
				var aPlayer = ClientApi.World.AllPlayers[i];

				if ( aPlayer != null ) {
					
					EntityShapeRenderer rend = aPlayer.Entity.Properties.Client.Renderer as EntityShapeRenderer;
				
					if ( rend == null )
						continue;

					if (aPlayer.Entity is EntityArmourPlayer)
					{
					EntityArmourPlayer armouredPlayer = aPlayer.Entity as EntityArmourPlayer;

						if ( armouredPlayer.WornClothesItems.Count > 0 ) {
							
							RenderWornArmour( armouredPlayer, rend, stage != EnumRenderStage.Opaque );

						}
					}
				}
			}
		}

		/// <summary>
		/// The magic happens here (partly).
		/// </summary>
		/// <param name="armouredPlayer">Armoured player.</param>
		/// <param name="entityShapeRender">Entity shape render.</param>
		/// <param name="isShadowPass">If set to <c>true</c> is shadow pass.</param>
		private void RenderWornArmour(EntityArmourPlayer armouredPlayer, EntityShapeRenderer entityShapeRender, bool isShadowPass)
		{
			IRenderAPI rpi = ClientApi.Render;

			foreach(var wornItemTuple in armouredPlayer.WornClothesItems) {

				if ( !Armoury.ContainsKey( wornItemTuple.Value.Code ) ) {
					ClientApi.Logger.Warning( "Armoury Item Missing KEY: {0} ! ** RENDER ABORTED **", wornItemTuple.Value.Code );
					return;
				}

				AttachmentPointAndPose attachPoise;

				switch(wornItemTuple.Key) {

				case (EnumCharacterDressType.UpperBodyOver):
					attachPoise = armouredPlayer.AnimManager.Animator.GetAttachmentPointPose( "ARMOUR_Chest" );
					break;

				case (EnumCharacterDressType.Head):
					attachPoise = armouredPlayer.AnimManager.Animator.GetAttachmentPointPose( "ARMOUR_Head" );
					break;
				
				default:
					attachPoise = null;
					ClientApi.Logger.Warning( "Unsupported armour Attachment Type: {0} ! ** RENDER ABORTED **", wornItemTuple.Key.ToString() );
					return;				
				}

				ArmourModelData armourData = Armoury[wornItemTuple.Value.Code];
				Item armourItem = wornItemTuple.Value;
				AttachmentPoint attachPt = attachPoise.AttachPoint;

				float[] animModelMat = attachPoise.CachedPose.AnimModelMatrix;

				Matrixf viewMatrix = new Matrixf( );//float[] viewMatrix = Mat4f.Create( );
				Matrixf modelMatrix = new Matrixf( );//float[] modelMatrix = Mat4f.Create();

				viewMatrix.Set( ClientApi.Render.CameraMatrixOriginf );

				modelMatrix.Mul( animModelMat );//Right variables? not viewMatrix?

				IStandardShaderProgram prog = null;

				if ( isShadowPass ) {
					//Shadow shader?

					rpi.CurrentActiveShader.BindTexture2D( "tex2d", armourData.Armour_TextureId, 0 );
				} else {
					
					//IStandardShaderProgram PreparedStandardShader(int posX, int posY, int posZ);
					prog = rpi.PreparedStandardShader( (int)armouredPlayer.Pos.X, (int)armouredPlayer.Pos.Y, (int)armouredPlayer.Pos.Z );
					prog.Tex2D = armourData.Armour_TextureId;
					prog.AlphaTest = 0.01f;
				}
			
				//armouredPlayer.Pos.Pitch ???
				//Identity() ???
				modelMatrix
				.Translate(armourData.Armour_Transform.Origin.X, armourData.Armour_Transform.Origin.Y, armourData.Armour_Transform.Origin.Z )
				.Scale( armourData.Armour_Transform.ScaleXYZ.X, armourData.Armour_Transform.ScaleXYZ.Y, armourData.Armour_Transform.ScaleXYZ.Z )
				.Translate( attachPt.PosX / 16d + armourData.Armour_Transform.Translation.X, attachPt.PosY / 16d + armourData.Armour_Transform.Translation.Y, attachPt.PosZ / 16d + armourData.Armour_Transform.Translation.Z )
					/*
				.RotateX(  (float)(attachPt.RotationX + armourData.Armour_Transform.Rotation.X) * GameMath.DEG2RAD )
				.RotateY(  (float)(attachPt.RotationY + armourData.Armour_Transform.Rotation.Y) * GameMath.DEG2RAD )
				.RotateZ(  (float)(attachPt.RotationZ + armourData.Armour_Transform.Rotation.Z) * GameMath.DEG2RAD );
				*/
				.RotateX( armouredPlayer.Pos.Pitch * GameMath.DEG2RAD )
				.RotateY( armouredPlayer.Pos.Yaw * GameMath.DEG2RAD )
				.RotateZ( armouredPlayer.Pos.Roll * GameMath.DEG2RAD );

				/*
				modelMatrix.RotateX(  (float)attachPoise.CachedPose.degX * GameMath.DEG2RAD );
				modelMatrix.RotateY(  (float)attachPoise.CachedPose.degY * GameMath.DEG2RAD );
				modelMatrix.RotateZ(  (float)attachPoise.CachedPose.degZ * GameMath.DEG2RAD );
				*/

				/*
				modelMatrix.RotateX( armouredPlayer.Pos.Pitch * GameMath.DEG2RAD );
				modelMatrix.RotateY( armouredPlayer.Pos.Yaw * GameMath.DEG2RAD );
				modelMatrix.RotateZ( armouredPlayer.Pos.Roll * GameMath.DEG2RAD );
				*/


				if ( isShadowPass ) {
					modelMatrix.Mul(ClientApi.Render.CurrentShadowProjectionMatrix);
					ClientApi.Render.CurrentActiveShader.UniformMatrix( "mvpMatrix", modelMatrix.Values );
					ClientApi.Render.CurrentActiveShader.Uniform( "origin", new Vec3f());//OpenGL version of CONST/GLOBAL <-- what is VALUE???
				} else {
					prog.ModelMatrix = modelMatrix.Values;
					prog.ViewMatrix = viewMatrix.Values;
					prog.ProjectionMatrix = ClientApi.Render.CurrentProjectionMatrix;
				}

				ClientApi.Render.RenderMesh( armourData.ArmourMeshReference );


				if ( !isShadowPass )
					prog.Stop( );
			}
		}

		public void Dispose()
		{
			//Manually clean up Meshs'
			foreach(ArmourModelData armr in Armoury.Values) 
			{				
				ClientApi.Render.DeleteMesh( armr.ArmourMeshReference );
			}

		}

	}
}

