﻿
using Vintagestory.API.Client;
using Vintagestory.API.Common;



namespace Automap
{
	public partial class AutomapMod : ModSystem
	{
		private ICoreAPI API { get; set; }
		private ICoreClientAPI ClientAPI { get; set; }
		private ILogger Logger { get; set; }



		public override bool ShouldLoad(EnumAppSide forSide)
		{
			return forSide.IsClient();
		}

		public override void StartClientSide(ICoreClientAPI api)
		{			
			this.API = api;

			if (api.Side == EnumAppSide.Client) {
			this.ClientAPI = api as ICoreClientAPI;
			this.Logger = Mod.Logger;

			ClientAPI.Logger.VerboseDebug("Automap Present!");
			ClientAPI.Event.LevelFinalize += StartAutomap;
			}

			base.StartClientSide(api);
		}

		public override double ExecuteOrder( )
		{
		return 0.2;
		}




	}
}

