﻿using System;
using System.Collections.Generic;

using Vintagestory.API.Common;
using Vintagestory.API.Common.Entities;
using Vintagestory.API.Server;

namespace AdminToolkit
{
	public class MechTurk: IPlayer, IServerPlayer
	{
		private ILogger Logger;

		public MechTurk( IPlayerRole role, ILogger logger)
		{
			this.Role = role;
			Logger = logger;
		}

		public int ClientId {
			get {
				return -1;
			}
		}

		public EnumClientState ConnectionState {
			get {
				return EnumClientState.Connected;
			}
		}

		public BlockSelection CurrentBlockSelection {
			get {
				throw new NotImplementedException( );
			}
		}

		public int CurrentChunkSentRadius {
			get {
				throw new NotImplementedException( );
			}

			set {
				throw new NotImplementedException( );
			}
		}

		public EntitySelection CurrentEntitySelection {
			get {
				throw new NotImplementedException( );
			}
		}

		public List<Entitlement> Entitlements {
			get {
				throw new NotImplementedException( );
			}
		}

		public EntityPlayer Entity {
			get {
				throw new NotImplementedException( );
			}
		}

		public PlayerGroupMembership[] Groups {
			get {
				throw new NotImplementedException( );
			}
		}

		public IPlayerInventoryManager InventoryManager {
			get {
				throw new NotImplementedException( );
			}
		}

		public string IpAddress {
			get {
				return @"127.0.0.1";
			}
		}

		public string LanguageCode {
			get {
				return @"en";//ISO639-2 ?
			}
		}

		public float Ping {
			get {
				return 0.0f;
			}
		}

		public string PlayerName {
			get {
				return @"Mechanical Turk";
			}
		}

		public string PlayerUID {
			get {
				return @"console";//Keeps 'ServerEventManager' satisfied
			}
		}

		public string[] Privileges {
			get {
				return new[]{
				Privilege.buildblockseverywhere,
				Privilege.useblockseverywhere,
				Privilege.gamemode,
				Privilege.pickingrange,
				Privilege.kick,
				Privilege.ban,
				Privilege.whitelist,
				Privilege.setwelcome,
				Privilege.announce,
				Privilege.readlists,
				Privilege.give,
				Privilege.setspawn,
				Privilege.controlserver,
				Privilege.tp,
				Privilege.time,
				Privilege.grantrevoke,
				Privilege.root,
				Privilege.commandplayer,};
			}
		}

		public IPlayerRole Role {
			get; private set;
		}

		public IServerPlayerData ServerData {
			get {
				throw new NotImplementedException( );
			}
		}

		public EntityPos SpawnPosition {
			get {
				throw new NotImplementedException( );
			}
		}

		public IWorldPlayerData WorldData {
			get {
				throw new NotImplementedException( );
			}
		}

		public void BroadcastPlayerData( )
		{
			
		}

		public void ClearSpawnPosition( )
		{
			throw new NotImplementedException( );
		}

		public void Disconnect( )
		{
			throw new NotImplementedException( );
		}

		public void Disconnect(string message)
		{
			throw new NotImplementedException( );
		}

		public PlayerGroupMembership GetGroup(int groupId)
		{
		throw new NotImplementedException( );
		}

		public PlayerGroupMembership[ ] GetGroups( )
		{
		throw new NotImplementedException( );
		}

		public bool HasPrivilege(string privilegeCode)
		{
			return true;//Robot can do anything
		}

		public void SendIngameError(string code, string message = null, params object[] langparams)
		{
			
		}

		public void SendMessage(int groupId, string message, EnumChatType chatType, string data = null)
		{
			Logger.Chat("®TURK: «{0}»",message);
		}

		public void SendPositionToClient( )
		{
			throw new NotImplementedException( );
		}

		public void SetSpawnPosition(PlayerSpawnPos pos)
		{
			throw new NotImplementedException( );
		}
	}
}

