﻿using System;
using System.Collections;
using System.Collections.ObjectModel;
using System.Linq;

using Cairo;

using Vintagestory.API.Client;
using Vintagestory.API.Common;
using Vintagestory.API.Config;
using Vintagestory.API.MathTools;
using Vintagestory.API.Util;

namespace AdjustorMod
{
	public static class AdjustorSkills
	{
		public static SkillItem[ ] DefaultSkills(ICoreClientAPI capi)
		{
		SkillItem[ ] cachedModes = ObjectCacheUtil.GetOrCreate<SkillItem[ ]>(capi, @"adjustorToolModes", ( ) => {

		/* 
	    public enum RotationModes
		{
		Free = 0,
		Up = 1,
		Down = 2,
		North = 3,
		East  = 4,
		West  = 5,
		South = 6,
		} 
		*/

		return new SkillItem[ ]
		{
			new SkillItem() { Code = new AssetLocation("free"), Name = Lang.GetMatching("adjustor:rotation-free"), Description = Lang.GetMatching("adjustor:rotation-free-desc"), Data = RotationModes.Free }.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.Free)),
			new SkillItem() { Code = new AssetLocation("up"), Name = Lang.GetMatching("adjustor:rotation-up") , Data = RotationModes.Up }.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.Up)),
			new SkillItem() { Code = new AssetLocation("down"), Name = Lang.GetMatching("adjustor:rotation-down"), Data = RotationModes.Down }.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.Down)),
			new SkillItem() { Code = new AssetLocation("north"), Name = Lang.GetMatching("adjustor:rotation-north"), Data = RotationModes.North  }.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.North)),					                                                                                                                              
			new SkillItem() { Code = new AssetLocation("east"), Name = Lang.GetMatching("adjustor:rotation-east"), Data = RotationModes.East }.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.East)),
			new SkillItem() { Code = new AssetLocation("west"), Name = Lang.GetMatching("adjustor:rotation-west")	, Data = RotationModes.West	}.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.West)),
			new SkillItem() { Code = new AssetLocation("south"), Name = Lang.GetMatching("adjustor:rotation-south"), Data = RotationModes.South	}.WithIcon(capi,(cr, x, y, w, h, c) => DrawTextGlyph(cr, x, y, w, h, c, RotationModes.South)),			
		};

		});

   		return cachedModes;
		}

	



		

		#region SVG TOOL ICONS



		private static void DrawTextGlyph(Context cr, int x, int y, float width, float height, double[ ] rgba, RotationModes toolMode)
		{
		string text = string.Empty;
		TextDrawUtil stampy = new TextDrawUtil( );

		Pattern pattern = null;
		Matrix matrix = cr.Matrix;

		cr.Save( );

		ElementBounds bounds = ElementBounds.Fixed(( int )width, ( int )height);

		/*
		if (cr.GetTarget( ) is ImageSurface) {
			ImageSurface imgSurface = ( ImageSurface )cr.GetTarget( );
			bounds = ElementBounds.Fixed(imgSurface.Width, imgSurface.Height);
		}
		*/

		CairoFont font = CairoFont.WhiteMediumText( );
		font.StrokeColor = ColorUtil.BlackArgbDouble;
		font.FontWeight = FontWeight.Bold;

		switch (toolMode) {
		case RotationModes.Free:
			text = Lang.GetMatching("adjustor:rotation-free").ToUpper( );

			cr.SetSourceRGB(0D, 0.75D, 0D);
			cr.Arc(24, 24, 18, 0, 6D);
			cr.Stroke( );

			break;

		case RotationModes.Up:
			text = Lang.GetMatching("adjustor:rotation-up").ToUpper( );

			cr.SetSourceRGB(0.85D, 0.85D, 0.85D);
			cr.Rectangle(4, 4, 38, 8);
			cr.Stroke( );

			break;

		case RotationModes.Down:
			text = Lang.GetMatching("adjustor:rotation-down").ToUpper( );

			cr.SetSourceRGB(0.85D, 0.85D, 0.85D);
			cr.Rectangle(4, 34, 38, 8);
			cr.Stroke( );

			break;

		case RotationModes.North:
			text = Lang.GetMatching("facing-north").ToUpper( );

			cr.SetSourceRGB(0.95D, 0D, 0D);
			cr.MoveTo(24, 24);
			cr.RelLineTo(0, -16);
			cr.Stroke( );
			break;

		case RotationModes.East:
			text = Lang.GetMatching("facing-east").ToUpper( );

			cr.SetSourceRGB(0.85D, 0.85D, 0.85D);
			cr.LineWidth = 1.0D;
			cr.MoveTo(24, 24);
			cr.RelLineTo(16, 0);
			cr.Stroke( );
			break;

		case RotationModes.West:
			text = Lang.GetMatching("facing-west").ToUpper( );

			cr.SetSourceRGB(0.85D, 0.85D, 0.85D);
			cr.LineWidth = 1.0D;
			cr.MoveTo(24, 24);
			cr.RelLineTo(-16, 0);
			cr.Stroke( );
			break;

		case RotationModes.South:
			text = Lang.GetMatching("facing-south").ToUpper( );

			cr.SetSourceRGB(0.85D, 0.85D, 0.85D);
			cr.LineWidth = 1.0D;
			cr.MoveTo(24, 24);
			cr.RelLineTo(0, 16);
			cr.Stroke( );
			break;
		}

		cr.Operator = Operator.Over;
		pattern = new SolidPattern(rgba[0], rgba[1], rgba[2], rgba[3]);//A Struct could have: rgba.R, rgba.G, rgba.B, ...never worry about order again...
		cr.SetSource(pattern);

		cr.NewPath( );
		//cr.MoveTo(0, 16);
		cr.Tolerance = 0.1;
		cr.Antialias = Antialias.Default;
		cr.FillRule = FillRule.Winding;

		font.AutoFontSize(text, bounds);
		font.UnscaledFontsize += 25;

		stampy.DrawTextLine(cr, font, text, 4D, height / 2);

		cr.FillPreserve( );
		}


		#endregion

	}


}

