%
% This is part of LFSbookko package.
%
% This is a CTIE change file for the original XML source of the LFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Audience</title>
@y
  <title>対象読者</title>
@z

@x
<para>There are many reasons why you would want to read this book. One of the
questions many people raise is, <quote>why go through all the hassle of manually
building a Linux system from scratch when you can just download and install
an existing one?</quote></para>
@y
<para>
本書を読む理由はさまざまにあると思いますが、よく挙がってくる質問として以下があります。
<quote>既にある Linux をダウンロードしてインストールすれば良いのに、どうして苦労してまで手作業で Linux を構築しようとするのか。</quote>
</para>
@z

@x
<para>One important reason for this project's existence is to help you learn
how a Linux system works from the inside out. Building an LFS system helps
demonstrate what makes Linux tick, and how things work together and depend on
each other. One of the best things that this learning experience can provide is
the ability to customize a Linux system to suit your own unique needs.</para>
@y
<para>
本プロジェクトを提供する最大の理由は Linux システムがどのようにして動作しているのか、これを学ぶためのお手伝いをすることです。
LFS システムを構築してみれば、さまざまなものが連携し依存しながら動作している様子を知ることができます。
そうした経験をした人であれば Linux システムを自分の望む形に作りかえる手法も身につけることができます。
</para>
@z

@x
<para>Another key benefit of LFS is that it allows you to have more control
over the system without relying on someone else's Linux implementation. With
LFS, you are in the driver's seat and dictate every aspect of the
system.</para>
@y
<para>
LFS の重要な利点として、他の Linux システムに依存することなく、システムをより適切に制御できる点が挙げられます。
LFS システムではあなたが運転台に立って、システムのあらゆる側面への指示を下していきます。
</para>
@z

@x
<para>LFS allows you to create very compact Linux systems. When installing
regular distributions, you are often forced to install a great many
programs which are probably never used or understood. These programs waste
resources. You may argue that with today's hard drive and CPUs, such
resources are no longer a consideration. Sometimes, however, you are still
constrained by size considerations if nothing else. Think about bootable
CDs, USB sticks, and embedded systems. Those are areas where LFS can be
beneficial.</para>
@y
<para>
さらに非常にコンパクトな Linux システムを作る方法も身につけられます。
通常の Linux ディストリビューションを用いる場合、多くのプログラムをインストールすることになりますが、たいていのプログラムは使わないものですし、その内容もよく分からないものです。
それらのプログラムはハードウェアリソースを無駄に占有することになります。
今日のハードドライブや CPU のことを考えたら、リソース消費は大したことはないと思うかもしれません。
しかし問題がなくなったとしても、サイズの制限だけは気にかける必要があることでしょう。
例えばブータブル CD、USB スティック、組み込みシステムなどのことを思い浮かべてください。
そういったものに対して LFS は有用なものとなるでしょう。
</para>
@z

@x
<para>Another advantage of a custom built Linux system is security. By compiling
the entire system from source code, you are empowered to audit everything
and apply all the security patches desired. It is no longer necessary to
wait for somebody else to compile binary packages that fix a security hole.
Unless you examine the patch and implement it yourself, you have no
guarantee that the new binary package was built correctly and adequately
fixes the problem.</para>
@y
<para>
カスタマイズした Linux システムを構築するもう一つの利点として、セキュリティがあります。
ソースコードからコンパイルしてシステムを構築するということは、あらゆることを制御する権限を有することになり、セキュリティパッチは望みどおりに適用できます。
他の人がセキュリティホールを修正しバイナリパッケージを提供するのを待つ必要がなくなるということです。
他の人がパッチとバイナリパッケージを提供してくれたとしても、それが本当に正しく構築され、問題を解決してくれているかどうかは、調べてみなければ分からないわけですから。
</para>
@z

@x
<para>The goal of Linux From Scratch is to build a complete and usable
foundation-level system. If you do not wish to build your own Linux system
from scratch, you may not entirely benefit from the information in this
book.</para>
@y
<para>
Linux From Scratch の最終目標は、実用的で完全で、基盤となるシステムを構築することです。
Linux システムを一から作り出すつもりのない方は、本書から得られるものはないかもしれません。
</para>
@z

@x
<para>There are too many other good reasons to build your own LFS system to
list them all here. In the end, education is by far the most powerful of
reasons. As you continue in your LFS experience, you will discover the power
that information and knowledge truly bring.</para>
@y
<para>
LFS を構築する理由はさまざまですから、すべてを列記することはできません。
学習こそ、理由を突き詰める最大最良の手段です。
LFS 構築作業の経験を積むことによって、情報や知識を通じてもたらされる意義が十二分に理解できるはずです。
</para>
@z
