#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=7.3
TARGET=vim-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=vim73

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $DLD/vim-7.2-fixes-5.patch

echo '#define SYS_VIMRC_FILE "/etc/vimrc"' >> src/feature.h

echo \ \ Configuring...
./configure --prefix=/usr --enable-multibyte \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

paco -p+ $TARGET "ln -sv vim /usr/bin/vi"
for L in  /usr/share/man/{,*/}man1/vim.1; do
    paco -p+ $TARGET "ln -sv vim.1 $(dirname $L)/vi.1"
done

paco -p+ $TARGET "\
ln -sv ../vim/vim73/doc /usr/share/doc/vim-7.3"

cat > /etc/vimrc << "EOF"
" Begin /etc/vimrc

set nocompatible
set backspace=2
syntax on
if (&term == "iterm") || (&term == "putty")
  set background=dark
endif

" End /etc/vimrc
EOF
paco -p+ $TARGET "touch /etc/vimrc"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

