#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.22
TARGET=libcap2-$VER
TARGETBALL=libcap2_$VER.orig.tar.gz
TARGETDIR=libcap-$VER

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make RAISE_SETFCAP=no prefix=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

chmod -v 0755 /usr/lib/libcap.so.2.22

paco -p+ $TARGET "\
mv -v /usr/lib/libcap.so.* /lib"
paco -p+ $TARGET "\
ln -sfv ../../lib/libcap.so.2 /usr/lib/libcap.so"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

