#/bin/sh

CHAP=6
APPNAME=zlib
VER=1.2.8
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

porg -lp+ $TARGET "\
mv -v /usr/lib/libz.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libz.so) /usr/lib/libz.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

