#/bin/sh

CHAP=6
APPNAME=e2fsprogs
VER=1.42.13
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

#sed -e '/int.*old_desc_blocks/s/int/blk64_t/' \
#    -e '/if (old_desc_blocks/s/super->s_first_meta_bg/desc_blocks/' \
#    -i lib/ext2fs/closefs.c

mkdir build
cd build

echo \ \ Configuring...
LIBS=-L/tools/lib                    \
CFLAGS=-I/tools/include              \
PKG_CONFIG_PATH=/tools/lib/pkgconfig \
../configure --prefix=/usr           \
             --bindir=/bin           \
             --with-root-prefix=""   \
             --enable-elf-shlibs     \
             --disable-libblkid      \
             --disable-libuuid       \
             --disable-uuidd         \
             --disable-fsck          \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "make install-libs" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

chmod u+w /usr/lib/{libcom_err,libe2p,libext2fs,libss}.a

porg -lp+ $TARGET "gunzip -v /usr/share/info/libext2fs.info.gz" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install-info --dir-file=/usr/share/info/dir /usr/share/info/libext2fs.info" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

makeinfo -o      doc/com_err.info ../lib/et/com_err.texinfo
porg -lp+ $TARGET "\
install -v -m644 doc/com_err.info /usr/share/info" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install-info --dir-file=/usr/share/info/dir /usr/share/info/com_err.info" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo \ \ Done.

