#/bin/sh

CHAP=5
APPNAME=gettext
VER=0.19.6
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
cd gettext-tools
EMACS="no" ./configure --prefix=/tools --disable-shared \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make -C gnulib-lib \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make -C intl pluralx.c \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make -C src msgfmt \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make -C src msgmerge \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make -C src xgettext \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

cp -v src/{msgfmt,msgmerge,xgettext} /tools/bin \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo \ \ Done.

