#/bin/sh

. ./_clfsset.sh

APPNAME=xz
VER=5.0.5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
    --libdir=/usr/lib64 --docdir=/usr/share/doc/xz-5.0.5 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/bin/{xz,lzma,lzcat,unlzma,unxz,xzcat} /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/lib64/liblzma.so.* /lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib64/$(readlink /usr/lib64/liblzma.so) /usr/lib64/liblzma.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
