#/bin/sh

. ./_clfsset.sh

APPNAME=util-linux
VER=2.24.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i -e 's@etc/adjtime@var/lib/hwclock/adjtime@g' \
    $(grep -rl '/etc/adjtime' .)
mkdir -pv /var/lib/hwclock

echo Configuring...
CC="gcc ${BUILD64}" ./configure --libdir=/lib64 \
    --enable-write --docdir=/usr/share/doc/util-linux-2.24.2 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
