#!/bin/sh

. ./_blfsset.sh

APPNAME=scons
VER=2.3.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}-$VER.tar.gz
TARGETDIR=${APPNAME}-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	python
. $WRK/_checkOptions.sh  \
	docbook-xsl libxml2 libxslt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
porg -lp $TARGET "\
python setup.py install --prefix=/usr  \
                        --standard-lib \
                        --optimize=1   \
                        --install-data=/usr/share" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

